/*     */ package org.jboss.mx.capability;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Iterator;
/*     */ import javax.management.Attribute;
/*     */ import javax.management.AttributeList;
/*     */ import javax.management.AttributeNotFoundException;
/*     */ import javax.management.DynamicMBean;
/*     */ import javax.management.InvalidAttributeValueException;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanConstructorInfo;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanNotificationInfo;
/*     */ import javax.management.MBeanOperationInfo;
/*     */ import javax.management.NotificationBroadcaster;
/*     */ import javax.management.ReflectionException;
/*     */ import javax.management.RuntimeErrorException;
/*     */ import javax.management.RuntimeMBeanException;
/*     */ import javax.management.RuntimeOperationsException;
/*     */ import org.jboss.mx.metadata.AttributeOperationResolver;
/*     */ 
/*     */ public class ReflectedMBeanDispatcher
/*     */   implements DynamicMBean
/*     */ {
/*  55 */   private Object resource = null;
/*     */ 
/*  57 */   private AttributeOperationResolver resolver = null;
/*  58 */   private MBeanConstructorInfo[] constructorInfo = null;
/*  59 */   private MBeanAttributeInfo[] attributeInfo = null;
/*  60 */   private MBeanOperationInfo[] operationInfo = null;
/*     */ 
/*  62 */   private Method[] operations = null;
/*  63 */   private MethodPair[] attributes = null;
/*     */ 
/*  65 */   private boolean isBroadcaster = false;
/*     */ 
/*  67 */   private String resourceClassName = null;
/*  68 */   private String resourceDescription = null;
/*     */ 
/*     */   public ReflectedMBeanDispatcher(MBeanInfo mbinfo, AttributeOperationResolver resolver, Object resource)
/*     */   {
/*  72 */     if (null == resource)
/*     */     {
/*  74 */       throw new IllegalArgumentException("resource cannot be null");
/*     */     }
/*     */ 
/*  77 */     if (null == mbinfo)
/*     */     {
/*  79 */       throw new IllegalArgumentException("MBeanInfo cannot be null");
/*     */     }
/*     */ 
/*  82 */     if (null == resolver)
/*     */     {
/*  84 */       throw new IllegalArgumentException("AOresolver cannot be null");
/*     */     }
/*     */ 
/*  88 */     if ((resource instanceof NotificationBroadcaster))
/*     */     {
/*  90 */       this.isBroadcaster = true;
/*     */     }
/*     */ 
/*  93 */     this.resource = resource;
/*  94 */     this.resolver = resolver;
/*  95 */     this.resourceClassName = mbinfo.getClassName();
/*  96 */     this.resourceDescription = mbinfo.getDescription();
/*  97 */     this.constructorInfo = mbinfo.getConstructors();
/*  98 */     this.attributeInfo = mbinfo.getAttributes();
/*  99 */     this.operationInfo = mbinfo.getOperations();
/*     */ 
/* 101 */     this.operations = new Method[this.operationInfo.length];
/* 102 */     this.attributes = new MethodPair[this.attributeInfo.length];
/*     */   }
/*     */ 
/*     */   public void bindOperationAt(int position, Method method)
/*     */   {
/*     */     try
/*     */     {
/* 109 */       this.operations[position] = method;
/*     */     }
/*     */     catch (ArrayIndexOutOfBoundsException e)
/*     */     {
/* 113 */       throw new IllegalArgumentException("position out of bounds: " + position);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void bindAttributeAt(int position, Method getter, Method setter)
/*     */   {
/*     */     try
/*     */     {
/* 121 */       this.attributes[position] = new MethodPair(getter, setter);
/*     */     }
/*     */     catch (ArrayIndexOutOfBoundsException e)
/*     */     {
/* 125 */       throw new IllegalArgumentException("position out of bounds: " + position);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getResourceClassName()
/*     */   {
/* 131 */     return this.resourceClassName;
/*     */   }
/*     */ 
/*     */   public Object getAttribute(String attribute)
/*     */     throws AttributeNotFoundException, MBeanException, ReflectionException
/*     */   {
/* 137 */     if (null == attribute)
/*     */     {
/* 139 */       throw new RuntimeOperationsException(new IllegalArgumentException("attribute cannot be null"));
/*     */     }
/*     */ 
/* 142 */     Method m = null;
/*     */     try
/*     */     {
/* 145 */       m = this.attributes[this.resolver.lookup(attribute).intValue()].getter;
/* 146 */       return m.invoke(this.resource, new Object[0]);
/*     */     }
/*     */     catch (NullPointerException e)
/*     */     {
/* 150 */       throw new AttributeNotFoundException("Readable attribute '" + attribute + "' not found");
/*     */     }
/*     */     catch (ArrayIndexOutOfBoundsException e)
/*     */     {
/* 154 */       throw new AttributeNotFoundException("Readable attribute '" + attribute + "' not found");
/*     */     }
/*     */     catch (InvocationTargetException e)
/*     */     {
/* 158 */       Throwable t = e.getTargetException();
/* 159 */       if ((t instanceof RuntimeException))
/*     */       {
/* 161 */         throw new RuntimeMBeanException((RuntimeException)t, "RuntimeException in MBean when getting attribute '" + attribute + "'");
/*     */       }
/* 163 */       if ((t instanceof Exception))
/*     */       {
/* 165 */         throw new MBeanException((Exception)t, "Exception in MBean when getting attribute '" + attribute + "'");
/*     */       }
/*     */ 
/* 169 */       throw new RuntimeErrorException((Error)t, "Error in MBean when getting attribute '" + attribute + "'");
/*     */     }
/*     */     catch (IllegalArgumentException e)
/*     */     {
/* 174 */       throw new AttributeNotFoundException("Readable attribute '" + attribute + "' not found");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 178 */       throw new ReflectionException(e, "Exception in AttributeProvider for getting '" + attribute + "'");
/*     */     }
/*     */     catch (Error e) {
/*     */     }
/* 182 */     throw new RuntimeErrorException(e, "Error in AttributeProvider for getting '" + attribute + "'");
/*     */   }
/*     */ 
/*     */   public void setAttribute(Attribute attribute)
/*     */     throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException
/*     */   {
/* 191 */     if (null == attribute)
/*     */     {
/* 193 */       throw new RuntimeOperationsException(new IllegalArgumentException("attribute cannot be null"));
/*     */     }
/*     */ 
/* 196 */     Method m = null;
/*     */     try
/*     */     {
/* 199 */       m = this.attributes[this.resolver.lookup(attribute.getName()).intValue()].setter;
/* 200 */       m.invoke(this.resource, new Object[] { attribute.getValue() });
/*     */     }
/*     */     catch (NullPointerException e)
/*     */     {
/* 204 */       throw new AttributeNotFoundException("Writable attribute '" + attribute.getName() + "' not found");
/*     */     }
/*     */     catch (ArrayIndexOutOfBoundsException e)
/*     */     {
/* 208 */       throw new AttributeNotFoundException("Writable attribute '" + attribute.getName() + "' not found");
/*     */     }
/*     */     catch (InvocationTargetException e)
/*     */     {
/* 212 */       Throwable t = e.getTargetException();
/* 213 */       if ((t instanceof RuntimeException))
/*     */       {
/* 215 */         throw new RuntimeMBeanException((RuntimeException)t, "RuntimeException in MBean when setting attribute '" + attribute.getName() + "'");
/*     */       }
/* 217 */       if ((t instanceof Exception))
/*     */       {
/* 219 */         throw new MBeanException((Exception)t, "Exception in MBean when setting attribute '" + attribute.getName() + "'");
/*     */       }
/*     */ 
/* 223 */       throw new RuntimeErrorException((Error)t, "Error in MBean when setting attribute '" + attribute.getName() + "'");
/*     */     }
/*     */     catch (IllegalArgumentException e)
/*     */     {
/* 228 */       String valueType = null == attribute.getValue() ? "<null value>" : attribute.getValue().getClass().getName();
/* 229 */       throw new InvalidAttributeValueException("Attribute value mismatch while setting '" + attribute.getName() + "': " + valueType);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 233 */       throw new ReflectionException(e, "Exception in AttributeProvider for setting '" + attribute.getName() + "'");
/*     */     }
/*     */     catch (Error e)
/*     */     {
/* 237 */       throw new RuntimeErrorException(e, "Error in AttributeProvider for setting '" + attribute.getName() + "'");
/*     */     }
/*     */   }
/*     */ 
/*     */   public AttributeList getAttributes(String[] attributes)
/*     */   {
/* 244 */     if (null == attributes)
/*     */     {
/* 246 */       throw new RuntimeOperationsException(new IllegalArgumentException("attributes array cannot be null"));
/*     */     }
/*     */ 
/* 249 */     AttributeList list = new AttributeList();
/* 250 */     for (int i = 0; i < attributes.length; i++)
/*     */     {
/*     */       try
/*     */       {
/* 254 */         list.add(new Attribute(attributes[i], getAttribute(attributes[i])));
/*     */       }
/*     */       catch (Throwable e)
/*     */       {
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 262 */     return list;
/*     */   }
/*     */ 
/*     */   public AttributeList setAttributes(AttributeList attributes)
/*     */   {
/* 267 */     if (null == attributes)
/*     */     {
/* 269 */       throw new RuntimeOperationsException(new IllegalArgumentException("attribute list cannot be null"));
/*     */     }
/*     */ 
/* 272 */     AttributeList list = new AttributeList();
/* 273 */     for (Iterator iterator = attributes.iterator(); iterator.hasNext(); )
/*     */     {
/* 275 */       Attribute toSet = (Attribute)iterator.next();
/*     */       try
/*     */       {
/* 278 */         setAttribute(toSet);
/* 279 */         list.add(toSet);
/*     */       }
/*     */       catch (Throwable e)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/* 286 */     return list;
/*     */   }
/*     */ 
/*     */   public Object invoke(String actionName, Object[] params, String[] signature)
/*     */     throws MBeanException, ReflectionException
/*     */   {
/* 294 */     Method m = null;
/*     */     try
/*     */     {
/* 297 */       m = this.operations[this.resolver.lookup(actionName, signature).intValue()];
/* 298 */       return m.invoke(this.resource, params);
/*     */     }
/*     */     catch (NullPointerException e)
/*     */     {
/* 302 */       throw new ReflectionException(new NoSuchMethodException("Unable to locate MBean operation for: " + opKeyString(actionName, signature)));
/*     */     }
/*     */     catch (ArrayIndexOutOfBoundsException e)
/*     */     {
/* 306 */       throw new ReflectionException(new NoSuchMethodException("Unable to locate MBean operation for: " + opKeyString(actionName, signature)));
/*     */     }
/*     */     catch (InvocationTargetException e)
/*     */     {
/* 310 */       Throwable t = e.getTargetException();
/* 311 */       if ((t instanceof RuntimeException))
/*     */       {
/* 313 */         throw new RuntimeMBeanException((RuntimeException)t, "RuntimeException in MBean operation '" + opKeyString(actionName, signature) + "'");
/*     */       }
/* 315 */       if ((t instanceof Exception))
/*     */       {
/* 317 */         throw new MBeanException((Exception)t, "Exception in MBean operation '" + opKeyString(actionName, signature) + "'");
/*     */       }
/*     */ 
/* 321 */       throw new RuntimeErrorException((Error)t, "Error in MBean operation '" + opKeyString(actionName, signature) + "'");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 326 */       throw new ReflectionException(e, "Exception when calling method for '" + opKeyString(actionName, signature) + "'");
/*     */     }
/*     */     catch (Error e) {
/*     */     }
/* 330 */     throw new RuntimeErrorException(e, "Error when calling method for '" + opKeyString(actionName, signature) + "'");
/*     */   }
/*     */ 
/*     */   public MBeanInfo getMBeanInfo()
/*     */   {
/* 337 */     return new MBeanInfo(this.resourceClassName, this.resourceDescription, this.attributeInfo, this.constructorInfo, this.operationInfo, this.isBroadcaster ? getNotificationInfo() : new MBeanNotificationInfo[0]);
/*     */   }
/*     */ 
/*     */   protected MBeanNotificationInfo[] getNotificationInfo()
/*     */   {
/* 346 */     if (this.isBroadcaster)
/*     */     {
/* 348 */       return ((NotificationBroadcaster)this.resource).getNotificationInfo();
/*     */     }
/*     */ 
/* 352 */     throw new RuntimeOperationsException(new UnsupportedOperationException("resource is not a NotificationBroadcaster"));
/*     */   }
/*     */ 
/*     */   protected Object getResourceObject()
/*     */   {
/* 358 */     return this.resource;
/*     */   }
/*     */ 
/*     */   protected final String opKeyString(String name, String[] signature)
/*     */   {
/* 364 */     StringBuffer buf = new StringBuffer(name).append('(');
/* 365 */     if (null != signature)
/*     */     {
/* 367 */       for (int i = 0; i < signature.length - 1; i++)
/* 368 */         buf.append(signature[i]).append(',');
/* 369 */       if (signature.length > 0)
/* 370 */         buf.append(signature[(signature.length - 1)]);
/*     */     }
/* 372 */     return ')';
/*     */   }
/*     */ 
/*     */   public static class MethodPair
/*     */   {
/* 377 */     public Method getter = null;
/* 378 */     public Method setter = null;
/*     */ 
/*     */     public MethodPair(Method getter, Method setter)
/*     */     {
/* 382 */       this.getter = getter;
/* 383 */       this.setter = setter;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.capability.ReflectedMBeanDispatcher
 * JD-Core Version:    0.6.0
 */