/*     */ package org.jboss.mx.capability;
/*     */ 
/*     */ import java.io.BufferedOutputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanOperationInfo;
/*     */ import javax.management.MBeanParameterInfo;
/*     */ import javax.management.ReflectionException;
/*     */ import org.apache.bcel.classfile.JavaClass;
/*     */ import org.apache.bcel.generic.AALOAD;
/*     */ import org.apache.bcel.generic.ACONST_NULL;
/*     */ import org.apache.bcel.generic.ALOAD;
/*     */ import org.apache.bcel.generic.ARETURN;
/*     */ import org.apache.bcel.generic.ASTORE;
/*     */ import org.apache.bcel.generic.ArrayType;
/*     */ import org.apache.bcel.generic.CHECKCAST;
/*     */ import org.apache.bcel.generic.ClassGen;
/*     */ import org.apache.bcel.generic.ConstantPoolGen;
/*     */ import org.apache.bcel.generic.DLOAD;
/*     */ import org.apache.bcel.generic.DSTORE;
/*     */ import org.apache.bcel.generic.FLOAD;
/*     */ import org.apache.bcel.generic.FSTORE;
/*     */ import org.apache.bcel.generic.IFEQ;
/*     */ import org.apache.bcel.generic.IFNULL;
/*     */ import org.apache.bcel.generic.ILOAD;
/*     */ import org.apache.bcel.generic.INVOKESPECIAL;
/*     */ import org.apache.bcel.generic.INVOKEVIRTUAL;
/*     */ import org.apache.bcel.generic.ISTORE;
/*     */ import org.apache.bcel.generic.InstructionHandle;
/*     */ import org.apache.bcel.generic.InstructionList;
/*     */ import org.apache.bcel.generic.LDC;
/*     */ import org.apache.bcel.generic.LLOAD;
/*     */ import org.apache.bcel.generic.LSTORE;
/*     */ import org.apache.bcel.generic.MethodGen;
/*     */ import org.apache.bcel.generic.NEW;
/*     */ import org.apache.bcel.generic.ObjectType;
/*     */ import org.apache.bcel.generic.PUSH;
/*     */ import org.apache.bcel.generic.RETURN;
/*     */ import org.apache.bcel.generic.Type;
/*     */ import org.jboss.mx.metadata.AttributeOperationResolver;
/*     */ import org.jboss.mx.server.ServerConstants;
/*     */ 
/*     */ public class OptimizedMBeanDispatcher
/*     */   implements ServerConstants
/*     */ {
/*  62 */   static final Class SUPER_CLASS = ReflectedMBeanDispatcher.class;
/*     */ 
/*     */   public static ReflectedMBeanDispatcher create(MBeanInfo info, Object resource)
/*     */   {
/*     */     try
/*     */     {
/*  71 */       String className = resource.getClass().getName().replace('.', '_') + "_Dispatcher";
/*  72 */       String superClass = SUPER_CLASS.getName();
/*  73 */       String fileName = className + ".class";
/*  74 */       int modifiers = 1;
/*  75 */       String[] interfaces = new String[0];
/*     */ 
/*  77 */       ClassGen clazz = new ClassGen(className, superClass, fileName, modifiers, interfaces);
/*  78 */       ConstantPoolGen cp = clazz.getConstantPool();
/*     */ 
/*  80 */       clazz.addMethod(createConstructor(cp, className).getMethod());
/*  81 */       clazz.addMethod(createInvoke(cp, info, className, resource.getClass().getName()).getMethod());
/*  82 */       clazz.update();
/*     */ 
/*  84 */       JavaClass c = clazz.getJavaClass();
/*     */ 
/*  86 */       ByteArrayOutputStream baos = new ByteArrayOutputStream(2000);
/*  87 */       BufferedOutputStream bos = new BufferedOutputStream(baos);
/*  88 */       c.dump(bos);
/*     */ 
/*  92 */       ClassLoader ocl = new DispatchClassLoader(resource.getClass().getClassLoader(), className, baos.toByteArray());
/*     */ 
/*  94 */       Class dispatcherClass = ocl.loadClass(className);
/*  95 */       Constructor constr = dispatcherClass.getConstructor(new Class[] { MBeanInfo.class, AttributeOperationResolver.class, Object.class });
/*     */ 
/*  99 */       Object o = constr.newInstance(new Object[] { info, new AttributeOperationResolver(info), resource });
/*     */ 
/* 101 */       return (ReflectedMBeanDispatcher)o;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 105 */       e.printStackTrace();
/* 106 */     }throw new Error();
/*     */   }
/*     */ 
/*     */   public static String getMethodDescriptor(MBeanParameterInfo[] signature, String returnType)
/*     */   {
/* 150 */     StringBuffer sign = new StringBuffer(256);
/* 151 */     sign.append("(");
/*     */ 
/* 153 */     for (int i = 0; i < signature.length; i++) {
/* 154 */       sign.append(getDescriptorForType(signature[i].getName()));
/*     */     }
/* 156 */     sign.append(")" + getDescriptorForType(returnType));
/*     */ 
/* 158 */     return sign.toString();
/*     */   }
/*     */ 
/*     */   public static String getDescriptorForType(String name)
/*     */   {
/* 176 */     if (name.equals(Byte.TYPE.getName())) return "B";
/* 177 */     if (name.equals(Character.TYPE.getName())) return "C";
/* 178 */     if (name.equals(Double.TYPE.getName())) return "D";
/* 179 */     if (name.equals(Float.TYPE.getName())) return "F";
/* 180 */     if (name.equals(Integer.TYPE.getName())) return "I";
/* 181 */     if (name.equals(Long.TYPE.getName())) return "J";
/* 182 */     if (name.equals(Short.TYPE.getName())) return "S";
/* 183 */     if (name.equals(Boolean.TYPE.getName())) return "Z";
/* 184 */     if (name.equals(Void.TYPE.getName())) return "V";
/* 185 */     if (name.startsWith("[")) return name.replace('.', '/');
/* 186 */     return "L" + name.replace('.', '/') + ";";
/*     */   }
/*     */ 
/*     */   public static boolean isPrimitive(String name)
/*     */   {
/* 208 */     return (name.equals(Byte.TYPE.getName())) || (name.equals(Character.TYPE.getName())) || (name.equals(Double.TYPE.getName())) || (name.equals(Float.TYPE.getName())) || (name.equals(Integer.TYPE.getName())) || (name.equals(Long.TYPE.getName())) || (name.equals(Short.TYPE.getName())) || (name.equals(Boolean.TYPE.getName()));
/*     */   }
/*     */ 
/*     */   protected static MethodGen createConstructor(ConstantPoolGen cp, String className)
/*     */   {
/* 226 */     InstructionList constrInstructions = new InstructionList();
/*     */ 
/* 228 */     int constrRefIndex = cp.addMethodref(SUPER_CLASS.getName(), "<init>", "(" + getDescriptorForType(MBeanInfo.class.getName()) + getDescriptorForType(AttributeOperationResolver.class.getName()) + getDescriptorForType(Object.class.getName()) + ")V");
/*     */ 
/* 237 */     constrInstructions.append(new ALOAD(0));
/* 238 */     constrInstructions.append(new ALOAD(1));
/* 239 */     constrInstructions.append(new ALOAD(2));
/* 240 */     constrInstructions.append(new ALOAD(3));
/* 241 */     constrInstructions.append(new INVOKESPECIAL(constrRefIndex));
/* 242 */     constrInstructions.append(new RETURN());
/*     */ 
/* 244 */     MethodGen constrMethod = new MethodGen(1, Type.VOID, new Type[] { new ObjectType(MBeanInfo.class.getName()), new ObjectType(AttributeOperationResolver.class.getName()), new ObjectType(Object.class.getName()) }, new String[] { "info", "resolver", "resource" }, "<init>", className, constrInstructions, cp);
/*     */ 
/* 255 */     constrMethod.setMaxStack(4);
/*     */ 
/* 257 */     return constrMethod;
/*     */   }
/*     */ 
/*     */   protected static MethodGen createInvoke(ConstantPoolGen cp, MBeanInfo info, String className, String resourceClassName)
/*     */   {
/* 298 */     InstructionList invokeInstructions = new InstructionList();
/* 299 */     MethodEntry[] operations = getOperations(info);
/*     */ 
/* 302 */     for (int i = 0; i < operations.length; i++) {
/* 303 */       operations[i].nameIndexInCP = cp.addString(operations[i].getName());
/* 304 */       operations[i].methodIndexInCP = cp.addMethodref(resourceClassName, operations[i].getName(), operations[i].methodDescriptor);
/*     */     }
/*     */ 
/* 312 */     int invokeIndex = cp.addMethodref(SUPER_CLASS.getName(), "invoke", "(" + getDescriptorForType(String.class.getName()) + getDescriptorForType([Ljava.lang.Object.class.getName()) + getDescriptorForType([Ljava.lang.String.class.getName()) + ")" + getDescriptorForType(Object.class.getName()));
/*     */ 
/* 322 */     int getResourceObjectIndex = cp.addMethodref(SUPER_CLASS.getName(), "getResourceObject", "()Ljava/lang/Object;");
/*     */ 
/* 328 */     int strEqualsIndex = cp.addMethodref(String.class.getName(), "equals", "(Ljava/lang/Object;)Z");
/*     */ 
/* 334 */     InstructionHandle beginTryBlock = null;
/* 335 */     InstructionHandle endTryBlock = null;
/*     */ 
/* 337 */     IFNULL ifOperationEqualsNull = new IFNULL(null);
/* 338 */     IFEQ operationElseIfBranch = null;
/*     */ 
/* 340 */     if (operations.length > 0)
/*     */     {
/* 345 */       invokeInstructions.append(new ALOAD(1));
/*     */ 
/* 347 */       beginTryBlock = invokeInstructions.append(ifOperationEqualsNull);
/*     */ 
/* 350 */       for (int i = 0; i < operations.length; i++)
/*     */       {
/* 355 */         InstructionHandle jumpToNextElse = invokeInstructions.append(new ALOAD(1));
/*     */ 
/* 357 */         invokeInstructions.append(new LDC(operations[i].nameIndexInCP));
/* 358 */         invokeInstructions.append(new INVOKEVIRTUAL(strEqualsIndex));
/*     */ 
/* 361 */         if (operationElseIfBranch != null) {
/* 362 */           operationElseIfBranch.setTarget(jumpToNextElse);
/*     */         }
/* 364 */         operationElseIfBranch = new IFEQ(null);
/* 365 */         invokeInstructions.append(operationElseIfBranch);
/*     */ 
/* 367 */         invokeInstructions.append(new ALOAD(0));
/* 368 */         invokeInstructions.append(new INVOKEVIRTUAL(getResourceObjectIndex));
/*     */ 
/* 370 */         int x = cp.addClass(resourceClassName);
/* 371 */         invokeInstructions.append(new CHECKCAST(x));
/*     */ 
/* 374 */         if (operations[i].getSignature().length > 0)
/*     */         {
/* 377 */           for (int arrayIndex = 0; arrayIndex < operations[i].getSignature().length; arrayIndex++)
/*     */           {
/* 379 */             invokeInstructions.append(new ALOAD(2));
/* 380 */             invokeInstructions.append(new PUSH(cp, arrayIndex));
/* 381 */             invokeInstructions.append(new AALOAD());
/*     */ 
/* 385 */             String type = operations[i].getSignature()[arrayIndex].getName();
/*     */ 
/* 387 */             if (isPrimitive(type)) {
/* 388 */               invokeInstructions.append(convertObjectToPrimitive(cp, type));
/*     */             }
/*     */             else
/*     */             {
/* 392 */               x = cp.addClass(type);
/* 393 */               invokeInstructions.append(new CHECKCAST(x));
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 401 */         x = operations[i].methodIndexInCP;
/* 402 */         invokeInstructions.append(new INVOKEVIRTUAL(x));
/*     */ 
/* 405 */         String type = operations[i].getReturnType();
/*     */ 
/* 407 */         if (isPrimitive(type))
/*     */         {
/* 409 */           invokeInstructions.append(convertPrimitiveToObject(cp, type));
/* 410 */           invokeInstructions.append(new ARETURN());
/*     */         }
/* 412 */         else if (type.equals(Void.TYPE.getName()))
/*     */         {
/* 414 */           invokeInstructions.append(new ACONST_NULL());
/* 415 */           invokeInstructions.append(new ARETURN());
/*     */         }
/*     */         else
/*     */         {
/* 419 */           invokeInstructions.append(new ARETURN());
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 427 */     InstructionHandle jumpToSuperInvoke = invokeInstructions.append(new ALOAD(0));
/*     */ 
/* 429 */     invokeInstructions.append(new ALOAD(1));
/* 430 */     invokeInstructions.append(new ALOAD(2));
/* 431 */     invokeInstructions.append(new ALOAD(3));
/* 432 */     invokeInstructions.append(new INVOKESPECIAL(invokeIndex));
/* 433 */     invokeInstructions.append(new ARETURN());
/*     */ 
/* 436 */     ifOperationEqualsNull.setTarget(jumpToSuperInvoke);
/*     */ 
/* 438 */     if (operations.length > 0)
/*     */     {
/* 441 */       if (operationElseIfBranch != null) {
/* 442 */         operationElseIfBranch.setTarget(jumpToSuperInvoke);
/*     */       }
/*     */ 
/* 445 */       beginTryBlock = beginTryBlock.getNext();
/* 446 */       endTryBlock = jumpToSuperInvoke.getPrev();
/*     */     }
/*     */ 
/* 452 */     InstructionHandle exceptionHandlerCode = invokeInstructions.append(new ALOAD(0));
/*     */ 
/* 454 */     invokeInstructions.append(new ALOAD(1));
/* 455 */     invokeInstructions.append(new ALOAD(2));
/* 456 */     invokeInstructions.append(new ALOAD(3));
/* 457 */     invokeInstructions.append(new INVOKESPECIAL(invokeIndex));
/* 458 */     invokeInstructions.append(new ARETURN());
/*     */ 
/* 460 */     MethodGen invokeMethod = new MethodGen(1, Type.OBJECT, new Type[] { Type.STRING, new ArrayType(Object.class.getName(), 1), new ArrayType(String.class.getName(), 1) }, new String[] { "operationName", "args", "signature" }, "invoke", className, invokeInstructions, cp);
/*     */ 
/* 476 */     invokeMethod.setMaxLocals(7);
/* 477 */     invokeMethod.setMaxStack(calculateMaxStackSize(info));
/*     */ 
/* 479 */     invokeMethod.addException(ReflectionException.class.getName());
/* 480 */     invokeMethod.addException(MBeanException.class.getName());
/*     */ 
/* 482 */     if (operations.length > 0) {
/* 483 */       invokeMethod.addExceptionHandler(beginTryBlock, endTryBlock, exceptionHandlerCode, new ObjectType("java.lang.Throwable"));
/*     */     }
/*     */ 
/* 486 */     return invokeMethod;
/*     */   }
/*     */ 
/*     */   private static int calculateMaxStackSize(MBeanInfo info)
/*     */   {
/* 491 */     MBeanOperationInfo[] operations = info.getOperations();
/* 492 */     int maxSize = 7;
/*     */ 
/* 494 */     for (int i = 0; i < operations.length; i++)
/*     */     {
/* 496 */       if (operations[i].getSignature().length > maxSize + 2) {
/* 497 */         maxSize = operations[i].getSignature().length + 2;
/*     */       }
/*     */     }
/* 500 */     return maxSize;
/*     */   }
/*     */ 
/*     */   protected static InstructionList convertObjectToPrimitive(ConstantPoolGen cp, String type)
/*     */   {
/* 516 */     InstructionList il = new InstructionList();
/*     */ 
/* 518 */     int intValueIndex = cp.addMethodref(Integer.class.getName(), "intValue", "()I");
/* 519 */     int byteValueIndex = cp.addMethodref(Byte.class.getName(), "byteValue", "()B");
/* 520 */     int charValueIndex = cp.addMethodref(Character.class.getName(), "charValue", "()C");
/* 521 */     int doubleValueIndex = cp.addMethodref(Double.class.getName(), "doubleValue", "()D");
/* 522 */     int floatValueIndex = cp.addMethodref(Float.class.getName(), "floatValue", "()F");
/* 523 */     int longValueIndex = cp.addMethodref(Long.class.getName(), "longValue", "()J");
/* 524 */     int shortValueIndex = cp.addMethodref(Short.class.getName(), "shortValue", "()S");
/* 525 */     int booleanValueIndex = cp.addMethodref(Boolean.class.getName(), "booleanValue", "()Z");
/*     */ 
/* 531 */     if (type.equals(Integer.TYPE.getName()))
/*     */     {
/* 533 */       int x = cp.addClass("java.lang.Integer");
/* 534 */       il.append(new CHECKCAST(x));
/* 535 */       il.append(new INVOKEVIRTUAL(intValueIndex));
/*     */     }
/* 538 */     else if (type.equals(Byte.TYPE.getName()))
/*     */     {
/* 540 */       int x = cp.addClass("java.lang.Byte");
/* 541 */       il.append(new CHECKCAST(x));
/* 542 */       il.append(new INVOKEVIRTUAL(byteValueIndex));
/*     */     }
/* 545 */     else if (type.equals(Character.TYPE.getName()))
/*     */     {
/* 547 */       int x = cp.addClass("java.lang.Character");
/* 548 */       il.append(new CHECKCAST(x));
/* 549 */       il.append(new INVOKEVIRTUAL(charValueIndex));
/*     */     }
/* 552 */     else if (type.equals(Double.TYPE.getName()))
/*     */     {
/* 554 */       int x = cp.addClass("java.lang.Double");
/* 555 */       il.append(new CHECKCAST(x));
/* 556 */       il.append(new INVOKEVIRTUAL(doubleValueIndex));
/*     */     }
/* 559 */     else if (type.equals(Float.TYPE.getName()))
/*     */     {
/* 561 */       int x = cp.addClass("java.lang.Float");
/* 562 */       il.append(new CHECKCAST(x));
/* 563 */       il.append(new INVOKEVIRTUAL(floatValueIndex));
/*     */     }
/* 566 */     else if (type.equals(Long.TYPE.getName()))
/*     */     {
/* 568 */       int x = cp.addClass("java.lang.Long");
/* 569 */       il.append(new CHECKCAST(x));
/* 570 */       il.append(new INVOKEVIRTUAL(longValueIndex));
/*     */     }
/* 573 */     else if (type.equals(Short.TYPE.getName()))
/*     */     {
/* 575 */       int x = cp.addClass("java.lang.Short");
/* 576 */       il.append(new CHECKCAST(x));
/* 577 */       il.append(new INVOKEVIRTUAL(shortValueIndex));
/*     */     }
/* 580 */     else if (type.equals(Boolean.TYPE.getName()))
/*     */     {
/* 582 */       int x = cp.addClass("java.lang.Boolean");
/* 583 */       il.append(new CHECKCAST(x));
/* 584 */       il.append(new INVOKEVIRTUAL(booleanValueIndex));
/*     */     }
/*     */ 
/* 587 */     return il;
/*     */   }
/*     */ 
/*     */   protected static InstructionList convertPrimitiveToObject(ConstantPoolGen cp, String type)
/*     */   {
/* 605 */     InstructionList il = new InstructionList();
/*     */ 
/* 607 */     if (type.equals(Boolean.TYPE.getName()))
/*     */     {
/* 609 */       int x = cp.addClass("java.lang.Boolean");
/* 610 */       int constrIndex = cp.addMethodref("java.lang.Boolean", "<init>", "(B)V");
/*     */ 
/* 612 */       il.append(new ISTORE(4));
/* 613 */       il.append(new NEW(x));
/* 614 */       il.append(new ASTORE(5));
/* 615 */       il.append(new ALOAD(5));
/* 616 */       il.append(new ILOAD(4));
/* 617 */       il.append(new INVOKESPECIAL(constrIndex));
/* 618 */       il.append(new ALOAD(5));
/*     */     }
/* 621 */     else if (type.equals(Short.TYPE.getName()))
/*     */     {
/* 623 */       int x = cp.addClass("java.lang.Short");
/* 624 */       int constrIndex = cp.addMethodref("java.lang.Short", "<init>", "(S)V");
/*     */ 
/* 626 */       il.append(new ISTORE(4));
/* 627 */       il.append(new NEW(x));
/* 628 */       il.append(new ASTORE(5));
/* 629 */       il.append(new ALOAD(5));
/* 630 */       il.append(new ILOAD(4));
/* 631 */       il.append(new INVOKESPECIAL(constrIndex));
/* 632 */       il.append(new ALOAD(5));
/*     */     }
/* 635 */     else if (type.equals(Long.TYPE.getName()))
/*     */     {
/* 637 */       int x = cp.addClass("java.lang.Long");
/* 638 */       int constrIndex = cp.addMethodref("java.lang.Long", "<init>", "(J)V");
/*     */ 
/* 640 */       il.append(new LSTORE(4));
/* 641 */       il.append(new NEW(x));
/* 642 */       il.append(new ASTORE(6));
/* 643 */       il.append(new ALOAD(6));
/* 644 */       il.append(new LLOAD(4));
/* 645 */       il.append(new INVOKESPECIAL(constrIndex));
/* 646 */       il.append(new ALOAD(6));
/*     */     }
/* 649 */     else if (type.equals(Integer.TYPE.getName()))
/*     */     {
/* 651 */       int x = cp.addClass("java.lang.Integer");
/* 652 */       int constrIndex = cp.addMethodref("java.lang.Integer", "<init>", "(I)V");
/*     */ 
/* 654 */       il.append(new ISTORE(4));
/* 655 */       il.append(new NEW(x));
/* 656 */       il.append(new ASTORE(5));
/* 657 */       il.append(new ALOAD(5));
/* 658 */       il.append(new ILOAD(4));
/* 659 */       il.append(new INVOKESPECIAL(constrIndex));
/* 660 */       il.append(new ALOAD(5));
/*     */     }
/* 663 */     else if (type.equals(Float.TYPE.getName()))
/*     */     {
/* 665 */       int x = cp.addClass("java.lang.Float");
/* 666 */       int constrIndex = cp.addMethodref("java.lang.Float", "<init>", "(F)V");
/*     */ 
/* 668 */       il.append(new FSTORE(4));
/* 669 */       il.append(new NEW(x));
/* 670 */       il.append(new ASTORE(5));
/* 671 */       il.append(new ALOAD(5));
/* 672 */       il.append(new FLOAD(4));
/* 673 */       il.append(new INVOKESPECIAL(constrIndex));
/* 674 */       il.append(new ALOAD(5));
/*     */     }
/* 677 */     else if (type.equals(Double.TYPE.getName()))
/*     */     {
/* 679 */       int x = cp.addClass("java.lang.Double");
/* 680 */       int constrIndex = cp.addMethodref("java.lang.Double", "<init>", "(D)V");
/*     */ 
/* 682 */       il.append(new DSTORE(4));
/* 683 */       il.append(new NEW(x));
/* 684 */       il.append(new ASTORE(6));
/* 685 */       il.append(new ALOAD(6));
/* 686 */       il.append(new DLOAD(4));
/* 687 */       il.append(new INVOKESPECIAL(constrIndex));
/* 688 */       il.append(new ALOAD(6));
/*     */     }
/* 691 */     else if (type.equals(Character.TYPE.getName()))
/*     */     {
/* 693 */       int x = cp.addClass("java.lang.Character");
/* 694 */       int constrIndex = cp.addMethodref("java.lang.Character", "<init>", "(C)V");
/*     */ 
/* 696 */       il.append(new ISTORE(4));
/* 697 */       il.append(new NEW(x));
/* 698 */       il.append(new ASTORE(5));
/* 699 */       il.append(new ALOAD(5));
/* 700 */       il.append(new ILOAD(4));
/* 701 */       il.append(new INVOKESPECIAL(constrIndex));
/* 702 */       il.append(new ALOAD(5));
/*     */     }
/* 705 */     else if (type.equals(Byte.TYPE.getName()))
/*     */     {
/* 707 */       int x = cp.addClass("java.lang.Byte");
/* 708 */       int constrIndex = cp.addMethodref("java.lang.Byte", "<init>", "(B)V");
/*     */ 
/* 710 */       il.append(new ISTORE(4));
/* 711 */       il.append(new NEW(x));
/* 712 */       il.append(new ASTORE(5));
/* 713 */       il.append(new ALOAD(5));
/* 714 */       il.append(new ILOAD(4));
/* 715 */       il.append(new INVOKESPECIAL(constrIndex));
/* 716 */       il.append(new ALOAD(5));
/*     */     }
/*     */ 
/* 719 */     return il;
/*     */   }
/*     */ 
/*     */   protected static MethodEntry[] getOperations(MBeanInfo info)
/*     */   {
/* 735 */     HashMap operationMap = new HashMap();
/* 736 */     ArrayList overloadList = new ArrayList();
/* 737 */     MBeanOperationInfo[] operations = info.getOperations();
/*     */ 
/* 739 */     for (int i = 0; i < operations.length; i++)
/*     */     {
/* 741 */       String methodName = operations[i].getName();
/*     */ 
/* 743 */       if (operationMap.containsKey(methodName))
/* 744 */         overloadList.add(methodName);
/*     */       else {
/* 746 */         operationMap.put(methodName, new MethodEntry(operations[i]));
/*     */       }
/*     */     }
/*     */ 
/* 750 */     Iterator it = overloadList.iterator();
/* 751 */     while (it.hasNext()) {
/* 752 */       operationMap.remove(it.next());
/*     */     }
/* 754 */     return (MethodEntry[])(MethodEntry[])operationMap.values().toArray(new MethodEntry[0]);
/*     */   }
/*     */ 
/*     */   private static class MethodEntry extends MBeanOperationInfo
/*     */   {
/*     */     private static final long serialVersionUID = 1792631947840418314L;
/* 762 */     String methodDescriptor = null;
/* 763 */     int nameIndexInCP = -1;
/* 764 */     int methodIndexInCP = -1;
/*     */ 
/*     */     public MethodEntry(MBeanOperationInfo info)
/*     */     {
/* 768 */       super(info.getDescription(), info.getSignature(), info.getReturnType(), info.getImpact());
/*     */ 
/* 770 */       this.methodDescriptor = OptimizedMBeanDispatcher.getMethodDescriptor(info.getSignature(), info.getReturnType());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.capability.OptimizedMBeanDispatcher
 * JD-Core Version:    0.6.0
 */