/*     */ package org.jboss.mx.capability;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import javax.management.Descriptor;
/*     */ import javax.management.DynamicMBean;
/*     */ import javax.management.IntrospectionException;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanOperationInfo;
/*     */ import javax.management.modelmbean.ModelMBeanAttributeInfo;
/*     */ import org.jboss.mx.metadata.AttributeOperationResolver;
/*     */ import org.jboss.mx.metadata.MethodMapper;
/*     */ import org.jboss.mx.server.ServerConstants;
/*     */ import org.jboss.mx.util.PropertyAccess;
/*     */ 
/*     */ public class DispatcherFactory
/*     */   implements ServerConstants
/*     */ {
/*     */   public static DynamicMBean create(MBeanInfo info, Object resource)
/*     */     throws IntrospectionException
/*     */   {
/*  55 */     return create(info, resource, new AttributeOperationResolver(info));
/*     */   }
/*     */ 
/*     */   public static DynamicMBean create(MBeanInfo info, Object resource, AttributeOperationResolver resolver)
/*     */     throws IntrospectionException
/*     */   {
/*  63 */     if (null == info)
/*     */     {
/*  65 */       throw new IllegalArgumentException("info cannot be null");
/*     */     }
/*     */ 
/*  68 */     if (null == resolver)
/*     */     {
/*  70 */       throw new IllegalArgumentException("resolver cannot be null");
/*     */     }
/*     */ 
/*  73 */     if (null == resource)
/*     */     {
/*  75 */       throw new IllegalArgumentException("resource cannot be null");
/*     */     }
/*     */ 
/*  78 */     MethodMapper mmap = new MethodMapper(resource.getClass());
/*  79 */     ReflectedMBeanDispatcher dispatcher = new ReflectedMBeanDispatcher(info, resolver, resource);
/*     */ 
/*  81 */     String flag = PropertyAccess.getProperty("jbossmx.optimized.dispatcher", "false");
/*  82 */     if (flag.equalsIgnoreCase("true"))
/*     */     {
/*  86 */       dispatcher = OptimizedMBeanDispatcher.create(info, resource);
/*     */     }
/*     */ 
/*  89 */     MBeanAttributeInfo[] attributes = info.getAttributes();
/*  90 */     for (int i = 0; i < attributes.length; i++)
/*     */     {
/*  92 */       MBeanAttributeInfo attribute = attributes[i];
/*  93 */       Method getter = null;
/*  94 */       Method setter = null;
/*     */ 
/*  96 */       if (attribute.isReadable())
/*     */       {
/*  98 */         if ((attribute instanceof ModelMBeanAttributeInfo))
/*     */         {
/* 100 */           ModelMBeanAttributeInfo mmbAttribute = (ModelMBeanAttributeInfo)attribute;
/* 101 */           Descriptor desc = mmbAttribute.getDescriptor();
/* 102 */           if ((desc != null) && (desc.getFieldValue("getMethod") != null))
/*     */           {
/* 104 */             getter = mmap.lookupGetter(mmbAttribute);
/* 105 */             if (getter == null)
/*     */             {
/* 107 */               throw new IntrospectionException("no getter method found for attribute: " + attribute.getName());
/*     */             }
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 113 */           getter = mmap.lookupGetter(attribute);
/* 114 */           if (getter == null)
/*     */           {
/* 116 */             throw new IntrospectionException("no getter method found for attribute: " + attribute.getName());
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 121 */       if (attribute.isWritable())
/*     */       {
/* 123 */         if ((attribute instanceof ModelMBeanAttributeInfo))
/*     */         {
/* 125 */           ModelMBeanAttributeInfo mmbAttribute = (ModelMBeanAttributeInfo)attribute;
/* 126 */           Descriptor desc = mmbAttribute.getDescriptor();
/* 127 */           if ((desc != null) && (desc.getFieldValue("setMethod") != null))
/*     */           {
/* 129 */             setter = mmap.lookupSetter(mmbAttribute);
/* 130 */             if (setter == null)
/*     */             {
/* 132 */               throw new IntrospectionException("no setter method found for attribute: " + attribute.getName());
/*     */             }
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 138 */           setter = mmap.lookupSetter(attribute);
/* 139 */           if (setter == null)
/*     */           {
/* 141 */             throw new IntrospectionException("no setter method found for attribute: " + attribute.getName());
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 146 */       dispatcher.bindAttributeAt(i, getter, setter);
/*     */     }
/*     */ 
/* 149 */     MBeanOperationInfo[] operations = info.getOperations();
/* 150 */     for (int i = 0; i < operations.length; i++)
/*     */     {
/* 152 */       MBeanOperationInfo operation = operations[i];
/* 153 */       Method method = mmap.lookupOperation(operation);
/* 154 */       if (method == null)
/*     */       {
/* 156 */         throw new IntrospectionException("no method found for operation: " + operation.getName());
/*     */       }
/*     */ 
/* 159 */       dispatcher.bindOperationAt(i, method);
/*     */     }
/*     */ 
/* 162 */     return dispatcher;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.capability.DispatcherFactory
 * JD-Core Version:    0.6.0
 */