/*     */ package org.jboss.monitor;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ 
/*     */ public class LockMonitor
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -6710878502772579272L;
/*     */   private long totalTime;
/*     */   private long numContentions;
/*     */   private long timeouts;
/*     */   private long maxContenders;
/*     */   private long currentContenders;
/*     */   private transient EntityLockMonitor parent;
/*     */ 
/*     */   public LockMonitor(EntityLockMonitor parent)
/*     */   {
/*  63 */     this.parent = parent;
/*     */   }
/*     */ 
/*     */   public synchronized long getTotalTime()
/*     */   {
/*  70 */     return this.totalTime;
/*     */   }
/*     */ 
/*     */   public synchronized long getNumContentions()
/*     */   {
/*  75 */     return this.numContentions;
/*     */   }
/*     */ 
/*     */   public synchronized long getTimeouts()
/*     */   {
/*  80 */     return this.timeouts;
/*     */   }
/*     */ 
/*     */   public synchronized long getMaxContenders()
/*     */   {
/*  85 */     return this.maxContenders;
/*     */   }
/*     */ 
/*     */   public synchronized long getCurrentContenders()
/*     */   {
/*  90 */     return this.currentContenders;
/*     */   }
/*     */ 
/*     */   public void contending()
/*     */   {
/* 103 */     synchronized (this)
/*     */     {
/* 105 */       this.numContentions += 1L;
/* 106 */       this.currentContenders += 1L;
/*     */ 
/* 108 */       if (this.currentContenders > this.maxContenders)
/*     */       {
/* 110 */         this.maxContenders = this.currentContenders;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 117 */     if (this.parent != null)
/*     */     {
/* 119 */       this.parent.incrementContenders();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void finishedContending(long time)
/*     */   {
/* 131 */     synchronized (this)
/*     */     {
/* 133 */       this.totalTime += time;
/* 134 */       this.currentContenders -= 1L;
/*     */     }
/*     */ 
/* 140 */     if (this.parent != null)
/*     */     {
/* 142 */       this.parent.decrementContenders(time);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void increaseTimeouts()
/*     */   {
/* 151 */     synchronized (this)
/*     */     {
/* 153 */       this.timeouts += 1L;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */   {
/* 165 */     synchronized (this)
/*     */     {
/* 167 */       this.timeouts = 0L;
/* 168 */       this.totalTime = 0L;
/* 169 */       this.numContentions = 0L;
/*     */ 
/* 171 */       this.maxContenders = this.currentContenders;
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 179 */     StringBuffer sbuf = new StringBuffer(128);
/*     */ 
/* 181 */     sbuf.append(super.toString()).append("[ ").append("totalTime=").append(getTotalTime()).append(", numContentions=").append(getNumContentions()).append(", timeouts=").append(getTimeouts()).append(", maxContenders=").append(getMaxContenders()).append(", currentContenders=").append(getCurrentContenders()).append(" ]");
/*     */ 
/* 190 */     return sbuf.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.monitor.LockMonitor
 * JD-Core Version:    0.6.0
 */