/*      */ package org.jboss.metatype.plugins.values;
/*      */ 
/*      */ import java.io.Serializable;
/*      */ import java.lang.ref.WeakReference;
/*      */ import java.lang.reflect.Array;
/*      */ import java.lang.reflect.InvocationHandler;
/*      */ import java.lang.reflect.Proxy;
/*      */ import java.lang.reflect.Type;
/*      */ import java.lang.reflect.UndeclaredThrowableException;
/*      */ import java.security.AccessController;
/*      */ import java.security.PrivilegedAction;
/*      */ import java.util.Collection;
/*      */ import java.util.HashMap;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Map.Entry;
/*      */ import java.util.Set;
/*      */ import java.util.SortedSet;
/*      */ import java.util.Stack;
/*      */ import java.util.WeakHashMap;
/*      */ import org.jboss.beans.info.spi.BeanInfo;
/*      */ import org.jboss.beans.info.spi.PropertyInfo;
/*      */ import org.jboss.config.plugins.property.PropertyConfiguration;
/*      */ import org.jboss.config.spi.Configuration;
/*      */ import org.jboss.metatype.api.types.ArrayMetaType;
/*      */ import org.jboss.metatype.api.types.CollectionMetaType;
/*      */ import org.jboss.metatype.api.types.CompositeMetaType;
/*      */ import org.jboss.metatype.api.types.EnumMetaType;
/*      */ import org.jboss.metatype.api.types.GenericMetaType;
/*      */ import org.jboss.metatype.api.types.MetaType;
/*      */ import org.jboss.metatype.api.types.MetaTypeFactory;
/*      */ import org.jboss.metatype.api.types.SimpleMetaType;
/*      */ import org.jboss.metatype.api.types.TableMetaType;
/*      */ import org.jboss.metatype.api.values.ArrayValue;
/*      */ import org.jboss.metatype.api.values.ArrayValueSupport;
/*      */ import org.jboss.metatype.api.values.CollectionValue;
/*      */ import org.jboss.metatype.api.values.CollectionValueSupport;
/*      */ import org.jboss.metatype.api.values.CompositeValue;
/*      */ import org.jboss.metatype.api.values.CompositeValueSupport;
/*      */ import org.jboss.metatype.api.values.EnumValue;
/*      */ import org.jboss.metatype.api.values.EnumValueSupport;
/*      */ import org.jboss.metatype.api.values.GenericValue;
/*      */ import org.jboss.metatype.api.values.GenericValueSupport;
/*      */ import org.jboss.metatype.api.values.InstanceFactory;
/*      */ import org.jboss.metatype.api.values.MetaValue;
/*      */ import org.jboss.metatype.api.values.MetaValueFactory;
/*      */ import org.jboss.metatype.api.values.SimpleValue;
/*      */ import org.jboss.metatype.api.values.SimpleValueSupport;
/*      */ import org.jboss.metatype.api.values.TableValue;
/*      */ import org.jboss.metatype.api.values.TableValueSupport;
/*      */ import org.jboss.metatype.plugins.types.DefaultMetaTypeFactory;
/*      */ import org.jboss.metatype.spi.values.MetaValueBuilder;
/*      */ import org.jboss.reflect.plugins.introspection.ParameterizedClassInfo;
/*      */ import org.jboss.reflect.spi.ArrayInfo;
/*      */ import org.jboss.reflect.spi.ClassInfo;
/*      */ import org.jboss.reflect.spi.TypeInfo;
/*      */ import org.jboss.reflect.spi.TypeInfoFactory;
/*      */ 
/*      */ public class DefaultMetaValueFactory extends MetaValueFactory
/*      */ {
/*   91 */   private MetaTypeFactory metaTypeFactory = MetaTypeFactory.getInstance();
/*      */ 
/*   98 */   private static Configuration configuration = (Configuration)AccessController.doPrivileged(new PrivilegedAction()
/*      */   {
/*      */     public Configuration run()
/*      */     {
/*  102 */       return new PropertyConfiguration();
/*      */     }
/*      */   });
/*      */ 
/*  108 */   private ThreadLocal<Stack<Map<Object, MetaValue>>> mappingStack = new ThreadLocal()
/*      */   {
/*      */     protected Stack<Map<Object, MetaValue>> initialValue()
/*      */     {
/*  112 */       return new Stack();
/*      */     }
/*  108 */   };
/*      */ 
/*  117 */   private Map<Class, WeakReference<MetaValueBuilder>> builders = new WeakHashMap();
/*      */ 
/*  120 */   private static final TypeInfo OBJECT_TYPE_INFO = configuration.getTypeInfo(Object.class);
/*      */ 
/*  123 */   private Map<Class, InstanceFactory> instanceFactoryMap = new WeakHashMap();
/*      */ 
/*      */   public DefaultMetaValueFactory()
/*      */   {
/*  128 */     setInstanceFactory(List.class, ListInstanceFactory.INSTANCE);
/*  129 */     setInstanceFactory(Set.class, SetInstanceFactory.INSTANCE);
/*  130 */     setInstanceFactory(SortedSet.class, SortedSetInstanceFactory.INSTANCE);
/*      */   }
/*      */ 
/*      */   public void setBuilder(Class<?> clazz, MetaValueBuilder builder)
/*      */   {
/*  135 */     synchronized (this.builders)
/*      */     {
/*  137 */       if (builder == null)
/*  138 */         this.builders.remove(clazz);
/*  139 */       this.builders.put(clazz, new WeakReference(builder));
/*      */     }
/*      */   }
/*      */ 
/*      */   public <T> void setInstanceFactory(Class<T> clazz, InstanceFactory<T> factory)
/*      */   {
/*  145 */     synchronized (this.instanceFactoryMap)
/*      */     {
/*  147 */       if (factory == null)
/*  148 */         this.instanceFactoryMap.remove(clazz);
/*      */       else
/*  150 */         this.instanceFactoryMap.put(clazz, factory);
/*      */     }
/*      */   }
/*      */ 
/*      */   public static <T extends Serializable> SimpleValue<T> createSimpleValue(SimpleMetaType<T> type, T value)
/*      */   {
/*  164 */     if (value == null) {
/*  165 */       return null;
/*      */     }
/*  167 */     return new SimpleValueSupport(type, value);
/*      */   }
/*      */ 
/*      */   public static <T extends Enum> EnumValue createEnumValue(EnumMetaType type, T value)
/*      */   {
/*  180 */     if (value == null) {
/*  181 */       return null;
/*      */     }
/*  183 */     return new EnumValueSupport(type, value.name());
/*      */   }
/*      */ 
/*      */   public static GenericValue createGenericValue(GenericMetaType type, Object value, Map<Object, MetaValue> mapping)
/*      */   {
/*  196 */     if (value == null) {
/*  197 */       return null;
/*      */     }
/*  199 */     if (!(value instanceof Serializable)) {
/*  200 */       throw new IllegalArgumentException("Not serializable: " + value.getClass().getName());
/*      */     }
/*  202 */     GenericValue result = new GenericValueSupport(type, (Serializable)value);
/*  203 */     mapping.put(value, result);
/*  204 */     return result;
/*      */   }
/*      */ 
/*      */   public CollectionValue createCollectionValue(CollectionMetaType type, Object value, Map<Object, MetaValue> mapping)
/*      */   {
/*  217 */     if (value == null) {
/*  218 */       return null;
/*      */     }
/*  220 */     Collection collection = (Collection)value;
/*  221 */     MetaValue[] elements = new MetaValue[collection.size()];
/*  222 */     int i = 0;
/*  223 */     for (Iterator i$ = collection.iterator(); i$.hasNext(); ) { Object ce = i$.next();
/*      */ 
/*  226 */       TypeInfo typeInfo = configuration.getTypeInfo(ce.getClass());
/*  227 */       MetaType metaType = this.metaTypeFactory.resolve(typeInfo);
/*  228 */       elements[(i++)] = internalCreate(ce, typeInfo, metaType);
/*      */     }
/*  230 */     CollectionValue result = new CollectionValueSupport(type, elements);
/*  231 */     mapping.put(value, result);
/*  232 */     return result;
/*      */   }
/*      */ 
/*      */   public static Object[] convertPrimativeArray(TypeInfo type, Object value)
/*      */   {
/*  245 */     if (value == null)
/*  246 */       return null;
/*      */     Object[] oa;
/*  249 */     if ((type instanceof ArrayInfo))
/*      */     {
/*  252 */       ArrayInfo arrayInfo = (ArrayInfo)ArrayInfo.class.cast(type);
/*  253 */       TypeInfo etype = arrayInfo.getComponentType();
/*  254 */       int size = Array.getLength(value);
/*  255 */       Object[] oa = new Object[size];
/*  256 */       for (int n = 0; n < size; n++)
/*      */       {
/*  258 */         Object nvalue = Array.get(value, n);
/*      */ 
/*  260 */         if (etype.isArray())
/*      */         {
/*  262 */           oa[n] = convertPrimativeArray(etype, nvalue);
/*      */         }
/*  264 */         oa[n] = nvalue;
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  269 */       oa = (Object[])(Object[])value;
/*      */     }
/*      */ 
/*  272 */     return oa;
/*      */   }
/*      */ 
/*      */   public static Object[] convertPrimativeArray(Object value)
/*      */   {
/*  284 */     if (value == null)
/*  285 */       return null;
/*  286 */     return convertPrimativeArray(configuration.getTypeInfo(value.getClass()), value);
/*      */   }
/*      */ 
/*      */   public ArrayValue createArrayValue(ArrayMetaType type, Object value, Map<Object, MetaValue> mapping)
/*      */   {
/*  299 */     if (value == null) {
/*  300 */       return null;
/*      */     }
/*  302 */     ArrayValueSupport result = new ArrayValueSupport(type);
/*  303 */     mapping.put(value, result);
/*      */ 
/*  307 */     MetaType elementType = type.getElementType();
/*  308 */     int dimension = type.getDimension();
/*      */     Class componentType;
/*      */     try {
/*  314 */       componentType = Class.forName(type.getClassName());
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  318 */       throw new RuntimeException("Unable to determine component type for " + type, e);
/*      */     }
/*      */ 
/*  321 */     ClassInfo classInfo = configuration.getClassInfo(value.getClass());
/*      */     Object[] oldArray;
/*  322 */     if (classInfo.isArray())
/*      */     {
/*  325 */       ArrayInfo arrayInfo = (ArrayInfo)ArrayInfo.class.cast(classInfo);
/*  326 */       TypeInfo compInfo = arrayInfo.getComponentType();
/*  327 */       while ((compInfo instanceof ArrayInfo))
/*      */       {
/*  329 */         arrayInfo = (ArrayInfo)ArrayInfo.class.cast(compInfo);
/*  330 */         compInfo = arrayInfo.getComponentType();
/*      */       }
/*      */       Object[] oldArray;
/*  333 */       if (compInfo.isPrimitive())
/*  334 */         oldArray = convertPrimativeArray(classInfo, value);
/*      */       else
/*  336 */         oldArray = (Object[])(Object[])value;
/*      */     }
/*      */     else {
/*  339 */       throw new UnsupportedOperationException("Cannot construct array for " + value.getClass());
/*      */     }
/*      */     Object[] oldArray;
/*  341 */     Object[] array = createArray(elementType, componentType.getComponentType(), dimension, oldArray);
/*  342 */     result.setValue(array);
/*  343 */     return result;
/*      */   }
/*      */ 
/*      */   protected Object[] createArray(MetaType elementType, Class<?> componentType, int dimension, Object[] oldArray)
/*      */   {
/*  357 */     if (oldArray == null) {
/*  358 */       return null;
/*      */     }
/*  360 */     Object[] newArray = new Object[oldArray.length];
/*      */ 
/*  362 */     if (dimension > 1)
/*      */     {
/*  365 */       for (int i = 0; i < oldArray.length; i++)
/*      */       {
/*      */         Object[] nestedOld;
/*      */         Object[] nestedOld;
/*  367 */         if (!(oldArray[i] instanceof Object[]))
/*  368 */           nestedOld = convertPrimativeArray(oldArray[i]);
/*      */         else
/*  370 */           nestedOld = (Object[])(Object[])oldArray[i];
/*  371 */         Object[] result = createArray(elementType, componentType.getComponentType(), dimension - 1, nestedOld);
/*  372 */         newArray[i] = result;
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  377 */       for (int i = 0; i < oldArray.length; i++) {
/*  378 */         newArray[i] = internalCreate(oldArray[i], null, elementType);
/*      */       }
/*      */     }
/*  381 */     return newArray;
/*      */   }
/*      */ 
/*      */   public CompositeValue createCompositeValue(CompositeMetaType type, Object value, Map<Object, MetaValue> mapping)
/*      */   {
/*  394 */     if (value == null) {
/*  395 */       return null;
/*  397 */     }CompositeValueSupport result = new CompositeValueSupport(type);
/*  398 */     mapping.put(value, result);
/*      */     BeanInfo beanInfo;
/*      */     try {
/*  403 */       ClassLoader cl = value.getClass().getClassLoader();
/*      */       BeanInfo beanInfo;
/*  404 */       if (cl == null)
/*  405 */         beanInfo = configuration.getBeanInfo(value.getClass());
/*      */       else
/*  407 */         beanInfo = configuration.getBeanInfo(type.getTypeName(), cl);
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  411 */       throw new RuntimeException("Error retrieving BeanInfo for " + type);
/*      */     }
/*      */ 
/*  414 */     for (String name : type.keySet()) {
/*  416 */       MetaType itemType = type.getType(name);
/*      */       Object itemValue;
/*      */       try {
/*  420 */         itemValue = beanInfo.getProperty(value, name);
/*      */       }
/*      */       catch (RuntimeException e)
/*      */       {
/*  424 */         throw e;
/*      */       }
/*      */       catch (Error e)
/*      */       {
/*  428 */         throw e;
/*      */       }
/*      */       catch (Throwable t)
/*      */       {
/*  432 */         throw new RuntimeException("Error getting property: " + name + " for " + value.getClass(), t);
/*      */       }
/*      */ 
/*  435 */       MetaValue item = internalCreate(itemValue, null, itemType);
/*  436 */       result.set(name, item);
/*      */     }
/*      */ 
/*  439 */     return result;
/*      */   }
/*      */ 
/*      */   public TableValue createTableValue(TableMetaType type, Map value, Map<Object, MetaValue> mapping)
/*      */   {
/*  453 */     if (value == null) {
/*  454 */       return null;
/*      */     }
/*  456 */     TableValueSupport table = new TableValueSupport(type);
/*  457 */     mapping.put(value, table);
/*      */ 
/*  459 */     CompositeMetaType entryType = type.getRowType();
/*  460 */     MetaType keyType = entryType.getType("key");
/*  461 */     MetaType valType = entryType.getType("value");
/*      */ 
/*  463 */     for (Iterator i = value.entrySet().iterator(); i.hasNext(); )
/*      */     {
/*  465 */       Map.Entry entry = (Map.Entry)i.next();
/*  466 */       MetaValue key = internalCreate(entry.getKey(), null, keyType);
/*  467 */       MetaValue val = internalCreate(entry.getValue(), null, valType);
/*  468 */       CompositeValueSupport data = new CompositeValueSupport(entryType, DefaultMetaTypeFactory.MAP_ITEM_NAMES, new MetaValue[] { key, val });
/*  469 */       table.put(data);
/*      */     }
/*      */ 
/*  472 */     return table;
/*      */   }
/*      */ 
/*      */   public MetaValue create(Object value)
/*      */   {
/*  478 */     return internalCreate(value, null, null);
/*      */   }
/*      */ 
/*      */   public MetaValue create(Object value, Type type)
/*      */   {
/*  484 */     TypeInfo typeInfo = configuration.getTypeInfo(type);
/*  485 */     return internalCreate(value, typeInfo, null);
/*      */   }
/*      */ 
/*      */   public MetaValue create(Object value, TypeInfo type)
/*      */   {
/*  491 */     return internalCreate(value, type, null);
/*      */   }
/*      */ 
/*      */   public Object unwrap(MetaValue metaValue)
/*      */   {
/*  497 */     return internalUnwrap(metaValue, null);
/*      */   }
/*      */ 
/*      */   public Object unwrap(MetaValue metaValue, Type type)
/*      */   {
/*  503 */     TypeInfo typeInfo = configuration.getTypeInfo(type);
/*  504 */     return internalUnwrap(metaValue, typeInfo);
/*      */   }
/*      */ 
/*      */   public Object unwrap(MetaValue metaValue, TypeInfo type)
/*      */   {
/*  510 */     return internalUnwrap(metaValue, type);
/*      */   }
/*      */ 
/*      */   protected Object internalUnwrap(MetaValue metaValue, TypeInfo type)
/*      */   {
/*  522 */     if (metaValue == null) {
/*  523 */       return null;
/*      */     }
/*  525 */     MetaType metaType = metaValue.getMetaType();
/*      */ 
/*  527 */     if (metaType.isSimple())
/*      */     {
/*  529 */       Serializable value = ((SimpleValue)metaValue).getValue();
/*  530 */       return getValue(metaType, type, value);
/*      */     }
/*  532 */     if (metaType.isEnum())
/*      */     {
/*  534 */       String value = ((EnumValue)metaValue).getValue();
/*  535 */       return getValue(metaType, type, value);
/*      */     }
/*  537 */     if (metaType.isGeneric())
/*      */     {
/*  539 */       Serializable value = ((GenericValue)metaValue).getValue();
/*  540 */       return getValue(metaType, type, value);
/*      */     }
/*  542 */     if (metaType.isArray())
/*      */     {
/*  544 */       ArrayValue arrayValue = (ArrayValue)metaValue;
/*  545 */       if (type == null)
/*  546 */         type = getTypeInfo(metaType, arrayValue.getValue());
/*  547 */       Object array = newArrayInstance(type, arrayValue.getLength());
/*  548 */       for (int i = 0; i < Array.getLength(array); i++)
/*      */       {
/*  550 */         Object element = arrayValue.getValue(i);
/*  551 */         if ((element instanceof MetaValue))
/*  552 */           element = unwrapMetaValue((MetaValue)element, type, array);
/*  553 */         else if ((element != null) && (element.getClass().isArray())) {
/*  554 */           element = unwrapArray(array, element);
/*      */         }
/*  556 */         Array.set(array, i, element);
/*      */       }
/*  558 */       return array;
/*      */     }
/*  560 */     if (metaType.isComposite())
/*      */     {
/*  562 */       CompositeValue compositeValue = (CompositeValue)metaValue;
/*  563 */       return unwrapComposite(compositeValue, type);
/*      */     }
/*  565 */     if (metaType.isCollection())
/*      */     {
/*  567 */       CollectionValue collectionValue = (CollectionValue)metaValue;
/*  568 */       return unwrapCollection(collectionValue, type);
/*      */     }
/*  570 */     if (metaType.isTable())
/*      */     {
/*  572 */       TableValue tableValue = (TableValue)metaValue;
/*  573 */       return unwrapTable(tableValue, type);
/*      */     }
/*      */ 
/*  576 */     throw new IllegalArgumentException("Unsupported meta value: " + metaValue);
/*      */   }
/*      */ 
/*      */   protected TypeInfo checkTypeInfo(TypeInfo type, Object value, MetaType metaType)
/*      */   {
/*  592 */     if ((type == null) && (value != null))
/*  593 */       type = getTypeInfo(metaType, value);
/*  594 */     return type;
/*      */   }
/*      */ 
/*      */   protected Object getValue(MetaType metaType, TypeInfo typeInfo, Object value)
/*      */   {
/*  608 */     typeInfo = checkTypeInfo(typeInfo, value, metaType);
/*  609 */     return convertValue(value, typeInfo);
/*      */   }
/*      */ 
/*      */   protected Object unwrapMetaValue(MetaValue element, TypeInfo type, Object array)
/*      */   {
/*      */     TypeInfo elementType;
/*      */     TypeInfo elementType;
/*  623 */     if ((type instanceof ClassInfo))
/*  624 */       elementType = ((ClassInfo)type).getComponentType();
/*      */     else
/*  626 */       elementType = getTypeInfo(element.getMetaType(), array);
/*  627 */     return unwrap(element, elementType);
/*      */   }
/*      */ 
/*      */   protected Object unwrapArray(Object array, Object element)
/*      */   {
/*  638 */     TypeInfo elementType = configuration.getTypeInfo(array.getClass().getComponentType());
/*  639 */     int subSize = Array.getLength(element);
/*  640 */     Object newElement = newArrayInstance(elementType, subSize);
/*  641 */     for (int i = 0; i < subSize; i++)
/*      */     {
/*  643 */       Object subElement = Array.get(element, i);
/*  644 */       if ((subElement instanceof MetaValue))
/*  645 */         subElement = unwrapMetaValue((MetaValue)subElement, elementType, newElement);
/*  646 */       if ((subElement != null) && (subElement.getClass().isArray())) {
/*  647 */         subElement = unwrapArray(newElement, subElement);
/*      */       }
/*  649 */       Array.set(newElement, i, subElement);
/*      */     }
/*  651 */     return newElement;
/*      */   }
/*      */ 
/*      */   protected Object unwrapComposite(CompositeValue compositeValue, TypeInfo typeInfo)
/*      */   {
/*  663 */     CompositeMetaType compositeMetaType = compositeValue.getMetaType();
/*  664 */     String typeName = compositeMetaType.getTypeName();
/*      */     ClassLoader cl;
/*      */     ClassLoader cl;
/*  666 */     if (typeInfo != null)
/*  667 */       cl = typeInfo.getType().getClassLoader();
/*      */     else {
/*  669 */       cl = Thread.currentThread().getContextClassLoader();
/*      */     }
/*      */     try
/*      */     {
/*  673 */       BeanInfo beanInfo = configuration.getBeanInfo(typeName, cl);
/*  674 */       ClassInfo classInfo = beanInfo.getClassInfo();
/*  675 */       if (classInfo.isInterface())
/*      */       {
/*  677 */         InvocationHandler handler = createCompositeValueInvocationHandler(compositeValue);
/*  678 */         Class clazz = classInfo.getType();
/*  679 */         Class[] interfaces = { clazz };
/*  680 */         return Proxy.newProxyInstance(clazz.getClassLoader(), interfaces, handler);
/*      */       }
/*  682 */       Object bean = createNewInstance(beanInfo);
/*  683 */       for (String name : compositeMetaType.keySet())
/*      */       {
/*  685 */         MetaValue itemValue = compositeValue.get(name);
/*  686 */         PropertyInfo propertyInfo = beanInfo.getProperty(name);
/*  687 */         Object value = unwrap(itemValue, propertyInfo.getType());
/*  688 */         propertyInfo.set(bean, value);
/*      */       }
/*  690 */       return bean;
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  694 */     throw new UndeclaredThrowableException(t);
/*      */   }
/*      */ 
/*      */   protected InvocationHandler createCompositeValueInvocationHandler(CompositeValue compositeValue)
/*      */   {
/*  706 */     return new CompositeValueInvocationHandler(compositeValue);
/*      */   }
/*      */ 
/*      */   protected Object unwrapCollection(CollectionValue collectionValue, TypeInfo type)
/*      */   {
/*      */     try
/*      */     {
/*      */       BeanInfo collectionInfo;
/*      */       BeanInfo collectionInfo;
/*  723 */       if ((type instanceof ClassInfo))
/*      */       {
/*  725 */         collectionInfo = configuration.getBeanInfo(type);
/*      */       }
/*      */       else
/*      */       {
/*  729 */         MetaType metaType = collectionValue.getMetaType();
/*  730 */         collectionInfo = configuration.getBeanInfo(metaType.getTypeName(), Thread.currentThread().getContextClassLoader());
/*      */       }
/*  732 */       ClassInfo classInfo = collectionInfo.getClassInfo();
/*  733 */       Collection collection = (Collection)createNewInstance(collectionInfo);
/*  734 */       Iterator iter = collectionValue.iterator();
/*  735 */       while (iter.hasNext())
/*      */       {
/*  737 */         MetaValue metaValue = (MetaValue)iter.next();
/*  738 */         TypeInfo componentType = classInfo.getComponentType();
/*      */ 
/*  740 */         if (OBJECT_TYPE_INFO.equals(componentType))
/*  741 */           componentType = getTypeInfo(metaValue.getMetaType(), null);
/*  742 */         collection.add(unwrap(metaValue, componentType));
/*      */       }
/*  744 */       return collection;
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  748 */     throw new UndeclaredThrowableException(t);
/*      */   }
/*      */ 
/*      */   protected Object unwrapTable(TableValue tableValue, TypeInfo type)
/*      */   {
/*  761 */     if ((type instanceof ParameterizedClassInfo))
/*      */     {
/*  763 */       ParameterizedClassInfo parameterizedType = (ParameterizedClassInfo)type;
/*  764 */       ClassInfo rawType = parameterizedType.getRawType();
/*  765 */       if (Map.class.isAssignableFrom(rawType.getType()))
/*      */       {
/*  767 */         TypeInfo keyType = parameterizedType.getActualTypeArguments()[0];
/*  768 */         TypeInfo valueType = parameterizedType.getActualTypeArguments()[1];
/*  769 */         return createMap(tableValue, keyType, valueType);
/*      */       }
/*      */     }
/*  772 */     throw new UnsupportedOperationException("Insufficient information to unwrap table: " + tableValue + ", " + type);
/*      */   }
/*      */ 
/*      */   protected Map createMap(TableValue tableValue, TypeInfo keyType, TypeInfo valueType)
/*      */   {
/*  785 */     if (tableValue == null) {
/*  786 */       return null;
/*      */     }
/*  788 */     Map result = new HashMap();
/*  789 */     Collection values = tableValue.values();
/*  790 */     for (CompositeValue entry : values)
/*      */     {
/*  792 */       Object key = unwrap(entry.get("key"), keyType);
/*  793 */       Object val = unwrap(entry.get("value"), valueType);
/*  794 */       result.put(key, val);
/*      */     }
/*  796 */     return result;
/*      */   }
/*      */ 
/*      */   protected Object createNewInstance(BeanInfo beanInfo)
/*      */     throws Throwable
/*      */   {
/*  808 */     ClassInfo classInfo = beanInfo.getClassInfo();
/*  809 */     if (classInfo.isInterface())
/*      */     {
/*  811 */       InstanceFactory instanceFactory = (InstanceFactory)this.instanceFactoryMap.get(classInfo.getType());
/*  812 */       if (instanceFactory == null) {
/*  813 */         throw new IllegalArgumentException("Cannot instantiate interface BeanInfo, missing InstanceFactory: " + classInfo);
/*      */       }
/*  815 */       return instanceFactory.instantiate(beanInfo);
/*      */     }
/*  817 */     return beanInfo.newInstance();
/*      */   }
/*      */ 
/*      */   protected Object newArrayInstance(TypeInfo typeInfo, int size)
/*      */   {
/*  829 */     if (typeInfo == null) {
/*  830 */       throw new IllegalArgumentException("Null type info.");
/*      */     }
/*      */     try
/*      */     {
/*  834 */       return typeInfo.newArrayInstance(size);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  838 */     throw new UndeclaredThrowableException(t);
/*      */   }
/*      */ 
/*      */   protected TypeInfo getTypeInfo(MetaType metaType, Object value)
/*      */   {
/*  851 */     if (metaType == null)
/*  852 */       throw new IllegalArgumentException("Null meta type, cannot determine class name.");
/*  853 */     if (value == null) {
/*  854 */       throw new IllegalArgumentException("Null value, cannot determine classloader.");
/*      */     }
/*      */ 
/*  857 */     ClassLoader cl = value.getClass().getClassLoader();
/*  858 */     return getTypeInfo(metaType, cl);
/*      */   }
/*      */ 
/*      */   protected TypeInfo getTypeInfo(MetaType metaType, ClassLoader cl)
/*      */   {
/*  870 */     if (cl == null) {
/*  871 */       cl = Thread.currentThread().getContextClassLoader();
/*      */     }
/*      */     try
/*      */     {
/*  875 */       TypeInfoFactory tif = configuration.getTypeInfoFactory();
/*  876 */       if (metaType.isArray())
/*      */       {
/*  878 */         ArrayMetaType arrayMetaType = (ArrayMetaType)metaType;
/*  879 */         MetaType elementMetaType = arrayMetaType.getElementType();
/*  880 */         String elementTypeName = elementMetaType.getTypeName();
/*  881 */         if (arrayMetaType.isPrimitiveArray())
/*  882 */           elementTypeName = ArrayMetaType.getPrimitiveName(elementTypeName);
/*  883 */         TypeInfo elementTypeInfo = tif.getTypeInfo(elementTypeName, cl);
/*  884 */         int dimension = arrayMetaType.getDimension() - 1;
/*  885 */         TypeInfo typeInfo = elementTypeInfo.getArrayType();
/*  886 */         while (dimension > 0)
/*      */         {
/*  888 */           typeInfo = typeInfo.getArrayType();
/*  889 */           dimension--;
/*      */         }
/*  891 */         return typeInfo;
/*      */       }
/*  893 */       return tif.getTypeInfo(metaType.getTypeName(), cl);
/*      */     }
/*      */     catch (ClassNotFoundException e) {
/*      */     }
/*  897 */     throw new UndeclaredThrowableException(e);
/*      */   }
/*      */ 
/*      */   protected MetaValue internalCreate(Object value, TypeInfo type, MetaType metaType)
/*      */   {
/*  911 */     if (value == null) {
/*  912 */       return null;
/*      */     }
/*  914 */     if (type == null) {
/*  915 */       type = configuration.getTypeInfo(value.getClass());
/*      */     }
/*  917 */     value = convertValue(value, type);
/*      */ 
/*  919 */     boolean start = false;
/*  920 */     if (metaType == null)
/*      */     {
/*  922 */       start = true;
/*  923 */       metaType = this.metaTypeFactory.resolve(type);
/*      */     }
/*      */     Map mapping;
/*  929 */     if (start)
/*      */     {
/*  932 */       Map mapping = new HashMap();
/*  933 */       ((Stack)this.mappingStack.get()).push(mapping);
/*      */     }
/*      */     else
/*      */     {
/*  938 */       mapping = (Map)((Stack)this.mappingStack.get()).peek();
/*  939 */       MetaValue result = (MetaValue)mapping.get(value);
/*      */ 
/*  941 */       if (result != null) {
/*  942 */         return result;
/*      */       }
/*      */     }
/*      */     try
/*      */     {
/*  947 */       MetaValue result = isBuilder(metaType, type, value, mapping);
/*  948 */       if (result == null)
/*      */       {
/*  950 */         if (metaType.isSimple())
/*  951 */           result = createSimpleValue((SimpleMetaType)metaType, (Serializable)value);
/*  952 */         else if (metaType.isEnum())
/*  953 */           result = createEnumValue((EnumMetaType)metaType, (Enum)value);
/*  954 */         else if (metaType.isArray())
/*  955 */           result = createArrayValue((ArrayMetaType)metaType, value, mapping);
/*  956 */         else if (metaType.isComposite())
/*  957 */           result = createCompositeValue((CompositeMetaType)metaType, value, mapping);
/*  958 */         else if (metaType.isTable())
/*  959 */           result = createTableValue((TableMetaType)metaType, (Map)value, mapping);
/*  960 */         else if (metaType.isGeneric())
/*  961 */           result = createGenericValue((GenericMetaType)metaType, value, mapping);
/*  962 */         else if (metaType.isCollection())
/*  963 */           result = createCollectionValue((CollectionMetaType)metaType, value, mapping);
/*      */         else
/*  965 */           throw new IllegalStateException("Unknown metaType: " + metaType);
/*      */       }
/*  967 */       MetaValue localMetaValue1 = result;
/*      */       return localMetaValue1;
/*      */     }
/*      */     finally
/*      */     {
/*  972 */       if (start)
/*  973 */         ((Stack)this.mappingStack.get()).pop(); 
/*  973 */     }throw localObject;
/*      */   }
/*      */ 
/*      */   protected Object convertValue(Object value, TypeInfo typeInfo)
/*      */   {
/*      */     try
/*      */     {
/*  989 */       return typeInfo != null ? typeInfo.convertValue(value) : value;
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  993 */     throw new UndeclaredThrowableException(t);
/*      */   }
/*      */ 
/*      */   protected MetaValue isBuilder(MetaType metaType, TypeInfo type, Object value, Map<Object, MetaValue> mapping)
/*      */   {
/* 1009 */     MetaValueBuilder builder = null;
/* 1010 */     synchronized (this.builders)
/*      */     {
/* 1012 */       WeakReference weak = (WeakReference)this.builders.get(type.getType());
/* 1013 */       if (weak != null)
/* 1014 */         builder = (MetaValueBuilder)weak.get();
/*      */     }
/* 1016 */     if (builder == null)
/* 1017 */       return null;
/* 1018 */     MetaValue result = builder.buildMetaValue(metaType, value);
/* 1019 */     if (result != null) {
/* 1020 */       mapping.put(value, result);
/*      */     }
/* 1022 */     return result;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metatype.plugins.values.DefaultMetaValueFactory
 * JD-Core Version:    0.6.0
 */