/*     */ package org.jboss.metatype.plugins.values;
/*     */ 
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.lang.reflect.Type;
/*     */ import java.util.Collections;
/*     */ import java.util.Map;
/*     */ import java.util.WeakHashMap;
/*     */ import org.jboss.metatype.api.values.CompositeValue;
/*     */ import org.jboss.metatype.api.values.MetaValue;
/*     */ import org.jboss.metatype.api.values.MetaValueFactory;
/*     */ import org.jboss.util.UnreachableStatementException;
/*     */ 
/*     */ public class CompositeValueInvocationHandler
/*     */   implements InvocationHandler
/*     */ {
/*  46 */   private static MetaValueFactory factory = MetaValueFactory.getInstance();
/*     */ 
/*  49 */   private static final Map<Method, String> compositeDataKeyCache = Collections.synchronizedMap(new WeakHashMap());
/*     */   private CompositeValue compositeValue;
/*     */ 
/*     */   public CompositeValueInvocationHandler(CompositeValue compositeValue)
/*     */   {
/*  61 */     if (compositeValue == null)
/*  62 */       throw new IllegalArgumentException("Null compositeValue");
/*  63 */     this.compositeValue = compositeValue;
/*     */   }
/*     */ 
/*     */   public CompositeValue getCompositeValue()
/*     */   {
/*  73 */     return this.compositeValue;
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args) throws Throwable
/*     */   {
/*  78 */     if (Object.class.equals(method.getDeclaringClass())) {
/*  79 */       return handleObjectInvocation(method.getName(), args);
/*     */     }
/*  81 */     MetaValue value = this.compositeValue.get(getCompositeDataKey(method));
/*  82 */     Type returnType = method.getGenericReturnType();
/*  83 */     return factory.unwrap(value, returnType);
/*     */   }
/*     */ 
/*     */   private Object handleObjectInvocation(String name, Object[] args) throws Throwable
/*     */   {
/*  88 */     if ("equals".equals(name))
/*     */     {
/*  90 */       Object object = args[0];
/*  91 */       if ((object == null) || (!(object instanceof Proxy)))
/*  92 */         return Boolean.valueOf(false);
/*  93 */       InvocationHandler handler = Proxy.getInvocationHandler(object);
/*  94 */       if (handler == this)
/*  95 */         return Boolean.valueOf(true);
/*  96 */       if ((handler == null) || (!(handler instanceof CompositeValueInvocationHandler))) {
/*  97 */         return Boolean.valueOf(false);
/*     */       }
/*  99 */       CompositeValueInvocationHandler other = (CompositeValueInvocationHandler)handler;
/* 100 */       return Boolean.valueOf(getCompositeValue().equals(other.getCompositeValue()));
/*     */     }
/* 102 */     if ("hashCode".equals(name))
/* 103 */       return Integer.valueOf(getCompositeValue().hashCode());
/* 104 */     if ("toString".equals(name))
/* 105 */       return getCompositeValue().toString();
/* 106 */     throw new UnreachableStatementException();
/*     */   }
/*     */ 
/*     */   public static String getCompositeDataKey(Method method)
/*     */   {
/* 117 */     String key = (String)compositeDataKeyCache.get(method);
/* 118 */     if (key != null) {
/* 119 */       return key;
/*     */     }
/* 121 */     StringBuilder fieldName = null;
/*     */ 
/* 123 */     Class returnType = method.getReturnType();
/* 124 */     Class[] paramTypes = method.getParameterTypes();
/* 125 */     if ((!Void.TYPE.equals(returnType)) && (paramTypes.length == 0))
/*     */     {
/* 127 */       String name = method.getName();
/* 128 */       if ((name.startsWith("is")) && (name.length() > 2))
/*     */       {
/* 130 */         if (Boolean.TYPE.equals(returnType))
/*     */         {
/* 132 */           fieldName = new StringBuilder();
/* 133 */           fieldName.append(Character.toLowerCase(name.charAt(2)));
/* 134 */           if (name.length() > 3)
/* 135 */             fieldName.append(name.substring(3));
/*     */         }
/*     */       }
/* 138 */       else if ((name.startsWith("get")) && (name.length() > 3))
/*     */       {
/* 140 */         fieldName = new StringBuilder();
/* 141 */         fieldName.append(Character.toLowerCase(name.charAt(3)));
/* 142 */         if (name.length() > 4) {
/* 143 */           fieldName.append(name.substring(4));
/*     */         }
/*     */       }
/*     */     }
/* 147 */     if (fieldName == null) {
/* 148 */       return null;
/*     */     }
/* 150 */     String result = fieldName.toString();
/* 151 */     compositeDataKeyCache.put(method, result);
/* 152 */     return result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metatype.plugins.values.CompositeValueInvocationHandler
 * JD-Core Version:    0.6.0
 */