/*     */ package org.jboss.metatype.plugins.types;
/*     */ 
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import java.util.TreeMap;
/*     */ import org.jboss.metatype.api.types.AbstractMetaType;
/*     */ import org.jboss.metatype.api.types.CompositeMetaType;
/*     */ import org.jboss.metatype.api.types.MetaType;
/*     */ import org.jboss.metatype.api.values.CompositeValue;
/*     */ 
/*     */ public abstract class AbstractCompositeMetaType extends AbstractMetaType
/*     */   implements CompositeMetaType
/*     */ {
/*     */   private static final long serialVersionUID = -7421421680257307598L;
/*     */   private TreeMap<String, String> nameToDescription;
/*     */   private TreeMap<String, MetaType> nameToType;
/*     */   private Set<String> keys;
/*     */ 
/*     */   protected AbstractCompositeMetaType(String typeName, String description, String[] itemNames, String[] itemDescriptions, MetaType[] itemTypes, boolean ignoreItems)
/*     */   {
/*  84 */     super(CompositeValue.class.getName(), typeName, description);
/*  85 */     if (ignoreItems)
/*     */     {
/*  87 */       this.nameToDescription = new TreeMap();
/*  88 */       this.nameToType = new TreeMap();
/*  89 */       return;
/*     */     }
/*  91 */     if ((itemNames == null) || (itemNames.length == 0))
/*  92 */       throw new IllegalArgumentException("null or empty itemNames");
/*  93 */     if ((itemDescriptions == null) || (itemDescriptions.length == 0))
/*  94 */       throw new IllegalArgumentException("null or empty itemDescriptions");
/*  95 */     if ((itemTypes == null) || (itemTypes.length == 0))
/*  96 */       throw new IllegalArgumentException("null or empty itemTypes");
/*  97 */     if (itemNames.length != itemDescriptions.length)
/*  98 */       throw new IllegalArgumentException("wrong number of itemDescriptions");
/*  99 */     if (itemNames.length != itemTypes.length)
/* 100 */       throw new IllegalArgumentException("wrong number of itemTypes");
/* 101 */     this.nameToDescription = new TreeMap();
/* 102 */     this.nameToType = new TreeMap();
/* 103 */     for (int i = 0; i < itemNames.length; i++)
/*     */     {
/*     */       try
/*     */       {
/* 107 */         addItem(itemNames[i], itemDescriptions[i], itemTypes[i]);
/*     */       }
/*     */       catch (IllegalArgumentException e)
/*     */       {
/* 111 */         IllegalArgumentException e1 = new IllegalArgumentException(e.getMessage() + " for item " + i);
/* 112 */         e1.setStackTrace(e.getStackTrace());
/* 113 */         throw e1;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected AbstractCompositeMetaType(String typeName, String description)
/*     */   {
/* 127 */     this(typeName, description, null, null, null, true);
/*     */   }
/*     */ 
/*     */   protected void setKeys(Set<String> keySet)
/*     */   {
/* 137 */     if (keySet != null)
/*     */     {
/* 139 */       for (String key : keySet)
/*     */       {
/* 141 */         if (!containsItem(key))
/* 142 */           throw new IllegalArgumentException("Key " + key + " is not an item " + itemSet());
/*     */       }
/*     */     }
/* 145 */     this.keys = keySet;
/*     */   }
/*     */ 
/*     */   protected void addItem(String itemName, String itemDescription, MetaType itemType)
/*     */   {
/* 158 */     if (itemName == null)
/* 159 */       throw new IllegalArgumentException("null item name");
/* 160 */     itemName = itemName.trim();
/* 161 */     if (itemName.length() == 0)
/* 162 */       throw new IllegalArgumentException("empty item name");
/* 163 */     if (this.nameToDescription.containsKey(itemName))
/* 164 */       throw new IllegalArgumentException("duplicate item name " + itemName);
/* 165 */     if (itemDescription == null)
/* 166 */       throw new IllegalArgumentException("null item description");
/* 167 */     itemDescription = itemDescription.trim();
/* 168 */     if (itemDescription.length() == 0)
/* 169 */       throw new IllegalArgumentException("empty item description");
/* 170 */     if (itemType == null)
/* 171 */       throw new IllegalArgumentException("null item type");
/* 172 */     this.nameToDescription.put(itemName, itemDescription);
/* 173 */     this.nameToType.put(itemName, itemType);
/*     */   }
/*     */ 
/*     */   public boolean containsItem(String itemName)
/*     */   {
/* 178 */     if (itemName == null)
/* 179 */       return false;
/* 180 */     return this.nameToDescription.containsKey(itemName);
/*     */   }
/*     */ 
/*     */   public String getDescription(String itemName)
/*     */   {
/* 185 */     if (itemName == null)
/* 186 */       return null;
/* 187 */     return (String)this.nameToDescription.get(itemName);
/*     */   }
/*     */ 
/*     */   public boolean isComposite()
/*     */   {
/* 193 */     return true;
/*     */   }
/*     */ 
/*     */   public MetaType getType(String itemName)
/*     */   {
/* 198 */     if (itemName == null)
/* 199 */       return null;
/* 200 */     return (MetaType)this.nameToType.get(itemName);
/*     */   }
/*     */ 
/*     */   public Set<String> itemSet()
/*     */   {
/* 205 */     return Collections.unmodifiableSet(this.nameToDescription.keySet());
/*     */   }
/*     */ 
/*     */   public Set<String> keySet()
/*     */   {
/* 210 */     if (this.keys == null)
/* 211 */       return itemSet();
/* 212 */     return Collections.unmodifiableSet(this.keys);
/*     */   }
/*     */ 
/*     */   public boolean isValue(Object obj)
/*     */   {
/* 218 */     if ((obj == null) || (!(obj instanceof CompositeValue)))
/* 219 */       return false;
/* 220 */     return equalsImpl(((CompositeValue)obj).getMetaType());
/*     */   }
/*     */ 
/*     */   protected boolean equalsImpl(Object obj)
/*     */   {
/* 231 */     if (this == obj)
/* 232 */       return true;
/* 233 */     if ((obj == null) || (!(obj instanceof CompositeMetaType))) {
/* 234 */       return false;
/*     */     }
/* 236 */     CompositeMetaType other = (CompositeMetaType)obj;
/* 237 */     if (!getTypeName().equals(other.getTypeName()))
/* 238 */       return false;
/* 239 */     Iterator thisNames = keySet().iterator();
/* 240 */     Iterator otherNames = other.keySet().iterator();
/* 241 */     while ((thisNames.hasNext()) && (otherNames.hasNext()))
/*     */     {
/* 243 */       String thisName = (String)thisNames.next();
/* 244 */       String otherName = (String)otherNames.next();
/* 245 */       if (!thisName.equals(otherName)) {
/* 246 */         return false;
/*     */       }
/* 248 */       if (!getType(thisName).equals(other.getType(otherName))) {
/* 249 */         return false;
/*     */       }
/*     */     }
/* 252 */     return (!thisNames.hasNext()) && (!otherNames.hasNext());
/*     */   }
/*     */ 
/*     */   protected int hashCodeImpl()
/*     */   {
/* 264 */     int hashCode = getTypeName().hashCode();
/* 265 */     for (Object o : this.nameToType.values())
/* 266 */       hashCode += o.hashCode();
/* 267 */     for (Object o : keySet())
/* 268 */       hashCode += o.hashCode();
/* 269 */     return hashCode;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 275 */     StringBuilder buffer = new StringBuilder(getClass().getSimpleName());
/* 276 */     buffer.append('{').append(getTypeName());
/* 277 */     Iterator thisNames = keySet().iterator();
/* 278 */     if (thisNames.hasNext())
/*     */     {
/* 280 */       buffer.append(" items=");
/* 281 */       while (thisNames.hasNext())
/*     */       {
/* 283 */         String thisName = (String)thisNames.next();
/* 284 */         buffer.append("[");
/* 285 */         buffer.append("name=");
/* 286 */         buffer.append(thisName);
/* 287 */         buffer.append(" type=");
/* 288 */         buffer.append(getType(thisName).getTypeName());
/* 289 */         buffer.append("]");
/* 290 */         if (thisNames.hasNext())
/* 291 */           buffer.append(", ");
/*     */       }
/*     */     }
/* 294 */     buffer.append('}');
/* 295 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metatype.plugins.types.AbstractCompositeMetaType
 * JD-Core Version:    0.6.0
 */