/*     */ package org.jboss.metatype.api.values;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.jboss.metatype.api.types.GenericMetaType;
/*     */ 
/*     */ public class GenericValueSupport extends AbstractMetaValue
/*     */   implements GenericValue
/*     */ {
/*     */   private static final long serialVersionUID = 5552880928848272037L;
/*     */   private GenericMetaType metaType;
/*     */   private Serializable value;
/*     */ 
/*     */   public GenericValueSupport(GenericMetaType metaType, Serializable value)
/*     */   {
/*  55 */     if (metaType == null)
/*  56 */       throw new IllegalArgumentException("Null generic meta type");
/*  57 */     this.metaType = metaType;
/*  58 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public GenericMetaType getMetaType()
/*     */   {
/*  63 */     return this.metaType;
/*     */   }
/*     */ 
/*     */   public Serializable getValue()
/*     */   {
/*  73 */     return this.value;
/*     */   }
/*     */ 
/*     */   public void setValue(Serializable value)
/*     */   {
/*  83 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  89 */     if (obj == this) {
/*  90 */       return true;
/*     */     }
/*  92 */     if ((obj == null) || (!(obj instanceof GenericValue))) {
/*  93 */       return false;
/*     */     }
/*  95 */     GenericValue other = (GenericValue)obj;
/*  96 */     if (!this.metaType.equals(other.getMetaType())) {
/*  97 */       return false;
/*     */     }
/*  99 */     Object otherValue = other.getValue();
/* 100 */     if ((this.value == null) && (otherValue == null))
/* 101 */       return true;
/* 102 */     if ((this.value == null) && (otherValue != null))
/* 103 */       return false;
/* 104 */     return this.value.equals(otherValue);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 110 */     if (this.value == null)
/* 111 */       return 0;
/* 112 */     return this.value.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 118 */     return this.metaType + ":" + this.value;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metatype.api.values.GenericValueSupport
 * JD-Core Version:    0.6.0
 */