/*     */ package org.jboss.metatype.api.values;
/*     */ 
/*     */ import java.util.Arrays;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.metatype.api.types.CollectionMetaType;
/*     */ 
/*     */ public class CollectionValueSupport extends AbstractMetaValue
/*     */   implements CollectionValue
/*     */ {
/*     */   private static final long serialVersionUID = 1131827130033538066L;
/*     */   private CollectionMetaType metaType;
/*     */   private MetaValue[] elements;
/*     */ 
/*     */   public CollectionValueSupport(CollectionMetaType metaType)
/*     */   {
/*  53 */     if (metaType == null)
/*  54 */       throw new IllegalArgumentException("Null collection meta type");
/*  55 */     this.metaType = metaType;
/*     */   }
/*     */ 
/*     */   public CollectionValueSupport(CollectionMetaType metaType, MetaValue[] elements)
/*     */   {
/*  67 */     this(metaType);
/*  68 */     this.elements = elements;
/*     */   }
/*     */ 
/*     */   public CollectionMetaType getMetaType()
/*     */   {
/*  73 */     return this.metaType;
/*     */   }
/*     */ 
/*     */   public MetaValue[] getElements()
/*     */   {
/*  83 */     return this.elements;
/*     */   }
/*     */ 
/*     */   public int getSize()
/*     */   {
/*  92 */     return this.elements != null ? this.elements.length : 0;
/*     */   }
/*     */ 
/*     */   public Iterator<MetaValue> iterator()
/*     */   {
/*  97 */     return new ElementsIterator(this.elements);
/*     */   }
/*     */ 
/*     */   public void setElements(MetaValue[] elements)
/*     */   {
/* 107 */     this.elements = elements;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 114 */     if (obj == this) {
/* 115 */       return true;
/*     */     }
/* 117 */     if ((obj == null) || (!(obj instanceof CollectionValue))) {
/* 118 */       return false;
/*     */     }
/* 120 */     CollectionValue other = (CollectionValue)obj;
/* 121 */     if (!this.metaType.equals(other.getMetaType())) {
/* 122 */       return false;
/*     */     }
/* 124 */     Object[] otherElements = other.getElements();
/* 125 */     if (this.elements == null) {
/* 126 */       return otherElements == null;
/*     */     }
/* 128 */     return (otherElements != null) && (Arrays.equals(this.elements, otherElements));
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 134 */     if (this.elements == null)
/* 135 */       return 0;
/* 136 */     return this.elements.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 142 */     return this.metaType + ": " + this.elements;
/*     */   }
/*     */ 
/*     */   public MetaValue clone()
/*     */   {
/* 149 */     CollectionValueSupport result = (CollectionValueSupport)super.clone();
/* 150 */     int size = getSize();
/* 151 */     if (size > 0)
/*     */     {
/* 153 */       result.elements = new MetaValue[size];
/* 154 */       System.arraycopy(this.elements, 0, result.elements, 0, size);
/*     */     }
/* 156 */     return result;
/*     */   }
/*     */   private static class ElementsIterator implements Iterator<MetaValue> {
/*     */     private int index;
/*     */     private int length;
/*     */     private MetaValue[] elements;
/*     */ 
/*     */     ElementsIterator(MetaValue[] elements) {
/* 167 */       this.elements = elements;
/* 168 */       this.index = 0;
/* 169 */       this.length = (elements != null ? elements.length : 0);
/*     */     }
/*     */ 
/*     */     public boolean hasNext()
/*     */     {
/* 174 */       return this.index < this.length;
/*     */     }
/*     */ 
/*     */     public MetaValue next()
/*     */     {
/* 179 */       return this.elements[(this.index++)];
/*     */     }
/*     */ 
/*     */     public void remove()
/*     */     {
/* 184 */       throw new UnsupportedOperationException();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metatype.api.values.CollectionValueSupport
 * JD-Core Version:    0.6.0
 */