/*     */ package org.jboss.metatype.api.types;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.metatype.api.values.TableValue;
/*     */ 
/*     */ public class ImmutableTableMetaType extends AbstractMetaType
/*     */   implements TableMetaType
/*     */ {
/*     */   private static final long serialVersionUID = 5791103660662775558L;
/*     */   private CompositeMetaType rowType;
/*     */   private List<String> indexNames;
/*  49 */   private transient int cachedHashCode = -2147483648;
/*     */ 
/*  52 */   private transient String cachedToString = null;
/*     */ 
/*     */   public ImmutableTableMetaType(String typeName, String description, CompositeMetaType rowType, String[] indexNames)
/*     */   {
/*  72 */     super(TableValue.class.getName(), typeName, description);
/*  73 */     if (rowType == null)
/*  74 */       throw new IllegalArgumentException("null rowType");
/*  75 */     if ((indexNames == null) || (indexNames.length == 0))
/*  76 */       throw new IllegalArgumentException("null or empty indexNames");
/*  77 */     this.rowType = rowType;
/*  78 */     this.indexNames = new ArrayList();
/*  79 */     for (int i = 0; i < indexNames.length; i++)
/*     */     {
/*  81 */       if (indexNames[i] == null)
/*  82 */         throw new IllegalArgumentException("null index name " + i);
/*  83 */       String indexName = indexNames[i].trim();
/*  84 */       if (indexName.length() == 0)
/*  85 */         throw new IllegalArgumentException("empty index name " + i);
/*  86 */       if (!rowType.containsItem(indexName))
/*  87 */         throw new IllegalArgumentException("no item name " + indexName);
/*  88 */       this.indexNames.add(indexName);
/*     */     }
/*     */   }
/*     */ 
/*     */   public CompositeMetaType getRowType()
/*     */   {
/*  94 */     return this.rowType;
/*     */   }
/*     */ 
/*     */   public List<String> getIndexNames()
/*     */   {
/*  99 */     return Collections.unmodifiableList(this.indexNames);
/*     */   }
/*     */ 
/*     */   public boolean isTable()
/*     */   {
/* 105 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isValue(Object obj)
/*     */   {
/* 111 */     if ((obj == null) || (!(obj instanceof TableValue)))
/* 112 */       return false;
/* 113 */     TableMetaType other = ((TableValue)obj).getMetaType();
/* 114 */     return equals(other);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 120 */     if (this == obj)
/* 121 */       return true;
/* 122 */     if ((obj == null) || (!(obj instanceof TableMetaType))) {
/* 123 */       return false;
/*     */     }
/* 125 */     TableMetaType other = (TableMetaType)obj;
/* 126 */     if (!getTypeName().equals(other.getTypeName()))
/* 127 */       return false;
/* 128 */     if (!getRowType().equals(other.getRowType()))
/* 129 */       return false;
/* 130 */     Iterator thisNames = getIndexNames().iterator();
/* 131 */     Iterator otherNames = other.getIndexNames().iterator();
/* 132 */     while ((thisNames.hasNext()) && (otherNames.hasNext()))
/*     */     {
/* 134 */       String thisName = (String)thisNames.next();
/* 135 */       String otherName = (String)otherNames.next();
/* 136 */       if (!thisName.equals(otherName)) {
/* 137 */         return false;
/*     */       }
/*     */     }
/* 140 */     return (!thisNames.hasNext()) && (!otherNames.hasNext());
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 148 */     if (this.cachedHashCode != -2147483648)
/* 149 */       return this.cachedHashCode;
/* 150 */     this.cachedHashCode = getTypeName().hashCode();
/* 151 */     this.cachedHashCode += getRowType().hashCode();
/* 152 */     for (Iterator i = this.indexNames.iterator(); i.hasNext(); )
/* 153 */       this.cachedHashCode += i.next().hashCode();
/* 154 */     return this.cachedHashCode;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 160 */     if (this.cachedToString != null)
/* 161 */       return this.cachedToString;
/* 162 */     StringBuilder buffer = new StringBuilder(getClass().getSimpleName());
/* 163 */     buffer.append(": typeName=[");
/* 164 */     buffer.append(getTypeName());
/* 165 */     buffer.append("] rowType=[");
/* 166 */     buffer.append(getRowType());
/* 167 */     buffer.append("] indexNames=[");
/* 168 */     Iterator thisNames = getIndexNames().iterator();
/* 169 */     while (thisNames.hasNext())
/*     */     {
/* 171 */       buffer.append(thisNames.next());
/* 172 */       if (thisNames.hasNext())
/* 173 */         buffer.append(", ");
/*     */     }
/* 175 */     buffer.append("]");
/* 176 */     this.cachedToString = buffer.toString();
/* 177 */     return this.cachedToString;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metatype.api.types.ImmutableTableMetaType
 * JD-Core Version:    0.6.0
 */