/*     */ package org.jboss.metatype.api.types;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import org.jboss.metatype.api.values.SimpleValue;
/*     */ 
/*     */ public class EnumMetaType extends AbstractMetaType
/*     */ {
/*     */   private static final long serialVersionUID = 6786422588217893696L;
/*     */   private List<String> validValues;
/*     */ 
/*     */   public EnumMetaType(String className, List<String> validValues)
/*     */   {
/*  52 */     super(String.class.getName(), className, className);
/*  53 */     if (validValues == null)
/*  54 */       throw new IllegalArgumentException("Null valid values");
/*  55 */     this.validValues = validValues;
/*     */   }
/*     */ 
/*     */   public EnumMetaType(Enum[] validValues)
/*     */   {
/*  64 */     super(String.class.getName(), isValid(validValues) ? validValues[0].getClass().getName() : null, isValid(validValues) ? validValues[0].getClass().getName() : null);
/*     */ 
/*  69 */     if (!isValid(validValues))
/*  70 */       throw new IllegalArgumentException("Null or empty valid values");
/*  71 */     ArrayList values = new ArrayList();
/*  72 */     for (Enum e : validValues)
/*  73 */       values.add(e.name());
/*  74 */     this.validValues = values;
/*     */   }
/*     */ 
/*     */   protected static boolean isValid(Enum[] values)
/*     */   {
/*  85 */     return (values != null) && (values.length > 0);
/*     */   }
/*     */ 
/*     */   public List<String> getValidValues()
/*     */   {
/*  95 */     return Collections.unmodifiableList(this.validValues);
/*     */   }
/*     */ 
/*     */   public boolean isEnum()
/*     */   {
/* 101 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isValue(Object obj)
/*     */   {
/* 107 */     if ((obj == null) || (!(obj instanceof SimpleValue))) {
/* 108 */       return false;
/*     */     }
/* 110 */     SimpleValue value = (SimpleValue)obj;
/* 111 */     if ((SimpleMetaType.STRING == value.getMetaType() ? 1 : 0) == 0)
/* 112 */       return false;
/* 113 */     return this.validValues.contains(value.getValue());
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 119 */     if (this == obj)
/* 120 */       return true;
/* 121 */     if ((obj == null) || (!(obj instanceof EnumMetaType)))
/* 122 */       return false;
/* 123 */     EnumMetaType other = (EnumMetaType)obj;
/* 124 */     return (getTypeName().equals(other.getTypeName())) && (getValidValues().equals(other.getValidValues()));
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 130 */     return getTypeName() + "{" + this.validValues + "}";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metatype.api.types.EnumMetaType
 * JD-Core Version:    0.6.0
 */