/*     */ package org.jboss.metatype.api.types;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectInputStream.GetField;
/*     */ import java.io.ObjectStreamField;
/*     */ import java.io.Serializable;
/*     */ import java.util.List;
/*     */ 
/*     */ public abstract class AbstractMetaType<T extends Serializable>
/*     */   implements MetaType<T>
/*     */ {
/*     */   private static final long serialVersionUID = 5786422588217893696L;
/*  42 */   private static final ObjectStreamField[] serialPersistentFields = { new ObjectStreamField("className", String.class), new ObjectStreamField("description", String.class), new ObjectStreamField("typeName", String.class) };
/*     */   private String className;
/*     */   private String description;
/*     */   private String typeName;
/*  61 */   private transient boolean array = false;
/*     */ 
/*     */   protected AbstractMetaType(String className, String typeName, String description)
/*     */   {
/*  78 */     init(className, typeName, description);
/*     */   }
/*     */ 
/*     */   protected AbstractMetaType(String className, String description)
/*     */   {
/*  95 */     init(className, className, description);
/*     */   }
/*     */ 
/*     */   protected AbstractMetaType(String className)
/*     */   {
/* 110 */     init(className, className, className);
/*     */   }
/*     */ 
/*     */   public String getClassName()
/*     */   {
/* 115 */     return this.className;
/*     */   }
/*     */ 
/*     */   public String getTypeName()
/*     */   {
/* 120 */     return this.typeName;
/*     */   }
/*     */ 
/*     */   public String getDescription()
/*     */   {
/* 125 */     return this.description;
/*     */   }
/*     */ 
/*     */   public boolean isEnum()
/*     */   {
/* 130 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isComposite()
/*     */   {
/* 135 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isSimple()
/*     */   {
/* 140 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isGeneric()
/*     */   {
/* 145 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isTable()
/*     */   {
/* 150 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isArray()
/*     */   {
/* 155 */     return this.array;
/*     */   }
/*     */ 
/*     */   public boolean isCollection()
/*     */   {
/* 160 */     return false;
/*     */   }
/*     */ 
/*     */   public abstract boolean isValue(Object paramObject);
/*     */ 
/*     */   private void init(String className, String typeName, String description)
/*     */   {
/* 178 */     if ((className == null) || (className.trim().equals("")))
/* 179 */       throw new IllegalArgumentException("null or empty class name");
/* 180 */     if ((typeName == null) || (typeName.trim().equals("")))
/* 181 */       throw new IllegalArgumentException("null or empty type name");
/* 182 */     if ((description == null) || (description.trim().equals(""))) {
/* 183 */       throw new IllegalArgumentException("null or empty description");
/*     */     }
/* 185 */     if (!isCollection())
/*     */     {
/* 188 */       String testClassName = getBaseClassName(className);
/* 189 */       if (testClassName == null)
/* 190 */         throw new IllegalArgumentException("Invalid array declaration (see the javadocs for java.lang.Class): " + className);
/* 191 */       if (!testClassName.equals(className)) {
/* 192 */         this.array = true;
/*     */       }
/*     */ 
/* 195 */       boolean ok = false;
/* 196 */       for (int i = 0; i < ALLOWED_CLASSNAMES.size(); i++)
/*     */       {
/* 198 */         if (!testClassName.equals(ALLOWED_CLASSNAMES.get(i)))
/*     */           continue;
/* 200 */         ok = true;
/* 201 */         break;
/*     */       }
/*     */ 
/* 204 */       if (!ok)
/*     */       {
/* 207 */         int index = className.lastIndexOf('[');
/* 208 */         if (index == className.length() - 2)
/* 209 */           ok = ArrayMetaType.isPrimitiveEncoding(className.substring(index + 1));
/* 210 */         if (!ok) {
/* 211 */           throw new IllegalArgumentException("Not a MetaType allowed class name: " + className);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 216 */     this.className = className;
/* 217 */     this.typeName = typeName;
/* 218 */     this.description = description;
/*     */   }
/*     */ 
/*     */   private static String getBaseClassName(String className)
/*     */   {
/* 234 */     int length = className.length();
/* 235 */     int last = length - 1;
/* 236 */     int i = 0;
/*     */ 
/* 239 */     while ((i < length) && (className.charAt(i) == '[')) {
/* 240 */       i++;
/*     */     }
/*     */ 
/* 243 */     if (i > 0)
/*     */     {
/* 246 */       char type = className.charAt(i);
/*     */ 
/* 248 */       if ((type == 'B') || (type == 'C') || (type == 'D') || (type == 'F') || (type == 'I') || (type == 'J') || (type == 'S') || (type == 'Z') || (type == 'V'))
/*     */       {
/* 251 */         if (i != last)
/* 252 */           return null;
/* 253 */         return className.substring(last, length);
/*     */       }
/*     */ 
/* 256 */       if ((className.charAt(i) != 'L') || (i >= last - 1) || (className.charAt(last) != ';'))
/*     */       {
/* 259 */         return null;
/*     */       }
/*     */ 
/* 262 */       return className.substring(i + 1, last);
/*     */     }
/*     */ 
/* 266 */     return className;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 278 */     ObjectInputStream.GetField getField = in.readFields();
/* 279 */     String className = (String)getField.get("className", null);
/* 280 */     String typeName = (String)getField.get("typeName", null);
/* 281 */     String description = (String)getField.get("description", null);
/*     */     try
/*     */     {
/* 284 */       init(className, typeName, description);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 288 */       throw new RuntimeException("Unexpected error deserializing MetaType: " + className, e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metatype.api.types.AbstractMetaType
 * JD-Core Version:    0.6.0
 */