/*     */ package org.jboss.metadata.web.spec;
/*     */ 
/*     */ import java.util.List;
/*     */ import javax.xml.bind.annotation.XmlAttribute;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlTransient;
/*     */ import org.jboss.metadata.javaee.spec.AnnotatedEJBReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBLocalReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBLocalReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EmptyMetaData;
/*     */ import org.jboss.metadata.javaee.spec.Environment;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
/*     */ import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationsMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ParamValueMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PersistenceContextReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PersistenceContextReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PersistenceUnitReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PersistenceUnitReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.support.AbstractMappedMetaData;
/*     */ import org.jboss.metadata.javaee.support.IdMetaDataImplWithDescriptionGroup;
/*     */ 
/*     */ public class WebMetaData extends IdMetaDataImplWithDescriptionGroup
/*     */   implements Environment
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private String dtdPublicId;
/*     */   private String dtdSystemId;
/*     */   private String version;
/*     */   private EmptyMetaData distributable;
/*     */   private List<ParamValueMetaData> contextParams;
/*     */   private SessionConfigMetaData sessionConfig;
/*     */   private FiltersMetaData filters;
/*     */   private List<FilterMappingMetaData> filterMappings;
/*     */   private List<ErrorPageMetaData> errorPages;
/*     */   private JspConfigMetaData jspConfig;
/*     */   private List<ListenerMetaData> listeners;
/*     */   private LoginConfigMetaData loginConfig;
/*     */   private List<MimeMappingMetaData> mimeMappings;
/*     */   private ServletsMetaData servlets;
/*     */   private List<ServletMappingMetaData> servletMappings;
/*     */   private List<SecurityConstraintMetaData> securityContraints;
/*     */   private SecurityRolesMetaData securityRoles;
/*     */   private WelcomeFileListMetaData welcomeFileList;
/*     */   private LocaleEncodingsMetaData localEncodings;
/*     */   private EnvironmentRefsGroupMetaData jndiEnvironmentRefsGroup;
/*     */   private MessageDestinationsMetaData messageDestinations;
/*     */ 
/*     */   @XmlTransient
/*     */   public void setDTD(String root, String publicId, String systemId)
/*     */   {
/* 106 */     this.dtdPublicId = publicId;
/* 107 */     this.dtdSystemId = systemId;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public String getDtdPublicId()
/*     */   {
/* 116 */     return this.dtdPublicId;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public String getDtdSystemId()
/*     */   {
/* 125 */     return this.dtdSystemId;
/*     */   }
/*     */ 
/*     */   public String getVersion()
/*     */   {
/* 130 */     return this.version;
/*     */   }
/*     */   @XmlAttribute
/*     */   public void setVersion(String version) {
/* 135 */     this.version = version;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public boolean is23()
/*     */   {
/* 145 */     return (this.dtdPublicId != null) && (this.dtdPublicId.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN"));
/*     */   }
/*     */   @XmlTransient
/*     */   public boolean is24() {
/* 150 */     return (this.version != null) && (this.version.equals("2.4"));
/*     */   }
/*     */   @XmlTransient
/*     */   public boolean is25() {
/* 155 */     return (this.version != null) && (this.version.equals("2.5"));
/*     */   }
/*     */ 
/*     */   public EmptyMetaData getDistributable()
/*     */   {
/* 160 */     return this.distributable;
/*     */   }
/*     */ 
/*     */   public void setDistributable(EmptyMetaData distributable) {
/* 164 */     this.distributable = distributable;
/*     */   }
/*     */ 
/*     */   public SessionConfigMetaData getSessionConfig() {
/* 168 */     return this.sessionConfig;
/*     */   }
/*     */ 
/*     */   public void setSessionConfig(SessionConfigMetaData sessionConfig) {
/* 172 */     this.sessionConfig = sessionConfig;
/*     */   }
/*     */ 
/*     */   public List<ParamValueMetaData> getContextParams() {
/* 176 */     return this.contextParams;
/*     */   }
/*     */   @XmlElement(name="context-param")
/*     */   public void setContextParams(List<ParamValueMetaData> params) {
/* 181 */     this.contextParams = params;
/*     */   }
/*     */ 
/*     */   public FiltersMetaData getFilters()
/*     */   {
/* 186 */     return this.filters;
/*     */   }
/*     */   @XmlElement(name="filter")
/*     */   public void setFilters(FiltersMetaData filters) {
/* 191 */     this.filters = filters;
/*     */   }
/*     */ 
/*     */   public List<FilterMappingMetaData> getFilterMappings()
/*     */   {
/* 196 */     return this.filterMappings;
/*     */   }
/*     */   @XmlElement(name="filter-mapping")
/*     */   public void setFilterMappings(List<FilterMappingMetaData> filterMappings) {
/* 201 */     this.filterMappings = filterMappings;
/*     */   }
/*     */ 
/*     */   public List<ErrorPageMetaData> getErrorPages()
/*     */   {
/* 206 */     return this.errorPages;
/*     */   }
/*     */   @XmlElement(name="error-page")
/*     */   public void setErrorPages(List<ErrorPageMetaData> errorPages) {
/* 211 */     this.errorPages = errorPages;
/*     */   }
/*     */ 
/*     */   public JspConfigMetaData getJspConfig()
/*     */   {
/* 216 */     return this.jspConfig;
/*     */   }
/*     */ 
/*     */   public void setJspConfig(JspConfigMetaData jspConfig) {
/* 220 */     this.jspConfig = jspConfig;
/*     */   }
/*     */ 
/*     */   public List<ListenerMetaData> getListeners()
/*     */   {
/* 225 */     return this.listeners;
/*     */   }
/*     */   @XmlElement(name="listener")
/*     */   public void setListeners(List<ListenerMetaData> listeners) {
/* 230 */     this.listeners = listeners;
/*     */   }
/*     */ 
/*     */   public LocaleEncodingsMetaData getLocalEncodings()
/*     */   {
/* 235 */     return this.localEncodings;
/*     */   }
/*     */   @XmlElement(name="locale-encoding-mapping-list")
/*     */   public void setLocalEncodings(LocaleEncodingsMetaData localEncodings) {
/* 240 */     this.localEncodings = localEncodings;
/*     */   }
/*     */ 
/*     */   public LoginConfigMetaData getLoginConfig()
/*     */   {
/* 245 */     return this.loginConfig;
/*     */   }
/*     */ 
/*     */   public void setLoginConfig(LoginConfigMetaData loginConfig) {
/* 249 */     this.loginConfig = loginConfig;
/*     */   }
/*     */ 
/*     */   public List<MimeMappingMetaData> getMimeMappings()
/*     */   {
/* 254 */     return this.mimeMappings;
/*     */   }
/*     */   @XmlElement(name="mime-mapping")
/*     */   public void setMimeMappings(List<MimeMappingMetaData> mimeMappings) {
/* 259 */     this.mimeMappings = mimeMappings;
/*     */   }
/*     */ 
/*     */   public ServletsMetaData getServlets()
/*     */   {
/* 264 */     return this.servlets;
/*     */   }
/*     */   @XmlElement(name="servlet")
/*     */   public void setServlets(ServletsMetaData servlets) {
/* 269 */     this.servlets = servlets;
/*     */   }
/*     */ 
/*     */   public List<ServletMappingMetaData> getServletMappings()
/*     */   {
/* 274 */     return this.servletMappings;
/*     */   }
/*     */   @XmlElement(name="servlet-mapping")
/*     */   public void setServletMappings(List<ServletMappingMetaData> servletMappings) {
/* 279 */     this.servletMappings = servletMappings;
/*     */   }
/*     */ 
/*     */   public List<SecurityConstraintMetaData> getSecurityContraints()
/*     */   {
/* 284 */     return this.securityContraints;
/*     */   }
/*     */   @XmlElement(name="security-constraint")
/*     */   public void setSecurityContraints(List<SecurityConstraintMetaData> securityContraints) {
/* 289 */     this.securityContraints = securityContraints;
/*     */   }
/*     */ 
/*     */   public SecurityRolesMetaData getSecurityRoles()
/*     */   {
/* 294 */     return this.securityRoles;
/*     */   }
/*     */   @XmlElement(name="security-role")
/*     */   public void setSecurityRoles(SecurityRolesMetaData securityRoles) {
/* 299 */     this.securityRoles = securityRoles;
/*     */   }
/*     */ 
/*     */   public WelcomeFileListMetaData getWelcomeFileList()
/*     */   {
/* 304 */     return this.welcomeFileList;
/*     */   }
/*     */ 
/*     */   public void setWelcomeFileList(WelcomeFileListMetaData welcomeFileList) {
/* 308 */     this.welcomeFileList = welcomeFileList;
/*     */   }
/*     */ 
/*     */   public EnvironmentRefsGroupMetaData getJndiEnvironmentRefsGroup()
/*     */   {
/* 318 */     return this.jndiEnvironmentRefsGroup;
/*     */   }
/*     */ 
/*     */   public void setJndiEnvironmentRefsGroup(EnvironmentRefsGroupMetaData env)
/*     */   {
/* 329 */     if (env == null)
/* 330 */       throw new IllegalArgumentException("Null jndiEnvironmentRefsGroup");
/* 331 */     if (this.jndiEnvironmentRefsGroup != null)
/* 332 */       this.jndiEnvironmentRefsGroup.merge(env, null, "jboss-web.xml", "web.xml", false);
/*     */     else
/* 334 */       this.jndiEnvironmentRefsGroup = env;
/*     */   }
/*     */ 
/*     */   public EJBLocalReferenceMetaData getEjbLocalReferenceByName(String name)
/*     */   {
/* 339 */     return (EJBLocalReferenceMetaData)AbstractMappedMetaData.getByName(name, getEjbLocalReferences());
/*     */   }
/*     */ 
/*     */   public EJBLocalReferencesMetaData getEjbLocalReferences()
/*     */   {
/* 344 */     if (this.jndiEnvironmentRefsGroup != null)
/* 345 */       return this.jndiEnvironmentRefsGroup.getEjbLocalReferences();
/* 346 */     return null;
/*     */   }
/*     */ 
/*     */   public EJBReferenceMetaData getEjbReferenceByName(String name)
/*     */   {
/* 351 */     return (EJBReferenceMetaData)AbstractMappedMetaData.getByName(name, getEjbReferences());
/*     */   }
/*     */ 
/*     */   public EJBReferencesMetaData getEjbReferences()
/*     */   {
/* 356 */     if (this.jndiEnvironmentRefsGroup != null)
/* 357 */       return this.jndiEnvironmentRefsGroup.getEjbReferences();
/* 358 */     return null;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public AnnotatedEJBReferencesMetaData getAnnotatedEjbReferences() {
/* 364 */     AnnotatedEJBReferencesMetaData refs = null;
/* 365 */     if (this.jndiEnvironmentRefsGroup != null)
/* 366 */       refs = this.jndiEnvironmentRefsGroup.getAnnotatedEjbReferences();
/* 367 */     return refs;
/*     */   }
/*     */ 
/*     */   public EnvironmentEntriesMetaData getEnvironmentEntries()
/*     */   {
/* 372 */     if (this.jndiEnvironmentRefsGroup != null)
/* 373 */       return this.jndiEnvironmentRefsGroup.getEnvironmentEntries();
/* 374 */     return null;
/*     */   }
/*     */ 
/*     */   public EnvironmentEntryMetaData getEnvironmentEntryByName(String name)
/*     */   {
/* 379 */     return (EnvironmentEntryMetaData)AbstractMappedMetaData.getByName(name, getEnvironmentEntries());
/*     */   }
/*     */ 
/*     */   public MessageDestinationReferenceMetaData getMessageDestinationReferenceByName(String name)
/*     */   {
/* 384 */     return (MessageDestinationReferenceMetaData)AbstractMappedMetaData.getByName(name, getMessageDestinationReferences());
/*     */   }
/*     */ 
/*     */   public MessageDestinationReferencesMetaData getMessageDestinationReferences()
/*     */   {
/* 389 */     if (this.jndiEnvironmentRefsGroup != null)
/* 390 */       return this.jndiEnvironmentRefsGroup.getMessageDestinationReferences();
/* 391 */     return null;
/*     */   }
/*     */ 
/*     */   public PersistenceContextReferenceMetaData getPersistenceContextReferenceByName(String name)
/*     */   {
/* 396 */     return (PersistenceContextReferenceMetaData)AbstractMappedMetaData.getByName(name, getPersistenceContextRefs());
/*     */   }
/*     */ 
/*     */   public PersistenceContextReferencesMetaData getPersistenceContextRefs()
/*     */   {
/* 401 */     if (this.jndiEnvironmentRefsGroup != null)
/* 402 */       return this.jndiEnvironmentRefsGroup.getPersistenceContextRefs();
/* 403 */     return null;
/*     */   }
/*     */ 
/*     */   public PersistenceUnitReferenceMetaData getPersistenceUnitReferenceByName(String name)
/*     */   {
/* 408 */     return (PersistenceUnitReferenceMetaData)AbstractMappedMetaData.getByName(name, getPersistenceUnitRefs());
/*     */   }
/*     */ 
/*     */   public PersistenceUnitReferencesMetaData getPersistenceUnitRefs()
/*     */   {
/* 413 */     if (this.jndiEnvironmentRefsGroup != null)
/* 414 */       return this.jndiEnvironmentRefsGroup.getPersistenceUnitRefs();
/* 415 */     return null;
/*     */   }
/*     */ 
/*     */   public LifecycleCallbacksMetaData getPostConstructs()
/*     */   {
/* 420 */     if (this.jndiEnvironmentRefsGroup != null)
/* 421 */       return this.jndiEnvironmentRefsGroup.getPostConstructs();
/* 422 */     return null;
/*     */   }
/*     */ 
/*     */   public LifecycleCallbacksMetaData getPreDestroys()
/*     */   {
/* 427 */     if (this.jndiEnvironmentRefsGroup != null)
/* 428 */       return this.jndiEnvironmentRefsGroup.getPreDestroys();
/* 429 */     return null;
/*     */   }
/*     */ 
/*     */   public ResourceEnvironmentReferenceMetaData getResourceEnvironmentReferenceByName(String name)
/*     */   {
/* 434 */     return (ResourceEnvironmentReferenceMetaData)AbstractMappedMetaData.getByName(name, getResourceEnvironmentReferences());
/*     */   }
/*     */ 
/*     */   public ResourceEnvironmentReferencesMetaData getResourceEnvironmentReferences()
/*     */   {
/* 439 */     if (this.jndiEnvironmentRefsGroup != null)
/* 440 */       return this.jndiEnvironmentRefsGroup.getResourceEnvironmentReferences();
/* 441 */     return null;
/*     */   }
/*     */ 
/*     */   public ResourceReferenceMetaData getResourceReferenceByName(String name)
/*     */   {
/* 446 */     return (ResourceReferenceMetaData)AbstractMappedMetaData.getByName(name, getResourceReferences());
/*     */   }
/*     */ 
/*     */   public ResourceReferencesMetaData getResourceReferences()
/*     */   {
/* 451 */     if (this.jndiEnvironmentRefsGroup != null)
/* 452 */       return this.jndiEnvironmentRefsGroup.getResourceReferences();
/* 453 */     return null;
/*     */   }
/*     */ 
/*     */   public ServiceReferenceMetaData getServiceReferenceByName(String name)
/*     */   {
/* 458 */     return (ServiceReferenceMetaData)AbstractMappedMetaData.getByName(name, getServiceReferences());
/*     */   }
/*     */ 
/*     */   public ServiceReferencesMetaData getServiceReferences()
/*     */   {
/* 463 */     if (this.jndiEnvironmentRefsGroup != null)
/* 464 */       return this.jndiEnvironmentRefsGroup.getServiceReferences();
/* 465 */     return null;
/*     */   }
/*     */ 
/*     */   public MessageDestinationsMetaData getMessageDestinations()
/*     */   {
/* 470 */     return this.messageDestinations;
/*     */   }
/*     */   @XmlElement(name="message-destination")
/*     */   public void setMessageDestinations(MessageDestinationsMetaData messageDestinations) {
/* 475 */     this.messageDestinations = messageDestinations;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.web.spec.WebMetaData
 * JD-Core Version:    0.6.0
 */