/*     */ package org.jboss.metadata.web.spec;
/*     */ 
/*     */ import java.util.List;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import org.jboss.metadata.javaee.spec.ParamValueMetaData;
/*     */ import org.jboss.metadata.javaee.spec.RunAsMetaData;
/*     */ import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
/*     */ import org.jboss.metadata.javaee.support.MergeableMetaData;
/*     */ import org.jboss.metadata.javaee.support.NamedMetaDataWithDescriptionGroup;
/*     */ 
/*     */ public class ServletMetaData extends NamedMetaDataWithDescriptionGroup
/*     */   implements MergeableMetaData<ServletMetaData>
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private String servletClass;
/*     */   private String jspFile;
/*     */   private List<ParamValueMetaData> initParam;
/*  49 */   private int loadOnStartup = -1;
/*     */   private RunAsMetaData runAs;
/*     */   private SecurityRoleRefsMetaData securityRoleRefs;
/*     */ 
/*     */   public String getServletName()
/*     */   {
/*  56 */     return getName();
/*     */   }
/*     */ 
/*     */   public void setServletName(String name) {
/*  60 */     super.setName(name);
/*     */   }
/*     */ 
/*     */   public String getServletClass()
/*     */   {
/*  65 */     return this.servletClass;
/*     */   }
/*     */ 
/*     */   public void setServletClass(String servletClass) {
/*  69 */     this.servletClass = servletClass;
/*     */   }
/*     */ 
/*     */   public List<ParamValueMetaData> getInitParam()
/*     */   {
/*  74 */     return this.initParam;
/*     */   }
/*     */ 
/*     */   public void setInitParam(List<ParamValueMetaData> initParam) {
/*  78 */     this.initParam = initParam;
/*     */   }
/*     */ 
/*     */   public String getJspFile() {
/*  82 */     return this.jspFile;
/*     */   }
/*     */ 
/*     */   public void setJspFile(String jspFile) {
/*  86 */     this.jspFile = jspFile;
/*     */   }
/*     */ 
/*     */   public int getLoadOnStartup() {
/*  90 */     return this.loadOnStartup;
/*     */   }
/*     */ 
/*     */   public void setLoadOnStartup(int loadOnStartup) {
/*  94 */     this.loadOnStartup = loadOnStartup;
/*     */   }
/*     */ 
/*     */   public RunAsMetaData getRunAs() {
/*  98 */     return this.runAs;
/*     */   }
/*     */ 
/*     */   public void setRunAs(RunAsMetaData runAs) {
/* 102 */     this.runAs = runAs;
/*     */   }
/*     */ 
/*     */   public SecurityRoleRefsMetaData getSecurityRoleRefs() {
/* 106 */     return this.securityRoleRefs;
/*     */   }
/*     */   @XmlElement(name="security-role-ref")
/*     */   public void setSecurityRoleRefs(SecurityRoleRefsMetaData securityRoleRefs) {
/* 111 */     this.securityRoleRefs = securityRoleRefs;
/*     */   }
/*     */ 
/*     */   public ServletMetaData merge(ServletMetaData original)
/*     */   {
/* 116 */     ServletMetaData merged = new ServletMetaData();
/* 117 */     merged.merge(this, original);
/* 118 */     return merged;
/*     */   }
/*     */ 
/*     */   public void merge(ServletMetaData override, ServletMetaData original) {
/* 122 */     super.merge(override, original);
/* 123 */     if ((override != null) && (override.servletClass != null))
/* 124 */       setServletClass(override.servletClass);
/* 125 */     else if ((original != null) && (original.servletClass != null))
/* 126 */       setServletClass(original.servletClass);
/* 127 */     if ((override != null) && (override.jspFile != null))
/* 128 */       setJspFile(override.jspFile);
/* 129 */     else if ((original != null) && (original.jspFile != null))
/* 130 */       setJspFile(original.jspFile);
/* 131 */     if ((override != null) && (override.initParam != null))
/* 132 */       setInitParam(override.initParam);
/* 133 */     else if ((original != null) && (original.initParam != null))
/* 134 */       setInitParam(original.initParam);
/* 135 */     if ((override != null) && (override.loadOnStartup > 0))
/* 136 */       setLoadOnStartup(override.loadOnStartup);
/* 137 */     else if ((original != null) && (original.loadOnStartup > 0))
/* 138 */       setLoadOnStartup(original.loadOnStartup);
/* 139 */     if ((override != null) && (override.runAs != null))
/* 140 */       setRunAs(override.runAs);
/* 141 */     else if ((original != null) && (original.runAs != null))
/* 142 */       setRunAs(original.runAs);
/* 143 */     if ((override != null) && (override.securityRoleRefs != null))
/* 144 */       setSecurityRoleRefs(override.securityRoleRefs);
/* 145 */     else if ((original != null) && (original.securityRoleRefs != null))
/* 146 */       setSecurityRoleRefs(original.securityRoleRefs);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 151 */     StringBuilder tmp = new StringBuilder("ServletMetaData(id=");
/* 152 */     tmp.append(getId());
/* 153 */     tmp.append(",servletClass=");
/* 154 */     tmp.append(this.servletClass);
/* 155 */     tmp.append(",jspFile=");
/* 156 */     tmp.append(this.jspFile);
/* 157 */     tmp.append(",loadOnStartup=");
/* 158 */     tmp.append(this.loadOnStartup);
/* 159 */     tmp.append(",runAs=");
/* 160 */     tmp.append(this.runAs);
/* 161 */     tmp.append(')');
/* 162 */     return tmp.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.web.spec.ServletMetaData
 * JD-Core Version:    0.6.0
 */