/*     */ package org.jboss.metadata.spi.stack;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ 
/*     */ public final class MetaDataStack
/*     */ {
/*  38 */   private static ThreadLocal<ArrayList<MetaData>> stack = new ThreadLocal()
/*     */   {
/*     */     protected ArrayList<MetaData> initialValue()
/*     */     {
/*  42 */       return new ArrayList();
/*     */     }
/*  38 */   };
/*     */ 
/*     */   public static void push(MetaData metaData)
/*     */   {
/*  58 */     SecurityManager sm = System.getSecurityManager();
/*  59 */     if (sm != null) {
/*  60 */       sm.checkPermission(MetaDataStackPermission.MODIFY);
/*     */     }
/*  62 */     ((ArrayList)stack.get()).add(metaData);
/*     */   }
/*     */ 
/*     */   public static void pop()
/*     */   {
/*  76 */     ArrayList list = (ArrayList)stack.get();
/*  77 */     if (list.size() == 0) {
/*  78 */       throw new IllegalArgumentException("Empty stack");
/*     */     }
/*  80 */     list.remove(list.size() - 1);
/*     */   }
/*     */ 
/*     */   public static MetaData peek()
/*     */   {
/*  97 */     ArrayList list = (ArrayList)stack.get();
/*  98 */     if (list.size() == 0)
/*  99 */       return null;
/* 100 */     return (MetaData)list.get(list.size() - 1);
/*     */   }
/*     */ 
/*     */   public static void mask()
/*     */   {
/* 114 */     ((ArrayList)stack.get()).add(null);
/*     */   }
/*     */ 
/*     */   public static void unmask()
/*     */   {
/* 122 */     pop();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.spi.stack.MetaDataStack
 * JD-Core Version:    0.6.0
 */