/*     */ package org.jboss.metadata.spi.signature;
/*     */ 
/*     */ import java.lang.reflect.Array;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Member;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Arrays;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.reflect.spi.ConstructorInfo;
/*     */ import org.jboss.reflect.spi.FieldInfo;
/*     */ import org.jboss.reflect.spi.MemberInfo;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ 
/*     */ public class Signature
/*     */ {
/*     */   public static final String NO_NAME = "?%NO_NAME%?";
/*  51 */   public static final String[] NO_PARAMETERS = new String[0];
/*     */ 
/*  54 */   public static final Class<?>[] NO_PARAMETER_TYPES = new Class[0];
/*     */   private String name;
/*     */   private String[] parameters;
/*     */   private Class<?>[] parameterTypes;
/*  66 */   private transient int cachedHashCode = -2147483648;
/*     */ 
/*  69 */   private static final Map<String, Class<?>> primitiveTypes = new HashMap();
/*  70 */   private static final Map<String, String> primitiveArrayTypes = new HashMap();
/*  71 */   private static final Map<String, Class<?>> primitiveArrayTypesClassMap = new HashMap();
/*     */ 
/*     */   public static Signature getSignature(Member member)
/*     */   {
/* 111 */     if (member == null) {
/* 112 */       throw new IllegalArgumentException("Null member");
/*     */     }
/* 114 */     if ((member instanceof Method))
/*     */     {
/* 116 */       Method method = (Method)Method.class.cast(member);
/* 117 */       return new MethodSignature(method);
/*     */     }
/* 119 */     if ((member instanceof Field))
/*     */     {
/* 121 */       Field field = (Field)Field.class.cast(member);
/* 122 */       return new FieldSignature(field);
/*     */     }
/* 124 */     if ((member instanceof Constructor))
/*     */     {
/* 126 */       Constructor constructor = (Constructor)Constructor.class.cast(member);
/* 127 */       return new ConstructorSignature(constructor);
/*     */     }
/* 129 */     throw new IllegalArgumentException("Unknown member: " + member);
/*     */   }
/*     */ 
/*     */   public static Signature getSignature(MemberInfo member)
/*     */   {
/* 140 */     if (member == null) {
/* 141 */       throw new IllegalArgumentException("Null member");
/*     */     }
/* 143 */     if ((member instanceof MethodInfo))
/*     */     {
/* 145 */       MethodInfo method = (MethodInfo)MethodInfo.class.cast(member);
/* 146 */       return new MethodSignature(method);
/*     */     }
/* 148 */     if ((member instanceof FieldInfo))
/*     */     {
/* 150 */       FieldInfo field = (FieldInfo)FieldInfo.class.cast(member);
/* 151 */       return new FieldSignature(field);
/*     */     }
/* 153 */     if ((member instanceof ConstructorInfo))
/*     */     {
/* 155 */       ConstructorInfo constructor = (ConstructorInfo)ConstructorInfo.class.cast(member);
/* 156 */       return new ConstructorSignature(constructor);
/*     */     }
/* 158 */     throw new IllegalArgumentException("Unknown member: " + member);
/*     */   }
/*     */ 
/*     */   public static String getPrimativeArrayType(String name)
/*     */   {
/* 163 */     return (String)primitiveArrayTypes.get(name);
/*     */   }
/*     */ 
/*     */   public static String[] convertParameters(TypeInfo[] typeInfos)
/*     */   {
/* 168 */     if ((typeInfos == null) || (typeInfos.length == 0)) {
/* 169 */       return NO_PARAMETERS;
/*     */     }
/* 171 */     String[] paramTypes = new String[typeInfos.length];
/* 172 */     for (int i = 0; i < typeInfos.length; i++)
/* 173 */       paramTypes[i] = typeInfos[i].getName();
/* 174 */     return paramTypes;
/*     */   }
/*     */ 
/*     */   public static Class<?>[] convertParameterTypes(TypeInfo[] typeInfos)
/*     */   {
/* 179 */     if ((typeInfos == null) || (typeInfos.length == 0)) {
/* 180 */       return NO_PARAMETER_TYPES;
/*     */     }
/* 182 */     Class[] paramTypes = new Class[typeInfos.length];
/* 183 */     for (int i = 0; i < typeInfos.length; i++)
/* 184 */       paramTypes[i] = typeInfos[i].getType();
/* 185 */     return paramTypes;
/*     */   }
/*     */ 
/*     */   private static String[] classesToStrings(Class<?>[] parameters)
/*     */   {
/* 196 */     if ((parameters == null) || (parameters.length == 0)) {
/* 197 */       return NO_PARAMETERS;
/*     */     }
/* 199 */     String[] result = new String[parameters.length];
/* 200 */     for (int i = 0; i < result.length; i++)
/*     */     {
/* 202 */       if (parameters[i] == null)
/* 203 */         throw new IllegalArgumentException("Null class");
/* 204 */       result[i] = parameters[i].getName();
/*     */     }
/* 206 */     return result;
/*     */   }
/*     */ 
/*     */   private static Class<?>[] stringsToClasses(Class<?> clazz, String[] parameters)
/*     */   {
/* 218 */     if (clazz == null) {
/* 219 */       throw new IllegalArgumentException("Null clazz");
/*     */     }
/* 221 */     ClassLoader cl = clazz.getClassLoader();
/* 222 */     if (cl == null)
/*     */     {
/* 224 */       cl = Class.class.getClassLoader();
/* 225 */       if (cl == null)
/*     */       {
/* 228 */         cl = Thread.currentThread().getContextClassLoader();
/*     */       }
/*     */     }
/*     */ 
/* 232 */     return stringsToClasses(cl, parameters);
/*     */   }
/*     */ 
/*     */   private static Class<?> loadClass(ClassLoader cl, String name)
/*     */     throws ClassNotFoundException
/*     */   {
/* 242 */     Class primitive = (Class)primitiveTypes.get(name);
/* 243 */     if (primitive != null)
/*     */     {
/* 245 */       return primitive;
/*     */     }
/*     */ 
/* 248 */     int index = name.lastIndexOf('[');
/* 249 */     if (index >= 0)
/*     */     {
/* 252 */       int arrayDimension = 0;
/* 253 */       while (name.charAt(arrayDimension) == '[')
/* 254 */         arrayDimension++;
/*     */       Class componentType;
/*     */       Class componentType;
/* 256 */       if (name.charAt(arrayDimension) == 'L')
/*     */       {
/* 258 */         String arrayType = name.substring(arrayDimension + 1, name.length() - 1);
/* 259 */         componentType = loadClass(cl, arrayType);
/*     */       }
/*     */       else
/*     */       {
/* 263 */         String arrayType = name.substring(arrayDimension);
/* 264 */         componentType = (Class)primitiveArrayTypesClassMap.get(arrayType);
/*     */       }
/*     */ 
/* 268 */       return Array.newInstance(componentType, new int[arrayDimension]).getClass();
/*     */     }
/* 270 */     return Class.forName(name, true, cl);
/*     */   }
/*     */ 
/*     */   private static Class<?>[] stringsToClasses(ClassLoader cl, String[] parameters)
/*     */   {
/* 282 */     if (cl == null) {
/* 283 */       throw new IllegalArgumentException("Null classloader");
/*     */     }
/* 285 */     if ((parameters == null) || (parameters.length == 0)) {
/* 286 */       return NO_PARAMETER_TYPES;
/*     */     }
/* 288 */     Class[] result = new Class[parameters.length];
/* 289 */     for (int i = 0; i < result.length; i++)
/*     */     {
/*     */       try
/*     */       {
/* 293 */         result[i] = loadClass(cl, parameters[i]);
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/* 297 */         throw new IllegalStateException("Class not found: " + parameters[i], e);
/*     */       }
/*     */     }
/* 300 */     return result;
/*     */   }
/*     */ 
/*     */   public Signature()
/*     */   {
/* 308 */     this("?%NO_NAME%?", NO_PARAMETER_TYPES, NO_PARAMETERS);
/*     */   }
/*     */ 
/*     */   public Signature(String name)
/*     */   {
/* 318 */     this(name, null, NO_PARAMETERS);
/*     */   }
/*     */ 
/*     */   public Signature(String[] parameters)
/*     */   {
/* 328 */     this("?%NO_NAME%?", null, parameters);
/*     */   }
/*     */ 
/*     */   public Signature(Class<?>[] parameters)
/*     */   {
/* 338 */     this("?%NO_NAME%?", parameters, null);
/*     */   }
/*     */ 
/*     */   public Signature(String name, Class<?>[] parameters)
/*     */   {
/* 349 */     this(name, parameters, null);
/*     */   }
/*     */ 
/*     */   public Signature(String name, String[] parameters)
/*     */   {
/* 360 */     this(name, null, parameters);
/*     */   }
/*     */ 
/*     */   private Signature(String name, Class<?>[] parameterTypes, String[] parameters)
/*     */   {
/* 372 */     this.name = name;
/* 373 */     this.parameters = parameters;
/* 374 */     this.parameterTypes = parameterTypes;
/* 375 */     if (name == null)
/* 376 */       this.name = "?%NO_NAME%?";
/* 377 */     if (parameters == null)
/* 378 */       this.parameters = classesToStrings(parameterTypes);
/* 379 */     for (int i = 0; i < this.parameters.length; i++)
/*     */     {
/* 381 */       if (this.parameters[i] == null)
/* 382 */         throw new IllegalArgumentException("Null parameter");
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 393 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String[] getParameters()
/*     */   {
/* 403 */     return this.parameters;
/*     */   }
/*     */ 
/*     */   public Class<?>[] getParametersTypes(Class<?> clazz)
/*     */   {
/* 414 */     if (this.parameterTypes == null)
/* 415 */       return stringsToClasses(clazz, this.parameters);
/* 416 */     return this.parameterTypes;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 421 */     if (obj == this)
/* 422 */       return true;
/* 423 */     if ((obj == null) || (!(obj instanceof Signature))) {
/* 424 */       return false;
/*     */     }
/* 426 */     Signature other = (Signature)obj;
/*     */ 
/* 428 */     if (!getName().equals(other.getName())) {
/* 429 */       return false;
/*     */     }
/* 431 */     if (this.parameters.length != other.parameters.length) {
/* 432 */       return false;
/*     */     }
/* 434 */     for (int i = 0; i < this.parameters.length; i++)
/*     */     {
/* 436 */       if (!this.parameters[i].equals(other.parameters[i]))
/* 437 */         return false;
/*     */     }
/* 439 */     return true;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 444 */     if (this.cachedHashCode == -2147483648)
/* 445 */       this.cachedHashCode = toString().hashCode();
/* 446 */     return this.cachedHashCode;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 451 */     StringBuilder builder = new StringBuilder();
/* 452 */     internalToString(builder);
/* 453 */     return builder.toString();
/*     */   }
/*     */ 
/*     */   protected void internalToString(StringBuilder builder)
/*     */   {
/* 463 */     if (this.name != null)
/* 464 */       builder.append(this.name);
/* 465 */     if (this.parameters != null)
/* 466 */       builder.append(Arrays.asList(this.parameters));
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  75 */     primitiveTypes.put(Byte.TYPE.getName(), Byte.TYPE);
/*  76 */     primitiveTypes.put(Boolean.TYPE.getName(), Boolean.TYPE);
/*  77 */     primitiveTypes.put(Character.TYPE.getName(), Character.TYPE);
/*  78 */     primitiveTypes.put(Double.TYPE.getName(), Double.TYPE);
/*  79 */     primitiveTypes.put(Float.TYPE.getName(), Float.TYPE);
/*  80 */     primitiveTypes.put(Integer.TYPE.getName(), Integer.TYPE);
/*  81 */     primitiveTypes.put(Long.TYPE.getName(), Long.TYPE);
/*  82 */     primitiveTypes.put(Short.TYPE.getName(), Short.TYPE);
/*     */ 
/*  84 */     primitiveArrayTypes.put(Byte.TYPE.getName(), "B");
/*  85 */     primitiveArrayTypes.put(Boolean.TYPE.getName(), "Z");
/*  86 */     primitiveArrayTypes.put(Character.TYPE.getName(), "C");
/*  87 */     primitiveArrayTypes.put(Double.TYPE.getName(), "D");
/*  88 */     primitiveArrayTypes.put(Float.TYPE.getName(), "F");
/*  89 */     primitiveArrayTypes.put(Integer.TYPE.getName(), "I");
/*  90 */     primitiveArrayTypes.put(Long.TYPE.getName(), "J");
/*  91 */     primitiveArrayTypes.put(Short.TYPE.getName(), "S");
/*     */ 
/*  93 */     primitiveArrayTypesClassMap.put("B", Byte.TYPE);
/*  94 */     primitiveArrayTypesClassMap.put("Z", Boolean.TYPE);
/*  95 */     primitiveArrayTypesClassMap.put("C", Character.TYPE);
/*  96 */     primitiveArrayTypesClassMap.put("D", Double.TYPE);
/*  97 */     primitiveArrayTypesClassMap.put("F", Float.TYPE);
/*  98 */     primitiveArrayTypesClassMap.put("I", Integer.TYPE);
/*  99 */     primitiveArrayTypesClassMap.put("J", Long.TYPE);
/* 100 */     primitiveArrayTypesClassMap.put("S", Short.TYPE);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.spi.signature.Signature
 * JD-Core Version:    0.6.0
 */