/*    */ package org.jboss.metadata.spi.retrieval.helper;
/*    */ 
/*    */ import java.lang.annotation.Annotation;
/*    */ import org.jboss.metadata.spi.retrieval.AnnotationItem;
/*    */ import org.jboss.metadata.spi.retrieval.MetaDataItem;
/*    */ 
/*    */ public class MetaDataToAnnotationBridge<T extends Annotation>
/*    */   implements AnnotationItem<T>
/*    */ {
/*    */   private MetaDataItem metaData;
/*    */ 
/*    */   public MetaDataToAnnotationBridge(MetaDataItem metaData)
/*    */   {
/* 48 */     if (metaData == null)
/* 49 */       throw new IllegalArgumentException("Null metaData");
/* 50 */     this.metaData = metaData;
/*    */   }
/*    */ 
/*    */   public boolean isCachable()
/*    */   {
/* 55 */     return this.metaData.isCachable();
/*    */   }
/*    */ 
/*    */   public boolean isValid()
/*    */   {
/* 60 */     return this.metaData.isValid();
/*    */   }
/*    */ 
/*    */   public T getValue()
/*    */   {
/* 66 */     return (Annotation)this.metaData.getValue();
/*    */   }
/*    */ 
/*    */   public T getAnnotation()
/*    */   {
/* 71 */     return getValue();
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 76 */     return getValue().annotationType().getName();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.spi.retrieval.helper.MetaDataToAnnotationBridge
 * JD-Core Version:    0.6.0
 */