/*     */ package org.jboss.metadata.spi.retrieval.cummulative;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import org.jboss.metadata.spi.context.MetaDataContext;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataItem;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDatasItem;
/*     */ import org.jboss.metadata.spi.retrieval.ValidTime;
/*     */ import org.jboss.metadata.spi.retrieval.simple.SimpleMetaDatasItem;
/*     */ 
/*     */ public class CummulativeMetaDatasItem extends SimpleMetaDatasItem
/*     */ {
/*     */   private MetaDataContext context;
/*     */   private boolean includeParent;
/*     */   private long validTime;
/*     */ 
/*     */   public CummulativeMetaDatasItem(MetaDataContext context, boolean includeParent)
/*     */   {
/*  59 */     if (context == null) {
/*  60 */       throw new IllegalArgumentException("Null context");
/*     */     }
/*  62 */     this.context = context;
/*  63 */     this.includeParent = includeParent;
/*  64 */     init(context.getValidTime().getValidTime());
/*     */   }
/*     */ 
/*     */   public Object[] getValue()
/*     */   {
/*  69 */     checkValid();
/*  70 */     return super.getValue();
/*     */   }
/*     */ 
/*     */   public MetaDataItem[] getMetaDatas()
/*     */   {
/*  75 */     checkValid();
/*  76 */     return super.getMetaDatas();
/*     */   }
/*     */ 
/*     */   public boolean isCachable()
/*     */   {
/*  81 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isValid()
/*     */   {
/*  86 */     return true;
/*     */   }
/*     */ 
/*     */   protected void checkValid()
/*     */   {
/*  94 */     MetaDataItem[] items = super.getMetaDatas();
/*  95 */     boolean valid = items != null;
/*     */ 
/*  97 */     long newValidTime = this.context.getValidTime().getValidTime();
/*  98 */     if (this.validTime < newValidTime) {
/*  99 */       valid = false;
/*     */     }
/* 101 */     if (items != null)
/*     */     {
/* 103 */       for (MetaDataItem item : items)
/*     */       {
/* 105 */         if (!item.isValid()) {
/* 106 */           valid = false;
/*     */         }
/*     */       }
/*     */     }
/* 110 */     if (!valid)
/* 111 */       init(newValidTime);
/*     */   }
/*     */ 
/*     */   protected void init(long validTime)
/*     */   {
/* 121 */     Set temp = null;
/*     */     List retrievals;
/*     */     List retrievals;
/* 125 */     if (this.includeParent)
/* 126 */       retrievals = this.context.getRetrievals();
/*     */     else {
/* 128 */       retrievals = this.context.getLocalRetrievals();
/*     */     }
/* 130 */     for (MetaDataRetrieval retrieval : retrievals)
/*     */     {
/* 132 */       MetaDatasItem item = retrieval.retrieveMetaData();
/* 133 */       if (item != null)
/*     */       {
/* 135 */         MetaDataItem[] items = item.getMetaDatas();
/* 136 */         for (MetaDataItem it : items)
/*     */         {
/* 138 */           if (temp == null)
/* 139 */             temp = new HashSet();
/* 140 */           temp.add(it);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 145 */     MetaDataItem[] items = NO_META_DATA_ITEMS;
/* 146 */     if (temp != null)
/* 147 */       items = (MetaDataItem[])temp.toArray(new MetaDataItem[temp.size()]);
/* 148 */     setMetaDataItems(items);
/* 149 */     this.validTime = validTime;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.spi.retrieval.cummulative.CummulativeMetaDatasItem
 * JD-Core Version:    0.6.0
 */