/*     */ package org.jboss.metadata.spi.retrieval.basic;
/*     */ 
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ import org.jboss.metadata.spi.loader.MetaDataLoader;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataItem;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDatasItem;
/*     */ 
/*     */ public class BasicMetaDatasItem extends BasicItem<Object[]>
/*     */   implements MetaDatasItem
/*     */ {
/*     */   private MetaDataItem[] metaDataItems;
/*     */   private Object[] metaDatas;
/*     */ 
/*     */   public BasicMetaDatasItem(MetaDataLoader loader, MetaDataItem[] metaDataItems)
/*     */   {
/*  51 */     super(loader);
/*     */ 
/*  53 */     if (metaDataItems == null) {
/*  54 */       throw new IllegalArgumentException("Null metaDataItems");
/*     */     }
/*  56 */     this.metaDataItems = metaDataItems;
/*     */ 
/*  58 */     if (metaDataItems.length == 0)
/*  59 */       this.metaDatas = MetaData.NO_METADATA;
/*     */   }
/*     */ 
/*     */   public Object[] getValue()
/*     */   {
/*  64 */     if (this.metaDatas == null)
/*     */     {
/*  66 */       Object[] temp = new Object[this.metaDataItems.length];
/*  67 */       for (int i = 0; i < temp.length; i++)
/*  68 */         temp[i] = this.metaDataItems[i].getValue();
/*  69 */       this.metaDatas = temp;
/*     */     }
/*  71 */     return this.metaDatas;
/*     */   }
/*     */ 
/*     */   public MetaDataItem[] getMetaDatas()
/*     */   {
/*  76 */     return this.metaDataItems;
/*     */   }
/*     */ 
/*     */   public boolean isCachable()
/*     */   {
/*  81 */     if (!super.isCachable()) {
/*  82 */       return false;
/*     */     }
/*  84 */     for (MetaDataItem item : this.metaDataItems)
/*     */     {
/*  86 */       if (!item.isCachable()) {
/*  87 */         return false;
/*     */       }
/*     */     }
/*  90 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isValid()
/*     */   {
/*  95 */     if (!super.isValid()) {
/*  96 */       return false;
/*     */     }
/*  98 */     for (MetaDataItem item : this.metaDataItems)
/*     */     {
/* 100 */       if (!item.isValid()) {
/* 101 */         return false;
/*     */       }
/*     */     }
/* 104 */     return true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.spi.retrieval.basic.BasicMetaDatasItem
 * JD-Core Version:    0.6.0
 */