/*     */ package org.jboss.metadata.spi.retrieval;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ import org.jboss.metadata.spi.scope.ScopeLevel;
/*     */ import org.jboss.metadata.spi.signature.Signature;
/*     */ 
/*     */ public class MetaDataRetrievalToMetaDataBridge
/*     */   implements MetaData
/*     */ {
/*     */   private MetaDataRetrieval retrieval;
/*     */ 
/*     */   public MetaDataRetrievalToMetaDataBridge(MetaDataRetrieval retrieval)
/*     */   {
/*  48 */     if (retrieval == null)
/*  49 */       throw new IllegalArgumentException("Null retrieval");
/*  50 */     this.retrieval = retrieval;
/*     */   }
/*     */ 
/*     */   public long getValidTime()
/*     */   {
/*  55 */     ValidTime validTime = this.retrieval.getValidTime();
/*  56 */     return validTime.getValidTime();
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T getAnnotation(Class<T> annotationType)
/*     */   {
/*  61 */     if (annotationType == null)
/*  62 */       throw new IllegalArgumentException("Null annotationType");
/*  63 */     AnnotationItem item = this.retrieval.retrieveAnnotation(annotationType);
/*  64 */     if (item == null)
/*  65 */       return null;
/*  66 */     return (Annotation)item.getValue();
/*     */   }
/*     */ 
/*     */   public Annotation[] getAnnotations()
/*     */   {
/*  71 */     AnnotationsItem item = this.retrieval.retrieveAnnotations();
/*  72 */     if (item == null)
/*  73 */       return NO_ANNOTATIONS;
/*  74 */     return (Annotation[])item.getValue();
/*     */   }
/*     */ 
/*     */   public Annotation[] getLocalAnnotations()
/*     */   {
/*  79 */     AnnotationsItem item = this.retrieval.retrieveLocalAnnotations();
/*  80 */     if (item == null)
/*  81 */       return NO_ANNOTATIONS;
/*  82 */     return (Annotation[])item.getValue();
/*     */   }
/*     */ 
/*     */   public Object[] getMetaData()
/*     */   {
/*  87 */     MetaDatasItem item = this.retrieval.retrieveMetaData();
/*  88 */     if (item == null)
/*  89 */       return NO_METADATA;
/*  90 */     return (Object[])item.getValue();
/*     */   }
/*     */ 
/*     */   public Object[] getLocalMetaData()
/*     */   {
/*  95 */     MetaDatasItem item = this.retrieval.retrieveLocalMetaData();
/*  96 */     if (item == null)
/*  97 */       return NO_METADATA;
/*  98 */     return (Object[])item.getValue();
/*     */   }
/*     */ 
/*     */   public <T> T getMetaData(Class<T> type)
/*     */   {
/* 103 */     if (type == null)
/* 104 */       throw new IllegalArgumentException("Null type");
/* 105 */     MetaDataItem item = this.retrieval.retrieveMetaData(type);
/* 106 */     if (item == null)
/* 107 */       return null;
/* 108 */     return item.getValue();
/*     */   }
/*     */ 
/*     */   public <T> T getMetaData(String name, Class<T> type)
/*     */   {
/* 113 */     if (name == null)
/* 114 */       throw new IllegalArgumentException("Null name");
/* 115 */     if (type == null)
/* 116 */       throw new IllegalArgumentException("Null type");
/* 117 */     MetaDataItem item = this.retrieval.retrieveMetaData(name);
/* 118 */     if (item == null)
/* 119 */       return null;
/* 120 */     return type.cast(item.getValue());
/*     */   }
/*     */ 
/*     */   public Object getMetaData(String name)
/*     */   {
/* 125 */     if (name == null)
/* 126 */       throw new IllegalArgumentException("Null name");
/* 127 */     MetaDataItem item = this.retrieval.retrieveMetaData(name);
/* 128 */     if (item == null)
/* 129 */       return null;
/* 130 */     return item.getValue();
/*     */   }
/*     */ 
/*     */   public boolean isAnnotationPresent(Class<? extends Annotation> annotationType)
/*     */   {
/* 135 */     return getAnnotation(annotationType) != null;
/*     */   }
/*     */ 
/*     */   public boolean isMetaDataPresent(Class<?> type)
/*     */   {
/* 140 */     return getMetaData(type) != null;
/*     */   }
/*     */ 
/*     */   public boolean isMetaDataPresent(String name, Class<?> type)
/*     */   {
/* 145 */     if (type == null)
/* 146 */       throw new IllegalArgumentException("Null type");
/* 147 */     Object value = getMetaData(name);
/* 148 */     if (value == null)
/* 149 */       return false;
/* 150 */     return type.isInstance(value);
/*     */   }
/*     */ 
/*     */   public boolean isMetaDataPresent(String name)
/*     */   {
/* 155 */     return getMetaData(name) != null;
/*     */   }
/*     */ 
/*     */   public MetaData getComponentMetaData(Signature signature)
/*     */   {
/* 160 */     MetaDataRetrieval component = this.retrieval.getComponentMetaDataRetrieval(signature);
/* 161 */     if (component == null)
/* 162 */       return null;
/* 163 */     return new MetaDataRetrievalToMetaDataBridge(component);
/*     */   }
/*     */ 
/*     */   public MetaData getScopeMetaData(ScopeLevel level)
/*     */   {
/* 168 */     if (level == null) {
/* 169 */       throw new IllegalArgumentException("Null scope level");
/*     */     }
/* 171 */     MetaDataRetrieval scopedRetrieval = this.retrieval.getScopedRetrieval(level);
/* 172 */     if (scopedRetrieval != null) {
/* 173 */       return new MetaDataRetrievalToMetaDataBridge(scopedRetrieval);
/*     */     }
/* 175 */     return null;
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 180 */     return this.retrieval.isEmpty();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 185 */     if (obj == this)
/* 186 */       return true;
/* 187 */     if ((obj == null) || (!(obj instanceof MetaDataRetrievalToMetaDataBridge))) {
/* 188 */       return false;
/*     */     }
/* 190 */     MetaDataRetrievalToMetaDataBridge other = (MetaDataRetrievalToMetaDataBridge)obj;
/* 191 */     return this.retrieval.equals(other.retrieval);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 196 */     return this.retrieval.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 201 */     return super.toString() + "{" + this.retrieval.getScope() + "}";
/*     */   }
/*     */ 
/*     */   protected MetaDataRetrieval getMetaDataRetrieval()
/*     */   {
/* 211 */     return this.retrieval;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.spi.retrieval.MetaDataRetrievalToMetaDataBridge
 * JD-Core Version:    0.6.0
 */