/*     */ package org.jboss.metadata.plugins.repository.visitor;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.metadata.spi.repository.MetaDataRepository;
/*     */ import org.jboss.metadata.spi.repository.visitor.MetaDataRepositoryVisitor;
/*     */ import org.jboss.metadata.spi.scope.Scope;
/*     */ import org.jboss.metadata.spi.scope.ScopeKey;
/*     */ import org.jboss.metadata.spi.scope.ScopeLevel;
/*     */ 
/*     */ public class FuzzyMetaDataRepositoryVisitor
/*     */   implements MetaDataRepositoryVisitor
/*     */ {
/*     */   private Scope[] matchScopes;
/*     */ 
/*     */   public FuzzyMetaDataRepositoryVisitor(ScopeKey matchKey)
/*     */   {
/*  51 */     if (matchKey != null)
/*     */     {
/*  53 */       Collection testScopes = matchKey.getScopes();
/*  54 */       this.matchScopes = ((Scope[])testScopes.toArray(new Scope[testScopes.size()]));
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean matchScope(MetaDataRepository repository, ScopeKey key)
/*     */   {
/*  60 */     if ((this.matchScopes == null) || (this.matchScopes.length == 0)) {
/*  61 */       return true;
/*     */     }
/*  63 */     boolean match = false;
/*  64 */     int index = 0;
/*  65 */     Iterator i = key.getScopes().iterator();
/*  66 */     Scope repositoryScope = (Scope)i.next();
/*  67 */     Scope matchScope = this.matchScopes[index];
/*     */     while (true)
/*     */     {
/*  70 */       ScopeLevel keyLevel = matchScope.getScopeLevel();
/*  71 */       ScopeLevel repositoryLevel = repositoryScope.getScopeLevel();
/*     */ 
/*  74 */       if (keyLevel.compareTo(repositoryLevel) == 0)
/*     */       {
/*  76 */         if (matchScope.equals(repositoryScope)) {
/*  77 */           match = true;
/*     */         }
/*     */         else
/*     */         {
/*  81 */           match = false;
/*  82 */           break;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*  87 */       if (keyLevel.compareTo(repositoryLevel) <= 0)
/*     */       {
/*  90 */         index++; if (index == this.matchScopes.length)
/*     */           break;
/*  92 */         matchScope = this.matchScopes[index];
/*     */       }
/*     */       else
/*     */       {
/*  97 */         if (!i.hasNext())
/*     */           break;
/*  99 */         repositoryScope = (Scope)i.next();
/*     */       }
/*     */     }
/* 102 */     return match;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.plugins.repository.visitor.FuzzyMetaDataRepositoryVisitor
 * JD-Core Version:    0.6.0
 */