/*     */ package org.jboss.metadata.plugins.repository.basic;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.jboss.metadata.plugins.loader.reflection.ClassMetaDataRetrievalFactory;
/*     */ import org.jboss.metadata.plugins.repository.AbstractMetaDataRepository;
/*     */ import org.jboss.metadata.plugins.repository.visitor.ChildrenMetaDataRepositoryVisitor;
/*     */ import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
/*     */ import org.jboss.metadata.spi.repository.visitor.MetaDataRepositoryVisitor;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataRetrievalFactory;
/*     */ import org.jboss.metadata.spi.scope.CommonLevels;
/*     */ import org.jboss.metadata.spi.scope.Scope;
/*     */ import org.jboss.metadata.spi.scope.ScopeKey;
/*     */ import org.jboss.metadata.spi.scope.ScopeLevel;
/*     */ 
/*     */ public class BasicMetaDataRepository extends AbstractMetaDataRepository
/*     */   implements MutableMetaDataRepository
/*     */ {
/*  51 */   private Map<ScopeKey, MetaDataRetrieval> retrievals = new ConcurrentHashMap();
/*     */ 
/*  54 */   private Map<ScopeLevel, MetaDataRetrievalFactory> factories = new ConcurrentHashMap();
/*     */ 
/*     */   public BasicMetaDataRepository()
/*     */   {
/*  62 */     addMetaDataRetrievalFactory(CommonLevels.CLASS, ClassMetaDataRetrievalFactory.INSTANCE);
/*     */   }
/*     */ 
/*     */   public MetaDataRetrieval getMetaDataRetrieval(ScopeKey key)
/*     */   {
/*  67 */     MetaDataRetrieval result = (MetaDataRetrieval)this.retrievals.get(key);
/*  68 */     if (result != null) {
/*  69 */       return result;
/*     */     }
/*     */ 
/*  72 */     Collection scopes = key.getScopes();
/*  73 */     if (scopes.size() != 1) {
/*  74 */       return null;
/*     */     }
/*     */ 
/*  77 */     Scope scope = (Scope)scopes.iterator().next();
/*  78 */     ScopeLevel scopeLevel = scope.getScopeLevel();
/*  79 */     MetaDataRetrievalFactory factory = getMetaDataRetrievalFactory(scopeLevel);
/*  80 */     if (factory == null) {
/*  81 */       return null;
/*     */     }
/*     */ 
/*  84 */     return factory.getMetaDataRetrieval(scope);
/*     */   }
/*     */ 
/*     */   public Set<ScopeKey> getChildren(ScopeKey key)
/*     */   {
/*  89 */     if (key == null) {
/*  90 */       return this.retrievals.keySet();
/*     */     }
/*  92 */     ChildrenMetaDataRepositoryVisitor visitor = new ChildrenMetaDataRepositoryVisitor(key);
/*  93 */     return matchScopes(visitor);
/*     */   }
/*     */ 
/*     */   public Set<ScopeKey> matchScopes(MetaDataRepositoryVisitor visitor)
/*     */   {
/*  98 */     Set result = new HashSet();
/*  99 */     for (ScopeKey repositoryKey : this.retrievals.keySet())
/*     */     {
/* 101 */       if (visitor.matchScope(this, repositoryKey))
/* 102 */         result.add(repositoryKey);
/*     */     }
/* 104 */     return result;
/*     */   }
/*     */ 
/*     */   public MetaDataRetrieval addMetaDataRetrieval(MetaDataRetrieval retrieval)
/*     */   {
/* 109 */     if (retrieval == null)
/* 110 */       throw new IllegalArgumentException("Null retrieval");
/* 111 */     ScopeKey key = retrieval.getScope();
/* 112 */     key.freeze();
/* 113 */     return (MetaDataRetrieval)this.retrievals.put(key, retrieval);
/*     */   }
/*     */ 
/*     */   public MetaDataRetrieval removeMetaDataRetrieval(ScopeKey key)
/*     */   {
/* 118 */     if (key == null)
/* 119 */       throw new IllegalArgumentException("Null key");
/* 120 */     return (MetaDataRetrieval)this.retrievals.remove(key);
/*     */   }
/*     */ 
/*     */   public MetaDataRetrievalFactory addMetaDataRetrievalFactory(ScopeLevel level, MetaDataRetrievalFactory factory)
/*     */   {
/* 125 */     if (level == null)
/* 126 */       throw new IllegalArgumentException("Null level");
/* 127 */     if (factory == null)
/* 128 */       throw new IllegalArgumentException("Null factory");
/* 129 */     return (MetaDataRetrievalFactory)this.factories.put(level, factory);
/*     */   }
/*     */ 
/*     */   public MetaDataRetrievalFactory getMetaDataRetrievalFactory(ScopeLevel level)
/*     */   {
/* 134 */     if (level == null)
/* 135 */       throw new IllegalArgumentException("Null level");
/* 136 */     return (MetaDataRetrievalFactory)this.factories.get(level);
/*     */   }
/*     */ 
/*     */   public MetaDataRetrievalFactory removeMetaDataRetrievalFactory(ScopeLevel level)
/*     */   {
/* 141 */     if (level == null)
/* 142 */       throw new IllegalArgumentException("Null level");
/* 143 */     return (MetaDataRetrievalFactory)this.factories.remove(level);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.plugins.repository.basic.BasicMetaDataRepository
 * JD-Core Version:    0.6.0
 */