/*    */ package org.jboss.metadata.plugins.loader.reflection;
/*    */ 
/*    */ import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
/*    */ import org.jboss.metadata.spi.retrieval.MetaDataRetrievalFactory;
/*    */ import org.jboss.metadata.spi.scope.CommonLevels;
/*    */ import org.jboss.metadata.spi.scope.Scope;
/*    */ import org.jboss.metadata.spi.scope.ScopeLevel;
/*    */ 
/*    */ public class ClassMetaDataRetrievalFactory
/*    */   implements MetaDataRetrievalFactory
/*    */ {
/* 38 */   public static final ClassMetaDataRetrievalFactory INSTANCE = new ClassMetaDataRetrievalFactory();
/*    */ 
/*    */   public MetaDataRetrieval getMetaDataRetrieval(Scope scope)
/*    */   {
/* 42 */     if (scope == null)
/* 43 */       throw new IllegalArgumentException("Null scope");
/* 44 */     if (!CommonLevels.CLASS.equals(scope.getScopeLevel())) {
/* 45 */       throw new IllegalArgumentException("Not a class scope: " + scope);
/*    */     }
/*    */ 
/* 48 */     Object qualifier = scope.getQualifier();
/* 49 */     if (!(qualifier instanceof Class)) {
/* 50 */       return null;
/*    */     }
/* 52 */     Class clazz = (Class)Class.class.cast(qualifier);
/* 53 */     return new AnnotatedElementMetaDataLoader(clazz);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.plugins.loader.reflection.ClassMetaDataRetrievalFactory
 * JD-Core Version:    0.6.0
 */