/*     */ package org.jboss.metadata.plugins.loader.reflection;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.lang.reflect.AnnotatedElement;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Member;
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.metadata.plugins.loader.BasicMetaDataLoader;
/*     */ import org.jboss.metadata.plugins.loader.SimpleMetaDataLoader;
/*     */ import org.jboss.metadata.spi.retrieval.AnnotationItem;
/*     */ import org.jboss.metadata.spi.retrieval.AnnotationsItem;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
/*     */ import org.jboss.metadata.spi.retrieval.simple.SimpleAnnotationItem;
/*     */ import org.jboss.metadata.spi.retrieval.simple.SimpleAnnotationsItem;
/*     */ import org.jboss.metadata.spi.scope.CommonLevels;
/*     */ import org.jboss.metadata.spi.scope.Scope;
/*     */ import org.jboss.metadata.spi.scope.ScopeKey;
/*     */ import org.jboss.metadata.spi.signature.ConstructorSignature;
/*     */ import org.jboss.metadata.spi.signature.FieldSignature;
/*     */ import org.jboss.metadata.spi.signature.MethodParametersSignature;
/*     */ import org.jboss.metadata.spi.signature.MethodSignature;
/*     */ import org.jboss.metadata.spi.signature.Signature;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ import org.jboss.util.Strings;
/*     */ 
/*     */ public class AnnotatedElementMetaDataLoader extends BasicMetaDataLoader
/*     */ {
/*     */   private AnnotatedElement annotated;
/*     */ 
/*     */   private static final ScopeKey getScopeKey(AnnotatedElement annotated)
/*     */   {
/*     */     Scope scope;
/*  63 */     if ((annotated instanceof Class))
/*     */     {
/*  65 */       Class clazz = (Class)Class.class.cast(annotated);
/*  66 */       scope = new Scope(CommonLevels.CLASS, clazz);
/*     */     }
/*     */     else
/*     */     {
/*     */       Scope scope;
/*  68 */       if ((annotated instanceof Member))
/*     */       {
/*  70 */         Member member = (Member)annotated;
/*  71 */         scope = new Scope(CommonLevels.JOINPOINT, member);
/*     */       }
/*     */       else
/*     */       {
/*  75 */         return ScopeKey.DEFAULT_SCOPE;
/*     */       }
/*     */     }
/*     */     Scope scope;
/*  77 */     return new ScopeKey(scope);
/*     */   }
/*     */ 
/*     */   public AnnotatedElementMetaDataLoader(AnnotatedElement annotated)
/*     */   {
/*  87 */     super(getScopeKey(annotated));
/*  88 */     if (annotated == null)
/*  89 */       throw new IllegalArgumentException("Null annotated element");
/*  90 */     this.annotated = annotated;
/*     */   }
/*     */ 
/*     */   public AnnotationsItem retrieveAnnotations()
/*     */   {
/*  96 */     Annotation[] annotations = this.annotated.getAnnotations();
/*  97 */     if (annotations.length == 0) {
/*  98 */       return SimpleAnnotationsItem.NO_ANNOTATIONS;
/*     */     }
/* 100 */     AnnotationItem[] items = new AnnotationItem[annotations.length];
/* 101 */     for (int i = 0; i < items.length; i++)
/* 102 */       items[i] = new SimpleAnnotationItem(annotations[i]);
/* 103 */     return new SimpleAnnotationsItem(items);
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> AnnotationItem<T> retrieveAnnotation(Class<T> annotationType)
/*     */   {
/* 108 */     Annotation annotation = this.annotated.getAnnotation(annotationType);
/* 109 */     if (annotation == null)
/* 110 */       return null;
/* 111 */     return new SimpleAnnotationItem(annotation);
/*     */   }
/*     */ 
/*     */   public MetaDataRetrieval getComponentMetaDataRetrieval(Signature signature)
/*     */   {
/* 116 */     if (signature == null) {
/* 117 */       return null;
/*     */     }
/* 119 */     if ((this.annotated instanceof Class))
/*     */     {
/* 121 */       Class clazz = (Class)Class.class.cast(this.annotated);
/* 122 */       if ((signature instanceof ConstructorSignature))
/*     */       {
/*     */         try
/*     */         {
/* 126 */           Constructor constructor = clazz.getConstructor(signature.getParametersTypes(clazz));
/* 127 */           return new AnnotatedElementMetaDataLoader(constructor);
/*     */         }
/*     */         catch (NoSuchMethodException e)
/*     */         {
/* 131 */           return null;
/*     */         }
/*     */       }
/* 134 */       if ((signature instanceof MethodSignature))
/*     */       {
/*     */         try
/*     */         {
/* 138 */           Method method = clazz.getMethod(signature.getName(), signature.getParametersTypes(clazz));
/* 139 */           return new AnnotatedElementMetaDataLoader(method);
/*     */         }
/*     */         catch (NoSuchMethodException e)
/*     */         {
/* 143 */           return null;
/*     */         }
/*     */       }
/* 146 */       if ((signature instanceof MethodParametersSignature))
/*     */       {
/*     */         try
/*     */         {
/* 150 */           Method method = clazz.getMethod(signature.getName(), signature.getParametersTypes(clazz));
/* 151 */           Annotation[][] paramAnnotations = method.getParameterAnnotations();
/* 152 */           MethodParametersSignature sig = (MethodParametersSignature)signature;
/* 153 */           return new SimpleMetaDataLoader(paramAnnotations[sig.getParam()]);
/*     */         }
/*     */         catch (NoSuchMethodException e)
/*     */         {
/* 157 */           return null;
/*     */         }
/*     */       }
/* 160 */       if ((signature instanceof FieldSignature))
/*     */       {
/*     */         try
/*     */         {
/* 164 */           Field field = clazz.getField(signature.getName());
/* 165 */           return new AnnotatedElementMetaDataLoader(field);
/*     */         }
/*     */         catch (NoSuchFieldException e)
/*     */         {
/* 169 */           return null;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 174 */     if ((this.annotated instanceof Method))
/*     */     {
/* 176 */       if ((signature instanceof MethodParametersSignature))
/*     */       {
/* 178 */         Method method = (Method)this.annotated;
/* 179 */         Annotation[][] paramAnnotations = method.getParameterAnnotations();
/* 180 */         MethodParametersSignature sig = (MethodParametersSignature)signature;
/* 181 */         return new SimpleMetaDataLoader(paramAnnotations[sig.getParam()]);
/*     */       }
/*     */     }
/*     */ 
/* 185 */     if ((this.annotated instanceof Constructor))
/*     */     {
/* 187 */       if ((signature instanceof MethodParametersSignature))
/*     */       {
/* 189 */         Constructor constructor = (Constructor)Constructor.class.cast(this.annotated);
/* 190 */         Annotation[][] paramAnnotations = constructor.getParameterAnnotations();
/* 191 */         MethodParametersSignature sig = (MethodParametersSignature)signature;
/* 192 */         return new SimpleMetaDataLoader(paramAnnotations[sig.getParam()]);
/*     */       }
/*     */     }
/*     */ 
/* 196 */     return null;
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 201 */     Annotation[] annotations = this.annotated.getAnnotations();
/* 202 */     return (annotations == null) || (annotations.length == 0);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 207 */     JBossStringBuilder buffer = new JBossStringBuilder();
/* 208 */     Strings.defaultToString(buffer, this);
/* 209 */     buffer.append("[");
/* 210 */     buffer.append(this.annotated);
/* 211 */     buffer.append("]");
/* 212 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.plugins.loader.reflection.AnnotatedElementMetaDataLoader
 * JD-Core Version:    0.6.0
 */