/*     */ package org.jboss.metadata.plugins.loader.memory;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.jboss.metadata.plugins.loader.AbstractMutableComponentMetaDataLoader;
/*     */ import org.jboss.metadata.spi.retrieval.AnnotationItem;
/*     */ import org.jboss.metadata.spi.retrieval.AnnotationsItem;
/*     */ import org.jboss.metadata.spi.retrieval.Item;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataItem;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDatasItem;
/*     */ import org.jboss.metadata.spi.retrieval.basic.BasicAnnotationItem;
/*     */ import org.jboss.metadata.spi.retrieval.basic.BasicAnnotationsItem;
/*     */ import org.jboss.metadata.spi.retrieval.basic.BasicMetaDataItem;
/*     */ import org.jboss.metadata.spi.retrieval.basic.BasicMetaDatasItem;
/*     */ import org.jboss.metadata.spi.scope.ScopeKey;
/*     */ import org.jboss.metadata.spi.signature.Signature;
/*     */ 
/*     */ public class MemoryMetaDataLoader extends AbstractMutableComponentMetaDataLoader
/*     */ {
/*     */   private volatile Map<String, BasicAnnotationItem> annotations;
/*     */   private volatile Map<String, BasicMetaDataItem> metaDataByName;
/*     */   private volatile BasicAnnotationsItem cachedAnnotationsItem;
/*     */   private volatile BasicMetaDatasItem cachedMetaDatasItem;
/*     */   private final boolean cachable;
/*     */ 
/*     */   public MemoryMetaDataLoader()
/*     */   {
/*  72 */     this(true, false);
/*     */   }
/*     */ 
/*     */   public MemoryMetaDataLoader(boolean cachable, boolean restricted)
/*     */   {
/*  83 */     super(restricted);
/*  84 */     this.cachable = cachable;
/*     */   }
/*     */ 
/*     */   public MemoryMetaDataLoader(ScopeKey scope)
/*     */   {
/*  94 */     this(scope, true, false);
/*     */   }
/*     */ 
/*     */   public MemoryMetaDataLoader(ScopeKey scope, boolean cachable, boolean restricted)
/*     */   {
/* 106 */     super(scope, restricted);
/* 107 */     this.cachable = cachable;
/*     */   }
/*     */ 
/*     */   public <T> boolean isCachable(Item<T> item)
/*     */   {
/* 112 */     return this.cachable;
/*     */   }
/*     */ 
/*     */   public AnnotationsItem retrieveAnnotations()
/*     */   {
/* 117 */     BasicAnnotationsItem result = this.cachedAnnotationsItem;
/* 118 */     if ((result != null) && (result.isValid())) {
/* 119 */       return result;
/*     */     }
/* 121 */     Map temp = this.annotations;
/* 122 */     if (temp == null) {
/* 123 */       return noAnnotations();
/*     */     }
/* 125 */     Collection values = temp.values();
/* 126 */     if (values.isEmpty()) {
/* 127 */       return noAnnotations();
/*     */     }
/* 129 */     AnnotationItem[] items = (AnnotationItem[])values.toArray(new AnnotationItem[values.size()]);
/* 130 */     result = new BasicAnnotationsItem(this, items);
/* 131 */     this.cachedAnnotationsItem = result;
/* 132 */     return result;
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> AnnotationItem<T> retrieveAnnotation(Class<T> annotationType)
/*     */   {
/* 138 */     Map temp = this.annotations;
/* 139 */     if (temp == null)
/* 140 */       return null;
/* 141 */     return (AnnotationItem)temp.get(annotationType.getName());
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T addAnnotation(T annotation)
/*     */   {
/* 147 */     if (annotation == null)
/* 148 */       throw new IllegalArgumentException("Null annotation");
/* 149 */     checkRestricted(annotation);
/*     */ 
/* 151 */     synchronized (this)
/*     */     {
/* 153 */       if (this.annotations == null) {
/* 154 */         this.annotations = new ConcurrentHashMap();
/*     */       }
/*     */     }
/* 157 */     Annotation result = null;
/*     */ 
/* 159 */     Class annotationType = annotation.annotationType();
/* 160 */     BasicAnnotationItem old = (BasicAnnotationItem)this.annotations.get(annotationType.getName());
/* 161 */     if (old != null)
/*     */     {
/* 163 */       result = old.getAnnotation();
/* 164 */       if (result == annotation)
/* 165 */         return result;
/* 166 */       old.invalidate();
/*     */     }
/*     */ 
/* 169 */     BasicAnnotationItem item = new BasicAnnotationItem(this, annotation);
/* 170 */     this.annotations.put(annotationType.getName(), item);
/* 171 */     invalidateAnnotationsItem();
/* 172 */     invalidateMetaDatasItem();
/* 173 */     invalidate();
/* 174 */     return result;
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T removeAnnotation(Class<T> annotationType)
/*     */   {
/* 180 */     if (this.annotations == null)
/* 181 */       return null;
/* 182 */     BasicAnnotationItem annotation = (BasicAnnotationItem)this.annotations.remove(annotationType.getName());
/* 183 */     if (annotation == null)
/* 184 */       return null;
/* 185 */     annotation.invalidate();
/* 186 */     invalidateAnnotationsItem();
/* 187 */     invalidateMetaDatasItem();
/* 188 */     return annotation.getAnnotation();
/*     */   }
/*     */ 
/*     */   public MetaDatasItem retrieveMetaData()
/*     */   {
/* 193 */     BasicMetaDatasItem result = this.cachedMetaDatasItem;
/* 194 */     if ((result != null) && (result.isValid())) {
/* 195 */       return result;
/*     */     }
/* 197 */     Collection all = null;
/* 198 */     Map temp1 = this.annotations;
/* 199 */     if ((temp1 != null) && (temp1.size() > 0))
/*     */     {
/* 201 */       all = new ArrayList();
/* 202 */       Collection values = temp1.values();
/* 203 */       all.addAll(values);
/*     */     }
/* 205 */     Map temp2 = this.metaDataByName;
/* 206 */     if ((temp2 != null) && (temp2.size() > 0))
/*     */     {
/* 208 */       if (all == null)
/* 209 */         all = new ArrayList();
/* 210 */       Collection values = temp2.values();
/* 211 */       all.addAll(values);
/*     */     }
/*     */ 
/* 214 */     if (all == null) {
/* 215 */       return noMetaDatas();
/*     */     }
/* 217 */     MetaDataItem[] metaDataItems = (MetaDataItem[])all.toArray(new MetaDataItem[all.size()]);
/* 218 */     result = new BasicMetaDatasItem(this, metaDataItems);
/* 219 */     this.cachedMetaDatasItem = result;
/* 220 */     return result;
/*     */   }
/*     */ 
/*     */   public <T> MetaDataItem<T> retrieveMetaData(Class<T> type)
/*     */   {
/* 226 */     MetaDataItem result = super.retrieveMetaData(type);
/* 227 */     if (result != null) {
/* 228 */       return result;
/*     */     }
/* 230 */     Map temp = this.metaDataByName;
/* 231 */     if (temp == null)
/* 232 */       return null;
/* 233 */     return (MetaDataItem)temp.get(type.getName());
/*     */   }
/*     */ 
/*     */   public MetaDataItem retrieveMetaData(String name)
/*     */   {
/* 238 */     Map temp = this.metaDataByName;
/* 239 */     if (temp != null)
/*     */     {
/* 241 */       MetaDataItem result = (MetaDataItem)temp.get(name);
/* 242 */       if (result != null) {
/* 243 */         return result;
/*     */       }
/*     */     }
/* 246 */     Map temp2 = this.annotations;
/* 247 */     if (temp2 != null) {
/* 248 */       return (MetaDataItem)temp2.get(name);
/*     */     }
/* 250 */     return null;
/*     */   }
/*     */ 
/*     */   public <T> T addMetaData(T metaData, Class<T> type)
/*     */   {
/* 256 */     if (metaData == null)
/* 257 */       throw new IllegalArgumentException("Null metaData");
/* 258 */     if (type == null) {
/* 259 */       throw new IllegalArgumentException("Null type");
/*     */     }
/* 261 */     if ((metaData instanceof Annotation)) {
/* 262 */       return addAnnotation((Annotation)metaData);
/*     */     }
/* 264 */     checkRestricted(type);
/*     */ 
/* 266 */     synchronized (this)
/*     */     {
/* 268 */       if (this.metaDataByName == null) {
/* 269 */         this.metaDataByName = new ConcurrentHashMap();
/*     */       }
/*     */     }
/* 272 */     Object result = null;
/*     */ 
/* 274 */     BasicMetaDataItem old = (BasicMetaDataItem)this.metaDataByName.get(type.getName());
/* 275 */     if (old != null)
/*     */     {
/* 277 */       result = old.getValue();
/* 278 */       if (result == metaData)
/* 279 */         return result;
/* 280 */       old.invalidate();
/*     */     }
/* 282 */     BasicMetaDataItem item = new BasicMetaDataItem(this, type.getName(), metaData);
/* 283 */     this.metaDataByName.put(type.getName(), item);
/* 284 */     invalidateMetaDatasItem();
/* 285 */     invalidate();
/* 286 */     return result;
/*     */   }
/*     */ 
/*     */   public <T> T removeMetaData(Class<T> type)
/*     */   {
/* 292 */     if (type == null) {
/* 293 */       throw new IllegalArgumentException("Null type");
/*     */     }
/* 295 */     if (type.isAnnotation()) {
/* 296 */       return removeAnnotation(type);
/*     */     }
/* 298 */     if (this.metaDataByName == null) {
/* 299 */       return null;
/*     */     }
/* 301 */     BasicMetaDataItem result = (BasicMetaDataItem)this.metaDataByName.remove(type.getName());
/* 302 */     if (result == null)
/* 303 */       return null;
/* 304 */     result.invalidate();
/* 305 */     invalidateMetaDatasItem();
/* 306 */     return result.getValue();
/*     */   }
/*     */ 
/*     */   public <T> T addMetaData(String name, T metaData, Class<T> type)
/*     */   {
/* 312 */     if (name == null)
/* 313 */       throw new IllegalArgumentException("Null name");
/* 314 */     if (metaData == null)
/* 315 */       throw new IllegalArgumentException("Null metaData");
/* 316 */     if (type == null) {
/* 317 */       throw new IllegalArgumentException("Null type");
/*     */     }
/* 319 */     checkRestricted(type);
/*     */ 
/* 321 */     synchronized (this)
/*     */     {
/* 323 */       if (this.metaDataByName == null) {
/* 324 */         this.metaDataByName = new ConcurrentHashMap();
/*     */       }
/*     */     }
/* 327 */     Object result = null;
/*     */ 
/* 329 */     BasicMetaDataItem old = (BasicMetaDataItem)this.metaDataByName.get(name);
/* 330 */     if (old != null)
/*     */     {
/* 332 */       result = old.getValue();
/* 333 */       if (result == metaData)
/* 334 */         return result;
/* 335 */       old.invalidate();
/*     */     }
/* 337 */     BasicMetaDataItem item = new BasicMetaDataItem(this, name, metaData);
/* 338 */     this.metaDataByName.put(name, item);
/* 339 */     invalidateMetaDatasItem();
/* 340 */     invalidate();
/* 341 */     return result;
/*     */   }
/*     */ 
/*     */   public <T> T removeMetaData(String name, Class<T> type)
/*     */   {
/* 347 */     if (name == null) {
/* 348 */       throw new IllegalArgumentException("Null name");
/*     */     }
/* 350 */     Map temp = this.metaDataByName;
/* 351 */     if (temp == null) {
/* 352 */       return null;
/*     */     }
/* 354 */     BasicMetaDataItem result = (BasicMetaDataItem)temp.remove(name);
/* 355 */     if (result == null)
/* 356 */       return null;
/* 357 */     result.invalidate();
/* 358 */     invalidateMetaDatasItem();
/* 359 */     return result.getValue();
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 364 */     return (isNullOrEmpty(this.annotations)) && (isNullOrEmpty(this.metaDataByName)) && (super.isEmpty());
/*     */   }
/*     */ 
/*     */   protected void invalidateAnnotationsItem()
/*     */   {
/* 372 */     BasicAnnotationsItem temp = this.cachedAnnotationsItem;
/* 373 */     if (temp != null)
/*     */     {
/* 375 */       temp.invalidate();
/* 376 */       this.cachedAnnotationsItem = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected BasicAnnotationsItem noAnnotations()
/*     */   {
/* 387 */     BasicAnnotationsItem result = new BasicAnnotationsItem(this, BasicAnnotationsItem.NO_ANNOTATION_ITEMS);
/* 388 */     this.cachedAnnotationsItem = result;
/* 389 */     return result;
/*     */   }
/*     */ 
/*     */   protected void invalidateMetaDatasItem()
/*     */   {
/* 397 */     BasicMetaDatasItem temp = this.cachedMetaDatasItem;
/* 398 */     if (temp != null)
/*     */     {
/* 400 */       temp.invalidate();
/* 401 */       this.cachedMetaDatasItem = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected BasicMetaDatasItem noMetaDatas()
/*     */   {
/* 412 */     BasicMetaDatasItem result = new BasicMetaDatasItem(this, BasicMetaDatasItem.NO_META_DATA_ITEMS);
/* 413 */     this.cachedMetaDatasItem = result;
/* 414 */     return result;
/*     */   }
/*     */ 
/*     */   protected MetaDataRetrieval initComponentRetrieval(Signature signature)
/*     */   {
/* 420 */     return new MemoryMetaDataLoader();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader
 * JD-Core Version:    0.6.0
 */