/*    */ package org.jboss.metadata.plugins.loader;
/*    */ 
/*    */ import java.lang.annotation.Annotation;
/*    */ import org.jboss.metadata.annotation.AnnotationMatcher;
/*    */ import org.jboss.metadata.generic.GenericMatcher;
/*    */ import org.jboss.metadata.spi.retrieval.AnnotationItem;
/*    */ import org.jboss.metadata.spi.retrieval.AnnotationsItem;
/*    */ import org.jboss.metadata.spi.retrieval.MetaDataItem;
/*    */ import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
/*    */ import org.jboss.metadata.spi.retrieval.MetaDatasItem;
/*    */ import org.jboss.metadata.spi.scope.ScopeKey;
/*    */ import org.jboss.metadata.spi.signature.Signature;
/*    */ 
/*    */ public abstract class BasicMetaDataLoader extends AbstractMetaDataLoader
/*    */ {
/*    */   public BasicMetaDataLoader()
/*    */   {
/*    */   }
/*    */ 
/*    */   public BasicMetaDataLoader(ScopeKey key)
/*    */   {
/* 56 */     super(key);
/*    */   }
/*    */ 
/*    */   public <T extends Annotation> AnnotationItem<T> retrieveAnnotation(Class<T> annotationType)
/*    */   {
/* 61 */     AnnotationItem[] annotations = retrieveAnnotations().getAnnotations();
/* 62 */     return AnnotationMatcher.matchAnnotationItem(annotations, annotationType);
/*    */   }
/*    */ 
/*    */   public MetaDataItem retrieveMetaData(String name)
/*    */   {
/* 67 */     MetaDataItem[] metaDatas = retrieveMetaData().getMetaDatas();
/* 68 */     return GenericMatcher.matchMetaDataItem(metaDatas, name);
/*    */   }
/*    */ 
/*    */   public MetaDataRetrieval getComponentMetaDataRetrieval(Signature signature)
/*    */   {
/* 73 */     return null;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.plugins.loader.BasicMetaDataLoader
 * JD-Core Version:    0.6.0
 */