/*     */ package org.jboss.metadata.plugins.loader;
/*     */ 
/*     */ import org.jboss.metadata.spi.loader.MetaDataLoader;
/*     */ import org.jboss.metadata.spi.retrieval.AnnotationItem;
/*     */ import org.jboss.metadata.spi.retrieval.AnnotationsItem;
/*     */ import org.jboss.metadata.spi.retrieval.Item;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataItem;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDatasItem;
/*     */ import org.jboss.metadata.spi.retrieval.ValidTime;
/*     */ import org.jboss.metadata.spi.retrieval.helper.AnnotationToMetaDataBridge;
/*     */ import org.jboss.metadata.spi.retrieval.helper.AnnotationsToMetaDatasBridge;
/*     */ import org.jboss.metadata.spi.scope.ScopeKey;
/*     */ import org.jboss.metadata.spi.scope.ScopeLevel;
/*     */ 
/*     */ public abstract class AbstractMetaDataLoader
/*     */   implements MetaDataLoader
/*     */ {
/*     */   private ValidTime validTime;
/*     */   private ScopeKey scopeKey;
/*     */ 
/*     */   public AbstractMetaDataLoader()
/*     */   {
/*  62 */     this(ScopeKey.DEFAULT_SCOPE);
/*     */   }
/*     */ 
/*     */   public AbstractMetaDataLoader(ScopeKey key)
/*     */   {
/*  72 */     this.scopeKey = key;
/*  73 */     this.validTime = new ValidTime();
/*     */   }
/*     */ 
/*     */   public ScopeKey getScope()
/*     */   {
/*  78 */     return this.scopeKey;
/*     */   }
/*     */ 
/*     */   public ValidTime getValidTime()
/*     */   {
/*  83 */     return this.validTime;
/*     */   }
/*     */ 
/*     */   public <T> boolean isCachable(Item<T> item)
/*     */   {
/*  88 */     return true;
/*     */   }
/*     */ 
/*     */   public AnnotationsItem retrieveLocalAnnotations()
/*     */   {
/*  93 */     return retrieveAnnotations();
/*     */   }
/*     */ 
/*     */   public <T> MetaDataItem<T> retrieveMetaData(Class<T> type)
/*     */   {
/*  99 */     if (!type.isAnnotation())
/* 100 */       return null;
/* 101 */     AnnotationItem annotation = retrieveAnnotation(type);
/* 102 */     if (annotation == null)
/* 103 */       return null;
/* 104 */     return new AnnotationToMetaDataBridge(annotation);
/*     */   }
/*     */ 
/*     */   public MetaDatasItem retrieveLocalMetaData()
/*     */   {
/* 109 */     return retrieveMetaData();
/*     */   }
/*     */ 
/*     */   public MetaDatasItem retrieveMetaData()
/*     */   {
/* 114 */     AnnotationsItem annotations = retrieveAnnotations();
/* 115 */     return new AnnotationsToMetaDatasBridge(annotations);
/*     */   }
/*     */ 
/*     */   public MetaDataRetrieval getScopedRetrieval(ScopeLevel level)
/*     */   {
/* 120 */     if (getScope().getScopeLevel(level) != null) {
/* 121 */       return this;
/*     */     }
/* 123 */     return null;
/*     */   }
/*     */ 
/*     */   public void invalidate()
/*     */   {
/* 131 */     this.validTime.invalidate();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.plugins.loader.AbstractMetaDataLoader
 * JD-Core Version:    0.6.0
 */