/*     */ package org.jboss.metadata.plugins.context;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.jboss.metadata.spi.context.MetaDataContext;
/*     */ import org.jboss.metadata.spi.retrieval.AnnotationItem;
/*     */ import org.jboss.metadata.spi.retrieval.AnnotationsItem;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataItem;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDatasItem;
/*     */ import org.jboss.metadata.spi.retrieval.ValidTime;
/*     */ import org.jboss.metadata.spi.scope.ScopeLevel;
/*     */ import org.jboss.metadata.spi.signature.Signature;
/*     */ 
/*     */ public class CachingMetaDataContext extends AbstractMetaDataContext
/*     */ {
/*     */   private volatile Map<String, AnnotationItem> annotations;
/*     */   private volatile Map<String, MetaDataItem> metaDataByName;
/*     */   private volatile AnnotationsItem cachedAnnotationsItem;
/*     */   private volatile MetaDatasItem cachedMetaDatasItem;
/*     */   private volatile Map<Signature, MetaDataRetrieval> cachedComponents;
/*     */   private volatile long validTime;
/*     */   private volatile Boolean empty;
/*     */   private volatile Map<ScopeLevel, MetaDataRetrieval> cachedScopedRetrievals;
/*     */ 
/*     */   public CachingMetaDataContext(MetaDataRetrieval retrieval)
/*     */   {
/*  80 */     this(null, retrieval);
/*     */   }
/*     */ 
/*     */   public CachingMetaDataContext(MetaDataContext parent, MetaDataRetrieval retrieval)
/*     */   {
/*  91 */     this(parent, Collections.singletonList(retrieval));
/*     */   }
/*     */ 
/*     */   public CachingMetaDataContext(MetaDataContext parent, List<MetaDataRetrieval> retrievals)
/*     */   {
/* 102 */     super(parent, retrievals);
/* 103 */     this.validTime = super.getValidTime().getValidTime();
/*     */   }
/*     */ 
/*     */   public AnnotationsItem retrieveAnnotations()
/*     */   {
/* 108 */     if (this.cachedAnnotationsItem == null)
/* 109 */       this.cachedAnnotationsItem = super.retrieveAnnotations();
/* 110 */     return this.cachedAnnotationsItem;
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> AnnotationItem<T> retrieveAnnotation(Class<T> annotationType)
/*     */   {
/* 116 */     if (annotationType == null) {
/* 117 */       throw new IllegalArgumentException("Null annotationType");
/*     */     }
/* 119 */     String annotationName = annotationType.getName();
/*     */ 
/* 121 */     long newValidTime = super.getValidTime().getValidTime();
/* 122 */     if (this.validTime < newValidTime)
/*     */     {
/* 124 */       if (this.annotations != null)
/* 125 */         this.annotations.clear();
/* 126 */       if (this.metaDataByName != null)
/* 127 */         this.metaDataByName.clear();
/* 128 */       this.validTime = newValidTime;
/*     */     }
/*     */ 
/* 131 */     if (this.annotations != null)
/*     */     {
/* 133 */       AnnotationItem result = (AnnotationItem)this.annotations.get(annotationName);
/* 134 */       if (result != null)
/*     */       {
/* 136 */         if (result.isValid())
/* 137 */           return result;
/* 138 */         this.annotations.remove(annotationName);
/*     */       }
/*     */     }
/*     */ 
/* 142 */     AnnotationItem result = super.retrieveAnnotation(annotationType);
/* 143 */     if ((result != null) && (result.isCachable()))
/*     */     {
/* 145 */       if (this.annotations == null)
/* 146 */         this.annotations = new ConcurrentHashMap();
/* 147 */       this.annotations.put(annotationName, result);
/*     */     }
/*     */ 
/* 150 */     return result;
/*     */   }
/*     */ 
/*     */   public MetaDatasItem retrieveMetaData()
/*     */   {
/* 155 */     if (this.cachedMetaDatasItem == null)
/* 156 */       this.cachedMetaDatasItem = super.retrieveMetaData();
/* 157 */     return this.cachedMetaDatasItem;
/*     */   }
/*     */ 
/*     */   public <T> MetaDataItem<T> retrieveMetaData(Class<T> type)
/*     */   {
/* 163 */     if (type == null) {
/* 164 */       throw new IllegalArgumentException("Null type");
/*     */     }
/* 166 */     String name = type.getName();
/*     */ 
/* 168 */     long newValidTime = super.getValidTime().getValidTime();
/* 169 */     if (this.validTime < newValidTime)
/*     */     {
/* 171 */       if (this.annotations != null)
/* 172 */         this.annotations.clear();
/* 173 */       if (this.metaDataByName != null)
/* 174 */         this.metaDataByName.clear();
/* 175 */       this.validTime = newValidTime;
/*     */     }
/*     */ 
/* 178 */     if (this.metaDataByName != null)
/*     */     {
/* 180 */       MetaDataItem result = (MetaDataItem)this.metaDataByName.get(name);
/* 181 */       if (result != null)
/*     */       {
/* 183 */         if (result.isValid())
/* 184 */           return result;
/* 185 */         this.metaDataByName.remove(name);
/*     */       }
/*     */     }
/*     */ 
/* 189 */     MetaDataItem result = super.retrieveMetaData(type);
/* 190 */     if ((result != null) && (result.isCachable()))
/*     */     {
/* 192 */       if (this.metaDataByName == null)
/* 193 */         this.metaDataByName = new ConcurrentHashMap();
/* 194 */       this.metaDataByName.put(name, result);
/*     */     }
/*     */ 
/* 197 */     return result;
/*     */   }
/*     */ 
/*     */   public MetaDataItem retrieveMetaData(String name)
/*     */   {
/* 202 */     if (name == null) {
/* 203 */       throw new IllegalArgumentException("Null name");
/*     */     }
/* 205 */     long newValidTime = super.getValidTime().getValidTime();
/* 206 */     if (this.validTime < newValidTime)
/*     */     {
/* 208 */       if (this.annotations != null)
/* 209 */         this.annotations.clear();
/* 210 */       if (this.metaDataByName != null)
/* 211 */         this.metaDataByName.clear();
/* 212 */       this.validTime = newValidTime;
/*     */     }
/*     */ 
/* 215 */     if (this.metaDataByName != null)
/*     */     {
/* 217 */       MetaDataItem result = (MetaDataItem)this.metaDataByName.get(name);
/* 218 */       if (result != null)
/*     */       {
/* 220 */         if (result.isValid())
/* 221 */           return result;
/* 222 */         this.metaDataByName.remove(name);
/*     */       }
/*     */     }
/*     */ 
/* 226 */     MetaDataItem result = super.retrieveMetaData(name);
/* 227 */     if ((result != null) && (result.isCachable()))
/*     */     {
/* 229 */       if (this.metaDataByName == null)
/* 230 */         this.metaDataByName = new ConcurrentHashMap();
/* 231 */       this.metaDataByName.put(name, result);
/*     */     }
/*     */ 
/* 234 */     return result;
/*     */   }
/*     */ 
/*     */   public void append(MetaDataRetrieval retrieval)
/*     */   {
/* 239 */     super.append(retrieval);
/* 240 */     this.cachedComponents = null;
/* 241 */     this.empty = null;
/* 242 */     this.cachedScopedRetrievals = null;
/*     */   }
/*     */ 
/*     */   public void prepend(MetaDataRetrieval retrieval)
/*     */   {
/* 247 */     super.prepend(retrieval);
/* 248 */     this.cachedComponents = null;
/* 249 */     this.empty = null;
/* 250 */     this.cachedScopedRetrievals = null;
/*     */   }
/*     */ 
/*     */   public void remove(MetaDataRetrieval retrieval)
/*     */   {
/* 255 */     super.remove(retrieval);
/* 256 */     this.cachedComponents = null;
/* 257 */     this.empty = null;
/* 258 */     this.cachedScopedRetrievals = null;
/*     */   }
/*     */ 
/*     */   public MetaDataRetrieval getComponentMetaDataRetrieval(Signature signature)
/*     */   {
/* 263 */     if (signature == null) {
/* 264 */       return null;
/*     */     }
/* 266 */     if (this.cachedComponents != null)
/*     */     {
/* 268 */       MetaDataRetrieval retrieval = (MetaDataRetrieval)this.cachedComponents.get(signature);
/* 269 */       if (retrieval != null) {
/* 270 */         return retrieval;
/*     */       }
/*     */     }
/* 273 */     MetaDataRetrieval retrieval = super.getComponentMetaDataRetrieval(signature);
/*     */ 
/* 275 */     if (retrieval != null)
/*     */     {
/* 277 */       if (this.cachedComponents == null)
/* 278 */         this.cachedComponents = new ConcurrentHashMap();
/* 279 */       this.cachedComponents.put(signature, retrieval);
/*     */     }
/*     */ 
/* 282 */     return retrieval;
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 287 */     if (this.empty == null)
/* 288 */       this.empty = Boolean.valueOf(super.isEmpty());
/* 289 */     return this.empty.booleanValue();
/*     */   }
/*     */ 
/*     */   public MetaDataRetrieval getScopedRetrieval(ScopeLevel level)
/*     */   {
/* 294 */     boolean update = (this.cachedScopedRetrievals == null) || (!this.cachedScopedRetrievals.keySet().contains(level));
/* 295 */     return getCachedScopedRetrieval(level, update);
/*     */   }
/*     */ 
/*     */   protected MetaDataRetrieval getCachedScopedRetrieval(ScopeLevel level, boolean update)
/*     */   {
/* 307 */     if (this.cachedScopedRetrievals == null)
/*     */     {
/* 309 */       this.cachedScopedRetrievals = new HashMap();
/*     */     }
/* 311 */     MetaDataRetrieval retrieval = (MetaDataRetrieval)this.cachedScopedRetrievals.get(level);
/* 312 */     if (update)
/*     */     {
/* 314 */       retrieval = super.getScopedRetrieval(level);
/* 315 */       this.cachedScopedRetrievals.put(level, retrieval);
/*     */     }
/* 317 */     return retrieval;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.plugins.context.CachingMetaDataContext
 * JD-Core Version:    0.6.0
 */