/*     */ package org.jboss.metadata.javaee.support;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ 
/*     */ public abstract class MappedMetaDataWithDescriptions<T extends MappableMetaData> extends IdMetaDataImplWithDescriptions
/*     */   implements MappedMetaData<T>
/*     */ {
/*     */   private static final long serialVersionUID = 5696461894017065337L;
/*     */   private String keyName;
/*  46 */   private Map<String, T> map = new NonNullLinkedHashMap();
/*     */ 
/*     */   protected MappedMetaDataWithDescriptions(String keyName)
/*     */   {
/*  55 */     if (keyName == null)
/*  56 */       throw new IllegalArgumentException("Null keyName");
/*  57 */     this.keyName = keyName;
/*     */   }
/*     */ 
/*     */   public boolean containsKey(String key)
/*     */   {
/*  62 */     return this.map.containsKey(key);
/*     */   }
/*     */ 
/*     */   public T get(String key)
/*     */   {
/*  73 */     return (MappableMetaData)this.map.get(key);
/*     */   }
/*     */ 
/*     */   public Set<String> keySet()
/*     */   {
/*  78 */     return this.map.keySet();
/*     */   }
/*     */ 
/*     */   public boolean add(T o)
/*     */   {
/*  83 */     if (o == null)
/*  84 */       throw new IllegalArgumentException("Null object");
/*  85 */     String key = o.getKey();
/*  86 */     if (key == null) {
/*  87 */       throw new IllegalArgumentException(o.getClass() + ", No " + this.keyName);
/*     */     }
/*  89 */     return this.map.put(key, o) == null;
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/*  94 */     this.map.clear();
/*     */   }
/*     */ 
/*     */   public boolean contains(Object o)
/*     */   {
/*  99 */     if (o == null)
/* 100 */       throw new IllegalArgumentException("Null object");
/* 101 */     return this.map.containsValue(o);
/*     */   }
/*     */ 
/*     */   public Iterator<T> iterator()
/*     */   {
/* 106 */     return this.map.values().iterator();
/*     */   }
/*     */ 
/*     */   public boolean remove(Object o)
/*     */   {
/* 111 */     if (o == null)
/* 112 */       throw new IllegalArgumentException("Null object");
/* 113 */     if ((o instanceof MappableMetaData))
/* 114 */       return false;
/* 115 */     MappableMetaData m = (MappableMetaData)o;
/* 116 */     String key = m.getKey();
/* 117 */     MappableMetaData v = (MappableMetaData)this.map.get(key);
/* 118 */     if (m.equals(v))
/* 119 */       return this.map.remove(key) != null;
/* 120 */     return false;
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 125 */     return this.map.size();
/*     */   }
/*     */ 
/*     */   public boolean addAll(Collection<? extends T> c)
/*     */   {
/* 130 */     boolean result = false;
/* 131 */     for (MappableMetaData object : c)
/*     */     {
/* 133 */       if (add(object))
/* 134 */         result = true;
/*     */     }
/* 136 */     return result;
/*     */   }
/*     */ 
/*     */   public boolean containsAll(Collection<?> c)
/*     */   {
/* 141 */     for (Iterator i$ = c.iterator(); i$.hasNext(); ) { Object object = i$.next();
/*     */ 
/* 143 */       if (!contains(object))
/* 144 */         return false;
/*     */     }
/* 146 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 151 */     return size() == 0;
/*     */   }
/*     */ 
/*     */   public boolean removeAll(Collection<?> c)
/*     */   {
/* 156 */     boolean result = false;
/* 157 */     for (Iterator i$ = c.iterator(); i$.hasNext(); ) { Object object = i$.next();
/*     */ 
/* 159 */       if (remove(object))
/* 160 */         result = true;
/*     */     }
/* 162 */     return result;
/*     */   }
/*     */ 
/*     */   public boolean retainAll(Collection<?> c)
/*     */   {
/* 167 */     boolean result = false;
/* 168 */     for (Object o : this.map.values())
/*     */     {
/* 170 */       if (c.contains(o))
/*     */       {
/* 172 */         if (remove(o))
/* 173 */           result = true;
/*     */       }
/*     */     }
/* 176 */     return result;
/*     */   }
/*     */ 
/*     */   public Object[] toArray()
/*     */   {
/* 181 */     return this.map.values().toArray();
/*     */   }
/*     */ 
/*     */   public <X> X[] toArray(X[] a)
/*     */   {
/* 186 */     return this.map.values().toArray(a);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 192 */     return this.map.values().equals(obj);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 198 */     return this.map.values().hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 204 */     return this.map.values().toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.javaee.support.MappedMetaDataWithDescriptions
 * JD-Core Version:    0.6.0
 */