/*     */ package org.jboss.metadata.javaee.support;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.annotation.Annotation;
/*     */ import javax.xml.bind.annotation.XmlAttribute;
/*     */ import org.jboss.metadata.annotation.AbstractAnnotationImpl;
/*     */ 
/*     */ public abstract class LanguageMetaData extends AbstractAnnotationImpl
/*     */   implements Serializable, MappableMetaData, IdMetaData
/*     */ {
/*     */   private static final long serialVersionUID = 64867085990650156L;
/*     */   private String id;
/*  48 */   private String language = "en";
/*     */ 
/*     */   public LanguageMetaData(Class<? extends Annotation> annotationType)
/*     */   {
/*  57 */     super(annotationType);
/*     */   }
/*     */ 
/*     */   public String language()
/*     */   {
/*  62 */     return getLanguage();
/*     */   }
/*     */ 
/*     */   public String getId()
/*     */   {
/*  67 */     return this.id;
/*     */   }
/*     */ 
/*     */   @XmlAttribute
/*     */   public void setId(String id) {
/*  73 */     if (id == null)
/*  74 */       throw new IllegalArgumentException("Null id");
/*  75 */     this.id = id;
/*     */   }
/*     */ 
/*     */   public String getKey()
/*     */   {
/*  80 */     return getLanguage();
/*     */   }
/*     */ 
/*     */   public String getLanguage()
/*     */   {
/*  90 */     return this.language;
/*     */   }
/*     */ 
/*     */   @XmlAttribute(name="lang", namespace="http://www.w3.org/XML/1998/namespace")
/*     */   public void setLanguage(String language)
/*     */   {
/* 102 */     if (language == null)
/* 103 */       throw new IllegalArgumentException("Null language");
/* 104 */     this.language = language;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 110 */     if (obj != null) { if ((obj.getClass() == getClass() ? 1 : 0) != 0); } else return false;
/* 112 */     String name = getLanguage();
/* 113 */     LanguageMetaData other = (LanguageMetaData)obj;
/* 114 */     String otherName = other.getLanguage();
/* 115 */     return name.equals(otherName);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 121 */     String name = getLanguage();
/* 122 */     return name.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 128 */     return super.toString() + "{" + getLanguage() + "}";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.javaee.support.LanguageMetaData
 * JD-Core Version:    0.6.0
 */