/*     */ package org.jboss.metadata.javaee.spec;
/*     */ 
/*     */ import java.lang.reflect.AnnotatedElement;
/*     */ import java.util.List;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlTransient;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.metadata.javaee.support.MergeableMappedMetaData;
/*     */ import org.jboss.metadata.javaee.support.ResourceInjectionMetaDataWithDescriptionGroup;
/*     */ 
/*     */ @XmlType(name="service-refType")
/*     */ public class ServiceReferenceMetaData extends ResourceInjectionMetaDataWithDescriptionGroup
/*     */   implements MergeableMappedMetaData<ServiceReferenceMetaData>
/*     */ {
/*     */   private static final long serialVersionUID = 5693673588576610322L;
/*     */   private String serviceInterface;
/*     */   private String serviceRefType;
/*     */   private String wsdlFile;
/*     */   private String jaxrpcMappingFile;
/*     */   private QName serviceQname;
/*     */   private List<PortComponentRef> portComponentRef;
/*     */   private ServiceReferenceHandlersMetaData handlers;
/*     */   private ServiceReferenceHandlerChainsMetaData handlerChains;
/*     */   private transient AnnotatedElement anElement;
/*     */   private transient boolean processed;
/*     */ 
/*     */   public ServiceReferenceMetaData merge(ServiceReferenceMetaData original)
/*     */   {
/*  88 */     ServiceReferenceMetaData merged = new ServiceReferenceMetaData();
/*  89 */     merged.merge(this, original);
/*  90 */     return merged;
/*     */   }
/*     */ 
/*     */   public void merge(ServiceReferenceMetaData override, ServiceReferenceMetaData original)
/*     */   {
/* 101 */     super.merge(override, original);
/*     */ 
/* 103 */     if ((override != null) && (override.getServiceRefName() != null))
/* 104 */       setServiceRefName(override.getServiceRefName());
/* 105 */     else if ((original != null) && (original.getServiceRefName() != null))
/* 106 */       setServiceRefName(original.getServiceRefName());
/* 107 */     if ((override != null) && (override.getServiceInterface() != null))
/* 108 */       setServiceInterface(override.getServiceInterface());
/* 109 */     else if ((original != null) && (original.getServiceInterface() != null))
/* 110 */       setServiceInterface(original.getServiceInterface());
/* 111 */     if ((override != null) && (override.getServiceRefType() != null))
/* 112 */       setServiceRefType(override.getServiceRefType());
/* 113 */     else if ((original != null) && (original.getServiceRefType() != null))
/* 114 */       setServiceRefType(original.getServiceRefType());
/* 115 */     if ((override != null) && (override.getWsdlFile() != null))
/* 116 */       setWsdlFile(override.getWsdlFile());
/* 117 */     else if ((original != null) && (original.getWsdlFile() != null))
/* 118 */       setWsdlFile(original.getWsdlFile());
/* 119 */     if ((override != null) && (override.getJaxrpcMappingFile() != null))
/* 120 */       setJaxrpcMappingFile(override.getJaxrpcMappingFile());
/* 121 */     else if ((original != null) && (original.getJaxrpcMappingFile() != null))
/* 122 */       setJaxrpcMappingFile(original.getJaxrpcMappingFile());
/* 123 */     if ((override != null) && (override.getServiceQname() != null))
/* 124 */       setServiceQname(override.getServiceQname());
/* 125 */     else if ((original != null) && (original.getServiceQname() != null))
/* 126 */       setServiceQname(original.getServiceQname());
/* 127 */     if ((override != null) && (override.getPortComponentRef() != null))
/* 128 */       setPortComponentRef(override.getPortComponentRef());
/* 129 */     else if ((original != null) && (original.getPortComponentRef() != null))
/* 130 */       setPortComponentRef(original.getPortComponentRef());
/* 131 */     if ((override != null) && (override.getHandlers() != null))
/* 132 */       setHandlers(override.getHandlers());
/* 133 */     else if ((original != null) && (original.getHandlers() != null))
/* 134 */       setHandlers(original.getHandlers());
/* 135 */     if ((override != null) && (override.getHandlerChains() != null))
/* 136 */       setHandlerChains(override.getHandlerChains());
/* 137 */     else if ((original != null) && (original.getHandlerChains() != null))
/* 138 */       setHandlerChains(original.getHandlerChains());
/*     */   }
/*     */ 
/*     */   public String getServiceRefName()
/*     */   {
/* 148 */     return getName();
/*     */   }
/*     */ 
/*     */   public void setServiceRefName(String serviceRefName)
/*     */   {
/* 159 */     setName(serviceRefName);
/*     */   }
/*     */ 
/*     */   public String getJaxrpcMappingFile()
/*     */   {
/* 169 */     return this.jaxrpcMappingFile;
/*     */   }
/*     */ 
/*     */   public void setJaxrpcMappingFile(String jaxrpcMappingFile)
/*     */   {
/* 180 */     if (jaxrpcMappingFile == null)
/* 181 */       throw new IllegalArgumentException("Null jaxrpcMappingFile");
/* 182 */     this.jaxrpcMappingFile = jaxrpcMappingFile;
/*     */   }
/*     */ 
/*     */   public String getServiceInterface()
/*     */   {
/* 192 */     return this.serviceInterface;
/*     */   }
/*     */ 
/*     */   public void setServiceInterface(String serviceInterface)
/*     */   {
/* 203 */     if (serviceInterface == null)
/* 204 */       throw new IllegalArgumentException("Null serviceInterface");
/* 205 */     this.serviceInterface = serviceInterface;
/*     */   }
/*     */ 
/*     */   public QName getServiceQname()
/*     */   {
/* 215 */     return this.serviceQname;
/*     */   }
/*     */ 
/*     */   public void setServiceQname(QName serviceQname)
/*     */   {
/* 226 */     if (serviceQname == null)
/* 227 */       throw new IllegalArgumentException("Null serviceQname");
/* 228 */     this.serviceQname = serviceQname;
/*     */   }
/*     */ 
/*     */   public String getServiceRefType()
/*     */   {
/* 238 */     return this.serviceRefType;
/*     */   }
/*     */ 
/*     */   @XmlElement(required=false)
/*     */   public void setServiceRefType(String serviceRefType)
/*     */   {
/* 251 */     if (serviceRefType == null)
/* 252 */       throw new IllegalArgumentException("Null serviceRefType");
/* 253 */     this.serviceRefType = serviceRefType;
/*     */   }
/*     */ 
/*     */   public String getWsdlFile()
/*     */   {
/* 263 */     return this.wsdlFile;
/*     */   }
/*     */ 
/*     */   public void setWsdlFile(String wsdlFile)
/*     */   {
/* 274 */     if (wsdlFile == null)
/* 275 */       throw new IllegalArgumentException("Null wsdlFile");
/* 276 */     this.wsdlFile = wsdlFile;
/*     */   }
/*     */ 
/*     */   public List<? extends PortComponentRef> getPortComponentRef()
/*     */   {
/* 282 */     return this.portComponentRef;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="port-component-ref", type=PortComponentRef.class)
/*     */   public void setPortComponentRef(List<? extends PortComponentRef> portComponentRef) {
/* 288 */     this.portComponentRef = portComponentRef;
/*     */   }
/*     */ 
/*     */   public ServiceReferenceHandlersMetaData getHandlers()
/*     */   {
/* 298 */     return this.handlers;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="handler")
/*     */   public void setHandlers(ServiceReferenceHandlersMetaData handlers)
/*     */   {
/* 310 */     if (handlers == null)
/* 311 */       throw new IllegalArgumentException("Null handlers");
/* 312 */     this.handlers = handlers;
/*     */   }
/*     */ 
/*     */   public ServiceReferenceHandlerChainsMetaData getHandlerChains()
/*     */   {
/* 322 */     return this.handlerChains;
/*     */   }
/*     */ 
/*     */   @XmlElement(required=false)
/*     */   public void setHandlerChains(ServiceReferenceHandlerChainsMetaData handlerChains)
/*     */   {
/* 335 */     if (handlerChains == null)
/* 336 */       throw new IllegalArgumentException("Null handlerChains");
/* 337 */     this.handlerChains = handlerChains;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public AnnotatedElement getAnnotatedElement() {
/* 343 */     return this.anElement;
/*     */   }
/*     */ 
/*     */   public void setAnnotatedElement(AnnotatedElement anElement)
/*     */   {
/* 348 */     this.anElement = anElement;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public boolean isProcessed() {
/* 354 */     return this.processed;
/*     */   }
/*     */ 
/*     */   public void setProcessed(boolean processed)
/*     */   {
/* 359 */     this.processed = processed;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.javaee.spec.ServiceReferenceMetaData
 * JD-Core Version:    0.6.0
 */