/*     */ package org.jboss.metadata.javaee.spec;
/*     */ 
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.metadata.javaee.support.AbstractMappedMetaData;
/*     */ import org.jboss.metadata.javaee.support.IdMetaDataImpl;
/*     */ 
/*     */ public class SecurityRolesMetaData extends AbstractMappedMetaData<SecurityRoleMetaData>
/*     */ {
/*     */   private static final long serialVersionUID = 4551308976124434096L;
/*  44 */   private Map<String, Set<String>> principalVersusRolesMap = new HashMap();
/*  45 */   private Map<String, Set<String>> readOnlyPrincipalVersusRolesMap = Collections.unmodifiableMap(this.principalVersusRolesMap);
/*     */ 
/*     */   public SecurityRolesMetaData()
/*     */   {
/*  52 */     super("role name for security role");
/*     */   }
/*     */ 
/*     */   protected void addNotification(SecurityRoleMetaData added)
/*     */   {
/*  58 */     super.addNotification(added);
/*     */ 
/*  61 */     processSecurityRoleMetaData(added);
/*     */   }
/*     */ 
/*     */   public Map<String, Set<String>> getPrincipalVersusRolesMap()
/*     */   {
/*  66 */     return this.readOnlyPrincipalVersusRolesMap;
/*     */   }
/*     */ 
/*     */   @Deprecated
/*     */   public SecurityRolesMetaData getSecurityRolesByPrincipal(String userName)
/*     */   {
/*  79 */     if (userName == null)
/*  80 */       throw new IllegalArgumentException("Null userName");
/*  81 */     if (isEmpty())
/*  82 */       return null;
/*  83 */     SecurityRolesMetaData result = new SecurityRolesMetaData();
/*  84 */     for (SecurityRoleMetaData role : this)
/*     */     {
/*  86 */       if (role.hasPrincipal(userName))
/*  87 */         result.add(role);
/*     */     }
/*  89 */     return result;
/*     */   }
/*     */ 
/*     */   public Set<String> getSecurityRoleNamesByPrincipal(String userName)
/*     */   {
/* 101 */     if (userName == null)
/* 102 */       throw new IllegalArgumentException("Null userName");
/* 103 */     Set roles = (Set)this.readOnlyPrincipalVersusRolesMap.get(userName);
/* 104 */     if (roles == null)
/* 105 */       return Collections.emptySet();
/* 106 */     return roles;
/*     */   }
/*     */ 
/*     */   public void merge(IdMetaDataImpl override, IdMetaDataImpl original)
/*     */   {
/* 115 */     super.merge(override, original);
/* 116 */     SecurityRolesMetaData roles1 = (SecurityRolesMetaData)override;
/* 117 */     SecurityRolesMetaData roles0 = (SecurityRolesMetaData)original;
/* 118 */     if (roles0 != null)
/*     */     {
/* 120 */       for (SecurityRoleMetaData sr : roles0)
/*     */       {
/* 122 */         SecurityRoleMetaData to = (SecurityRoleMetaData)get(sr.getRoleName());
/* 123 */         if (to != null)
/*     */         {
/* 125 */           to.merge(sr, null);
/*     */         }
/*     */         else
/*     */         {
/* 129 */           add(sr);
/*     */         }
/*     */       }
/*     */     }
/* 133 */     if (roles1 != null)
/*     */     {
/* 135 */       for (SecurityRoleMetaData sr : roles1)
/*     */       {
/* 137 */         SecurityRoleMetaData to = (SecurityRoleMetaData)get(sr.getRoleName());
/* 138 */         if (to != null)
/*     */         {
/* 140 */           to.merge(sr, null);
/*     */         }
/*     */         else
/*     */         {
/* 144 */           add(sr);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 149 */     rebuildPrincipalsVersusRolesMap();
/*     */   }
/*     */ 
/*     */   private void processSecurityRoleMetaData(SecurityRoleMetaData roleMetaData)
/*     */   {
/* 159 */     Set principals = roleMetaData.getPrincipals();
/* 160 */     if (principals == null) {
/* 161 */       return;
/*     */     }
/* 163 */     for (String principal : principals)
/*     */     {
/* 165 */       Set roles = (Set)this.principalVersusRolesMap.get(principal);
/* 166 */       if (roles == null)
/*     */       {
/* 168 */         roles = new HashSet();
/* 169 */         this.principalVersusRolesMap.put(principal, roles);
/*     */       }
/* 171 */       roles.add(roleMetaData.getRoleName());
/*     */     }
/*     */   }
/*     */ 
/*     */   private void rebuildPrincipalsVersusRolesMap()
/*     */   {
/* 177 */     this.principalVersusRolesMap.clear();
/*     */ 
/* 179 */     for (SecurityRoleMetaData roleMetaData : this)
/*     */     {
/* 181 */       processSecurityRoleMetaData(roleMetaData);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void removeNotification(SecurityRoleMetaData removed)
/*     */   {
/* 188 */     super.removeNotification(removed);
/*     */ 
/* 190 */     Set principals = removed.getPrincipals();
/* 191 */     if (principals == null) {
/* 192 */       return;
/*     */     }
/* 194 */     for (String principal : principals)
/*     */     {
/* 196 */       Set roles = (Set)this.principalVersusRolesMap.get(principal);
/* 197 */       if (roles != null)
/*     */       {
/* 199 */         roles.remove(removed.getRoleName());
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.javaee.spec.SecurityRolesMetaData
 * JD-Core Version:    0.6.0
 */