/*     */ package org.jboss.metadata.javaee.spec;
/*     */ 
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import org.jboss.metadata.javaee.support.MergeableMappedMetaData;
/*     */ import org.jboss.metadata.javaee.support.ResourceInjectionMetaDataWithDescriptions;
/*     */ 
/*     */ @XmlType(name="resource-refType")
/*     */ public class ResourceReferenceMetaData extends ResourceInjectionMetaDataWithDescriptions
/*     */   implements MergeableMappedMetaData<ResourceReferenceMetaData>
/*     */ {
/*     */   private static final long serialVersionUID = 1900675456507941940L;
/*     */   private String type;
/*     */   private ResourceAuthorityType authority;
/*     */   private ResourceSharingScopeType sharingScope;
/*     */   private String resourceName;
/*     */   private String resUrl;
/*     */ 
/*     */   public String getResourceRefName()
/*     */   {
/*  72 */     return getName();
/*     */   }
/*     */ 
/*     */   @XmlElement(name="res-ref-name")
/*     */   public void setResourceRefName(String resourceRefName)
/*     */   {
/*  84 */     setName(resourceRefName);
/*     */   }
/*     */ 
/*     */   public String getType()
/*     */   {
/*  94 */     return this.type;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="res-type")
/*     */   public void setType(String type)
/*     */   {
/* 106 */     if (type == null)
/* 107 */       throw new IllegalArgumentException("Null type");
/* 108 */     this.type = type;
/*     */   }
/*     */ 
/*     */   public ResourceAuthorityType getResAuth()
/*     */   {
/* 118 */     return this.authority;
/*     */   }
/*     */ 
/*     */   public void setResAuth(ResourceAuthorityType authority)
/*     */   {
/* 129 */     if (authority == null)
/* 130 */       throw new IllegalArgumentException("Null authority");
/* 131 */     this.authority = authority;
/*     */   }
/*     */ 
/*     */   public boolean isContainerAuth()
/*     */   {
/* 141 */     if (this.authority == null) {
/* 142 */       return false;
/*     */     }
/* 144 */     return this.authority == ResourceAuthorityType.Container;
/*     */   }
/*     */ 
/*     */   public ResourceSharingScopeType getResSharingScope()
/*     */   {
/* 154 */     return this.sharingScope;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="res-sharing-scope")
/*     */   public void setResSharingScope(ResourceSharingScopeType sharingScope)
/*     */   {
/* 166 */     if (sharingScope == null)
/* 167 */       throw new IllegalArgumentException("Null sharingScope");
/* 168 */     this.sharingScope = sharingScope;
/*     */   }
/*     */ 
/*     */   public boolean isShareable()
/*     */   {
/* 178 */     if (this.sharingScope == null) {
/* 179 */       return true;
/*     */     }
/* 181 */     return this.sharingScope == ResourceSharingScopeType.Shareable;
/*     */   }
/*     */ 
/*     */   public ResourceReferenceMetaData merge(ResourceReferenceMetaData original)
/*     */   {
/* 186 */     ResourceReferenceMetaData merged = new ResourceReferenceMetaData();
/* 187 */     merged.merge(this, original);
/* 188 */     return merged;
/*     */   }
/*     */ 
/*     */   public void merge(ResourceReferenceMetaData override, ResourceReferenceMetaData original)
/*     */   {
/* 199 */     super.merge(override, original);
/* 200 */     if ((override != null) && (override.type != null))
/* 201 */       setType(override.type);
/* 202 */     else if (original.type != null)
/* 203 */       setType(original.type);
/* 204 */     if ((override != null) && (override.resourceName != null))
/* 205 */       setResourceName(override.resourceName);
/* 206 */     else if (original.resourceName != null)
/* 207 */       setResourceName(original.resourceName);
/* 208 */     if ((override != null) && (override.authority != null))
/* 209 */       setResAuth(override.authority);
/* 210 */     else if (original.authority != null)
/* 211 */       setResAuth(original.authority);
/* 212 */     if ((override != null) && (override.sharingScope != null))
/* 213 */       setResSharingScope(override.sharingScope);
/* 214 */     else if (original.sharingScope != null)
/* 215 */       setResSharingScope(original.sharingScope);
/* 216 */     if ((override != null) && (override.resUrl != null))
/* 217 */       setResUrl(override.resUrl);
/* 218 */     else if (original.resUrl != null)
/* 219 */       setResUrl(original.resUrl);
/*     */   }
/*     */ 
/*     */   public String getResourceName()
/*     */   {
/* 229 */     return this.resourceName;
/*     */   }
/*     */ 
/*     */   @XmlElement(required=false)
/*     */   public void setResourceName(String resourceName)
/*     */   {
/* 242 */     if (resourceName == null)
/* 243 */       throw new IllegalArgumentException("Null resourceName");
/* 244 */     this.resourceName = resourceName;
/*     */   }
/*     */ 
/*     */   public String getResUrl()
/*     */   {
/* 254 */     return this.resUrl;
/*     */   }
/*     */ 
/*     */   @XmlElement(required=false)
/*     */   public void setResUrl(String resUrl)
/*     */   {
/* 267 */     if (resUrl == null)
/* 268 */       throw new IllegalArgumentException("Null resUrl");
/* 269 */     this.resUrl = resUrl;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.javaee.spec.ResourceReferenceMetaData
 * JD-Core Version:    0.6.0
 */