/*     */ package org.jboss.metadata.javaee.spec;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlTransient;
/*     */ import org.jboss.metadata.javaee.jboss.JBossServiceReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.support.AbstractMappedMetaData;
/*     */ import org.jboss.xb.annotations.JBossXmlCollection;
/*     */ import org.jboss.xb.annotations.JBossXmlModelGroup;
/*     */ 
/*     */ @JBossXmlModelGroup(name="jndiEnvironmentRefsGroup", propOrder={"environmentEntries", "ejbReferences", "serviceReferences", "resourceReferences", "resourceEnvironmentReferences", "messageDestinationReferences", "persistenceUnitRefs", "postConstructs", "preDestroys"})
/*     */ public class RemoteEnvironmentRefsGroupMetaData
/*     */   implements Serializable, RemoteEnvironment, MutableRemoteEnvironment
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private EnvironmentEntriesMetaData environmentEntries;
/*     */   private transient AnnotatedEJBReferencesMetaData annotatedEjbReferences;
/*     */   private EJBReferencesMetaData ejbReferences;
/*     */   private ServiceReferencesMetaData serviceReferences;
/*     */   private ResourceReferencesMetaData resourceReferences;
/*     */   private ResourceEnvironmentReferencesMetaData resourceEnvironmentReferences;
/*     */   private MessageDestinationReferencesMetaData messageDestinationReferences;
/*     */   private PersistenceUnitReferencesMetaData persistenceUnitRefs;
/*     */   private LifecycleCallbacksMetaData postConstructs;
/*     */   private LifecycleCallbacksMetaData preDestroys;
/*     */ 
/*     */   public EnvironmentEntriesMetaData getEnvironmentEntries()
/*     */   {
/* 103 */     return this.environmentEntries;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="env-entry")
/*     */   public void setEnvironmentEntries(EnvironmentEntriesMetaData environmentEntries)
/*     */   {
/* 115 */     if (environmentEntries == null)
/* 116 */       throw new IllegalArgumentException("Null environmentEntries");
/* 117 */     this.environmentEntries = environmentEntries;
/*     */   }
/*     */ 
/*     */   public EJBReferencesMetaData getEjbReferences()
/*     */   {
/* 127 */     return this.ejbReferences;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="ejb-ref")
/*     */   public void setEjbReferences(EJBReferencesMetaData ejbReferences)
/*     */   {
/* 139 */     if (ejbReferences == null)
/* 140 */       throw new IllegalArgumentException("Null ejbReferences");
/* 141 */     this.ejbReferences = ejbReferences;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public AnnotatedEJBReferencesMetaData getAnnotatedEjbReferences() {
/* 147 */     return this.annotatedEjbReferences;
/*     */   }
/*     */   @XmlTransient
/*     */   public void setAnnotatedEjbReferences(AnnotatedEJBReferencesMetaData annotatedEjbReferences) {
/* 152 */     if (annotatedEjbReferences == null)
/* 153 */       throw new IllegalArgumentException("Null annotatedEjbReferences");
/* 154 */     this.annotatedEjbReferences = annotatedEjbReferences;
/*     */   }
/*     */ 
/*     */   public ServiceReferencesMetaData getServiceReferences()
/*     */   {
/* 164 */     return this.serviceReferences;
/*     */   }
/*     */ 
/*     */   @JBossXmlCollection(type=ServiceReferencesMetaData.class)
/*     */   @XmlElement(name="service-ref", type=ServiceReferenceMetaData.class)
/*     */   public void setServiceReferences(ServiceReferencesMetaData serviceReferences)
/*     */   {
/* 177 */     this.serviceReferences = serviceReferences;
/*     */   }
/*     */ 
/*     */   public ResourceReferencesMetaData getResourceReferences()
/*     */   {
/* 187 */     return this.resourceReferences;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="resource-ref")
/*     */   public void setResourceReferences(ResourceReferencesMetaData resourceReferences)
/*     */   {
/* 199 */     if (resourceReferences == null)
/* 200 */       throw new IllegalArgumentException("Null resourceReferences");
/* 201 */     this.resourceReferences = resourceReferences;
/*     */   }
/*     */ 
/*     */   public ResourceEnvironmentReferencesMetaData getResourceEnvironmentReferences()
/*     */   {
/* 211 */     return this.resourceEnvironmentReferences;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="resource-env-ref")
/*     */   public void setResourceEnvironmentReferences(ResourceEnvironmentReferencesMetaData resourceEnvironmentReferences)
/*     */   {
/* 223 */     if (resourceEnvironmentReferences == null)
/* 224 */       throw new IllegalArgumentException("Null resourceEnvironmentReferences");
/* 225 */     this.resourceEnvironmentReferences = resourceEnvironmentReferences;
/*     */   }
/*     */ 
/*     */   public MessageDestinationReferencesMetaData getMessageDestinationReferences()
/*     */   {
/* 235 */     return this.messageDestinationReferences;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="message-destination-ref")
/*     */   public void setMessageDestinationReferences(MessageDestinationReferencesMetaData messageDestinationReferences)
/*     */   {
/* 247 */     if (messageDestinationReferences == null)
/* 248 */       throw new IllegalArgumentException("Null messageDestinationReferences");
/* 249 */     this.messageDestinationReferences = messageDestinationReferences;
/*     */   }
/*     */ 
/*     */   public LifecycleCallbacksMetaData getPostConstructs()
/*     */   {
/* 259 */     return this.postConstructs;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="post-construct")
/*     */   public void setPostConstructs(LifecycleCallbacksMetaData postConstructs)
/*     */   {
/* 272 */     if (postConstructs == null)
/* 273 */       throw new IllegalArgumentException("Null postConstructs");
/* 274 */     this.postConstructs = postConstructs;
/*     */   }
/*     */ 
/*     */   public LifecycleCallbacksMetaData getPreDestroys()
/*     */   {
/* 284 */     return this.preDestroys;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="pre-destroy")
/*     */   public void setPreDestroys(LifecycleCallbacksMetaData preDestroys)
/*     */   {
/* 297 */     if (preDestroys == null)
/* 298 */       throw new IllegalArgumentException("Null preDestroys");
/* 299 */     this.preDestroys = preDestroys;
/*     */   }
/*     */ 
/*     */   public PersistenceUnitReferencesMetaData getPersistenceUnitRefs()
/*     */   {
/* 309 */     return this.persistenceUnitRefs;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="persistence-unit-ref")
/*     */   public void setPersistenceUnitRefs(PersistenceUnitReferencesMetaData persistenceUnitRefs)
/*     */   {
/* 321 */     if (persistenceUnitRefs == null)
/* 322 */       throw new IllegalArgumentException("Null persistenceUnitRefs");
/* 323 */     this.persistenceUnitRefs = persistenceUnitRefs;
/*     */   }
/*     */ 
/*     */   public EJBReferenceMetaData getEjbReferenceByName(String name)
/*     */   {
/* 328 */     return (EJBReferenceMetaData)AbstractMappedMetaData.getByName(name, getEjbReferences());
/*     */   }
/*     */ 
/*     */   public EnvironmentEntryMetaData getEnvironmentEntryByName(String name)
/*     */   {
/* 333 */     return (EnvironmentEntryMetaData)AbstractMappedMetaData.getByName(name, getEnvironmentEntries());
/*     */   }
/*     */ 
/*     */   public MessageDestinationReferenceMetaData getMessageDestinationReferenceByName(String name)
/*     */   {
/* 338 */     return (MessageDestinationReferenceMetaData)AbstractMappedMetaData.getByName(name, getMessageDestinationReferences());
/*     */   }
/*     */ 
/*     */   public PersistenceUnitReferenceMetaData getPersistenceUnitReferenceByName(String name)
/*     */   {
/* 343 */     return (PersistenceUnitReferenceMetaData)AbstractMappedMetaData.getByName(name, getPersistenceUnitRefs());
/*     */   }
/*     */ 
/*     */   public ResourceEnvironmentReferenceMetaData getResourceEnvironmentReferenceByName(String name)
/*     */   {
/* 348 */     return (ResourceEnvironmentReferenceMetaData)AbstractMappedMetaData.getByName(name, getResourceEnvironmentReferences());
/*     */   }
/*     */ 
/*     */   public ResourceReferenceMetaData getResourceReferenceByName(String name)
/*     */   {
/* 353 */     return (ResourceReferenceMetaData)AbstractMappedMetaData.getByName(name, getResourceReferences());
/*     */   }
/*     */ 
/*     */   public ServiceReferenceMetaData getServiceReferenceByName(String name) {
/* 357 */     ServiceReferencesMetaData srefs = getServiceReferences();
/* 358 */     return (ServiceReferenceMetaData)AbstractMappedMetaData.getByName(name, srefs);
/*     */   }
/*     */ 
/*     */   public void merge(RemoteEnvironment jbossEnv, RemoteEnvironment specEnv, String overrideFile, String overridenFile, boolean mustOverride)
/*     */   {
/* 364 */     EJBReferencesMetaData ejbRefs = null;
/* 365 */     EJBReferencesMetaData jbossEjbRefs = null;
/* 366 */     ServiceReferencesMetaData serviceRefs = null;
/* 367 */     ServiceReferencesMetaData jbossServiceRefs = null;
/* 368 */     ResourceReferencesMetaData resRefs = null;
/* 369 */     ResourceReferencesMetaData jbossResRefs = null;
/* 370 */     ResourceEnvironmentReferencesMetaData resEnvRefs = null;
/* 371 */     ResourceEnvironmentReferencesMetaData jbossResEnvRefs = null;
/* 372 */     MessageDestinationReferencesMetaData messageDestinationRefs = null;
/* 373 */     MessageDestinationReferencesMetaData jbossMessageDestinationRefs = null;
/* 374 */     PersistenceUnitReferencesMetaData persistenceUnitRefs = null;
/* 375 */     LifecycleCallbacksMetaData postConstructs = null;
/* 376 */     LifecycleCallbacksMetaData preDestroys = null;
/*     */ 
/* 378 */     if (specEnv != null)
/*     */     {
/* 380 */       ejbRefs = specEnv.getEjbReferences();
/* 381 */       serviceRefs = specEnv.getServiceReferences();
/* 382 */       resRefs = specEnv.getResourceReferences();
/* 383 */       resEnvRefs = specEnv.getResourceEnvironmentReferences();
/* 384 */       messageDestinationRefs = specEnv.getMessageDestinationReferences();
/* 385 */       persistenceUnitRefs = specEnv.getPersistenceUnitRefs();
/* 386 */       postConstructs = specEnv.getPostConstructs();
/* 387 */       preDestroys = specEnv.getPreDestroys();
/*     */     }
/*     */ 
/* 390 */     if (jbossEnv != null)
/*     */     {
/* 392 */       jbossEjbRefs = jbossEnv.getEjbReferences();
/* 393 */       jbossServiceRefs = jbossEnv.getServiceReferences();
/* 394 */       jbossResRefs = jbossEnv.getResourceReferences();
/* 395 */       jbossResEnvRefs = jbossEnv.getResourceEnvironmentReferences();
/* 396 */       jbossMessageDestinationRefs = jbossEnv.getMessageDestinationReferences();
/*     */     }
/*     */     else
/*     */     {
/* 401 */       jbossEjbRefs = getEjbReferences();
/* 402 */       jbossServiceRefs = getServiceReferences();
/* 403 */       jbossResRefs = getResourceReferences();
/* 404 */       jbossResEnvRefs = getResourceEnvironmentReferences();
/* 405 */       jbossMessageDestinationRefs = getMessageDestinationReferences();
/*     */     }
/*     */ 
/* 409 */     EJBReferencesMetaData mergedEjbRefs = EJBReferencesMetaData.merge(jbossEjbRefs, ejbRefs, overrideFile, overridenFile, mustOverride);
/* 410 */     if (mergedEjbRefs != null) {
/* 411 */       setEjbReferences(mergedEjbRefs);
/*     */     }
/* 413 */     ServiceReferencesMetaData mergedServiceRefs = JBossServiceReferencesMetaData.merge(jbossServiceRefs, serviceRefs, overrideFile, overridenFile);
/* 414 */     if (mergedServiceRefs != null) {
/* 415 */       setServiceReferences(mergedServiceRefs);
/*     */     }
/* 417 */     ResourceReferencesMetaData mergedResRefs = ResourceReferencesMetaData.merge(jbossResRefs, resRefs, overrideFile, overridenFile, mustOverride);
/* 418 */     if (mergedResRefs != null) {
/* 419 */       setResourceReferences(mergedResRefs);
/*     */     }
/* 421 */     ResourceEnvironmentReferencesMetaData mergedResEnvRefs = ResourceEnvironmentReferencesMetaData.merge(jbossResEnvRefs, resEnvRefs, overrideFile, overridenFile);
/* 422 */     if (mergedResEnvRefs != null) {
/* 423 */       setResourceEnvironmentReferences(mergedResEnvRefs);
/*     */     }
/* 425 */     MessageDestinationReferencesMetaData mergedMessageDestinationRefs = MessageDestinationReferencesMetaData.merge(jbossMessageDestinationRefs, messageDestinationRefs, "", "", mustOverride);
/* 426 */     if (mergedMessageDestinationRefs != null) {
/* 427 */       setMessageDestinationReferences(mergedMessageDestinationRefs);
/*     */     }
/* 429 */     if (specEnv != null)
/*     */     {
/* 431 */       EnvironmentEntriesMetaData envEntries = specEnv.getEnvironmentEntries();
/* 432 */       if (envEntries != null)
/*     */       {
/* 434 */         EnvironmentEntriesMetaData thisEnv = getEnvironmentEntries();
/* 435 */         if (thisEnv != null)
/* 436 */           thisEnv.addAll(envEntries);
/*     */         else
/* 438 */           setEnvironmentEntries(envEntries);
/*     */       }
/*     */     }
/* 441 */     if (jbossEnv != null)
/*     */     {
/* 443 */       EnvironmentEntriesMetaData envEntries = jbossEnv.getEnvironmentEntries();
/* 444 */       if (envEntries != null)
/*     */       {
/* 446 */         EnvironmentEntriesMetaData thisEnv = getEnvironmentEntries();
/* 447 */         if (thisEnv != null)
/* 448 */           thisEnv.addAll(envEntries);
/*     */         else {
/* 450 */           setEnvironmentEntries(envEntries);
/*     */         }
/*     */       }
/*     */     }
/* 454 */     if (persistenceUnitRefs != null) {
/* 455 */       setPersistenceUnitRefs(persistenceUnitRefs);
/*     */     }
/* 457 */     if (postConstructs != null) {
/* 458 */       setPostConstructs(postConstructs);
/*     */     }
/* 460 */     if (preDestroys != null)
/* 461 */       setPreDestroys(preDestroys);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.javaee.spec.RemoteEnvironmentRefsGroupMetaData
 * JD-Core Version:    0.6.0
 */