/*     */ package org.jboss.metadata.javaee.spec;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import org.jboss.metadata.javaee.support.AbstractMappedMetaData;
/*     */ import org.jboss.xb.annotations.JBossXmlModelGroup;
/*     */ 
/*     */ @JBossXmlModelGroup(name="jndiEnvironmentRefsGroup", propOrder={"environmentEntries", "ejbReferences", "ejbLocalReferences", "serviceReferences", "resourceReferences", "resourceEnvironmentReferences", "messageDestinationReferences", "persistenceContextRefs", "persistenceUnitRefs", "postConstructs", "preDestroys"})
/*     */ public class EnvironmentRefsGroupMetaData extends RemoteEnvironmentRefsGroupMetaData
/*     */   implements Serializable, Environment, MutableEnvironment
/*     */ {
/*     */   private static final long serialVersionUID = 1337095770028220349L;
/*     */   private EJBLocalReferencesMetaData ejbLocalReferences;
/*     */   private PersistenceContextReferencesMetaData persistenceContextRefs;
/*     */ 
/*     */   public EJBLocalReferencesMetaData getEjbLocalReferences()
/*     */   {
/*  71 */     return this.ejbLocalReferences;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="ejb-local-ref")
/*     */   public void setEjbLocalReferences(EJBLocalReferencesMetaData ejbLocalReferences)
/*     */   {
/*  83 */     if (ejbLocalReferences == null)
/*  84 */       throw new IllegalArgumentException("Null ejbLocalReferences");
/*  85 */     this.ejbLocalReferences = ejbLocalReferences;
/*     */   }
/*     */ 
/*     */   public PersistenceContextReferencesMetaData getPersistenceContextRefs()
/*     */   {
/*  95 */     return this.persistenceContextRefs;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="persistence-context-ref")
/*     */   public void setPersistenceContextRefs(PersistenceContextReferencesMetaData persistenceContextRefs)
/*     */   {
/* 107 */     if (persistenceContextRefs == null)
/* 108 */       throw new IllegalArgumentException("Null persistenceContextRefs");
/* 109 */     this.persistenceContextRefs = persistenceContextRefs;
/*     */   }
/*     */ 
/*     */   public EJBLocalReferenceMetaData getEjbLocalReferenceByName(String name)
/*     */   {
/* 114 */     return (EJBLocalReferenceMetaData)AbstractMappedMetaData.getByName(name, this.ejbLocalReferences);
/*     */   }
/*     */ 
/*     */   public PersistenceContextReferenceMetaData getPersistenceContextReferenceByName(String name)
/*     */   {
/* 119 */     return (PersistenceContextReferenceMetaData)AbstractMappedMetaData.getByName(name, this.persistenceContextRefs);
/*     */   }
/*     */ 
/*     */   public void merge(Environment jbossEnv, Environment specEnv, String overridenFile, String overrideFile, boolean mustOverride)
/*     */   {
/* 125 */     super.merge(jbossEnv, specEnv, overrideFile, overridenFile, mustOverride);
/*     */ 
/* 127 */     EJBLocalReferencesMetaData ejbLocalRefs = null;
/* 128 */     EJBLocalReferencesMetaData jbossEjbLocalRefs = null;
/* 129 */     PersistenceContextReferencesMetaData persistenceContextRefs = null;
/*     */ 
/* 131 */     if (specEnv != null)
/*     */     {
/* 133 */       ejbLocalRefs = specEnv.getEjbLocalReferences();
/* 134 */       persistenceContextRefs = specEnv.getPersistenceContextRefs();
/*     */     }
/*     */ 
/* 137 */     if (jbossEnv != null)
/*     */     {
/* 139 */       jbossEjbLocalRefs = jbossEnv.getEjbLocalReferences();
/* 140 */       persistenceContextRefs = jbossEnv.getPersistenceContextRefs();
/*     */     }
/*     */     else
/*     */     {
/* 145 */       jbossEjbLocalRefs = getEjbLocalReferences();
/* 146 */       persistenceContextRefs = getPersistenceContextRefs();
/*     */     }
/*     */ 
/* 149 */     EJBLocalReferencesMetaData mergedEjbLocalRefs = EJBLocalReferencesMetaData.merge(jbossEjbLocalRefs, ejbLocalRefs, overridenFile, overrideFile);
/* 150 */     if (mergedEjbLocalRefs != null) {
/* 151 */       setEjbLocalReferences(mergedEjbLocalRefs);
/*     */     }
/* 153 */     if (persistenceContextRefs != null)
/* 154 */       setPersistenceContextRefs(persistenceContextRefs);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData
 * JD-Core Version:    0.6.0
 */