/*     */ package org.jboss.metadata.javaee.spec;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlTransient;
/*     */ import org.jboss.annotation.javaee.Description;
/*     */ import org.jboss.annotation.javaee.Descriptions;
/*     */ import org.jboss.annotation.javaee.DisplayName;
/*     */ import org.jboss.annotation.javaee.DisplayNames;
/*     */ import org.jboss.annotation.javaee.Icons;
/*     */ import org.jboss.xb.annotations.JBossXmlModelGroup;
/*     */ 
/*     */ @JBossXmlModelGroup(kind="all", name="descriptionGroup", propOrder={"descriptions", "displayNames", "icons"})
/*     */ public class DescriptionGroupMetaData
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1337095770028220349L;
/*     */   private Descriptions descriptions;
/*     */   private DisplayNames displayNames;
/*     */   private Icons icons;
/*     */ 
/*     */   public Descriptions getDescriptions()
/*     */   {
/*  73 */     return this.descriptions;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="description", type=DescriptionsImpl.class)
/*     */   public void setDescriptions(Descriptions descriptions)
/*     */   {
/*  85 */     if (descriptions == null)
/*  86 */       throw new IllegalArgumentException("Null descriptions");
/*  87 */     this.descriptions = descriptions;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public String getDescription() {
/*  93 */     String description = getDescription("en");
/*  94 */     return description;
/*     */   }
/*     */ 
/*     */   public String getDescription(String lang) {
/*  98 */     String description = null;
/*  99 */     if (this.descriptions != null)
/*     */     {
/* 101 */       for (Description d : this.descriptions.value())
/*     */       {
/* 103 */         if (d.language().equals(lang))
/* 104 */           description = d.value();
/*     */       }
/*     */     }
/* 107 */     return description;
/*     */   }
/*     */ 
/*     */   public DisplayNames getDisplayNames()
/*     */   {
/* 117 */     return this.displayNames;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="display-name", type=DisplayNamesImpl.class)
/*     */   public void setDisplayNames(DisplayNames displayNames)
/*     */   {
/* 129 */     if (displayNames == null)
/* 130 */       throw new IllegalArgumentException("Null displayNames");
/* 131 */     this.displayNames = displayNames;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public String getDisplayName() {
/* 137 */     String displayName = getDisplayName("en");
/* 138 */     return displayName;
/*     */   }
/*     */ 
/*     */   public String getDisplayName(String lang) {
/* 142 */     String displayName = null;
/* 143 */     if (this.displayNames != null)
/*     */     {
/* 145 */       for (DisplayName d : this.displayNames.value())
/*     */       {
/* 147 */         if (d.language().equals(lang))
/* 148 */           displayName = d.value();
/*     */       }
/*     */     }
/* 151 */     return displayName;
/*     */   }
/*     */ 
/*     */   public Icons getIcons()
/*     */   {
/* 161 */     return this.icons;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="icon", type=IconsImpl.class)
/*     */   public void setIcons(Icons icons)
/*     */   {
/* 173 */     if (icons == null)
/* 174 */       throw new IllegalArgumentException("Null icons");
/* 175 */     this.icons = icons;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.javaee.spec.DescriptionGroupMetaData
 * JD-Core Version:    0.6.0
 */