/*     */ package org.jboss.metadata.javaee.jboss;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlTransient;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import org.jboss.metadata.javaee.spec.PortComponentRef;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
/*     */ 
/*     */ @XmlType(name="service-refType")
/*     */ public class JBossServiceReferenceMetaData extends ServiceReferenceMetaData
/*     */ {
/*     */   private static final long serialVersionUID = 5693673588576610322L;
/*     */   private String serviceClass;
/*     */   private String configName;
/*     */   private String configFile;
/*     */   private String handlerChain;
/*     */   private List<JBossPortComponentRef> jbossPortComponentRef;
/*     */   private String wsdlOverride;
/*     */ 
/*     */   public String getServiceRefName()
/*     */   {
/*  86 */     return getName();
/*     */   }
/*     */ 
/*     */   @XmlElement(name="service-ref-name")
/*     */   public void setServiceRefName(String serviceRefName)
/*     */   {
/*  98 */     setName(serviceRefName);
/*     */   }
/*     */ 
/*     */   public String getConfigFile()
/*     */   {
/* 103 */     return this.configFile;
/*     */   }
/*     */ 
/*     */   public void setConfigFile(String configFile)
/*     */   {
/* 108 */     this.configFile = configFile;
/*     */   }
/*     */ 
/*     */   public String getConfigName()
/*     */   {
/* 113 */     return this.configName;
/*     */   }
/*     */ 
/*     */   public void setConfigName(String configName)
/*     */   {
/* 118 */     this.configName = configName;
/*     */   }
/*     */ 
/*     */   public String getHandlerChain()
/*     */   {
/* 123 */     return this.handlerChain;
/*     */   }
/*     */ 
/*     */   public void setHandlerChain(String handlerChain)
/*     */   {
/* 128 */     this.handlerChain = handlerChain;
/*     */   }
/*     */ 
/*     */   public String getServiceClass()
/*     */   {
/* 133 */     return this.serviceClass;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="service-impl-class")
/*     */   public void setServiceClass(String serviceClass) {
/* 139 */     this.serviceClass = serviceClass;
/*     */   }
/*     */ 
/*     */   public List<JBossPortComponentRef> getJBossPortComponentRef()
/*     */   {
/* 144 */     return this.jbossPortComponentRef;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="port-component-ref", type=JBossPortComponentRef.class)
/*     */   public void setJBossPortComponentRef(List<JBossPortComponentRef> portComponentRef) {
/* 150 */     this.jbossPortComponentRef = portComponentRef;
/*     */   }
/*     */ 
/*     */   public List<? extends PortComponentRef> getPortComponentRef()
/*     */   {
/* 156 */     return this.jbossPortComponentRef;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public void setPortComponentRef(List<? extends PortComponentRef> portComponentRef)
/*     */   {
/* 163 */     super.setPortComponentRef(portComponentRef);
/*     */   }
/*     */ 
/*     */   public String getWsdlOverride()
/*     */   {
/* 168 */     return this.wsdlOverride;
/*     */   }
/*     */ 
/*     */   public void setWsdlOverride(String wsdlOverride)
/*     */   {
/* 173 */     this.wsdlOverride = wsdlOverride;
/*     */   }
/*     */ 
/*     */   public ServiceReferenceMetaData merge(ServiceReferenceMetaData original)
/*     */   {
/* 178 */     JBossServiceReferenceMetaData merged = new JBossServiceReferenceMetaData();
/* 179 */     merged.merge(this, original);
/* 180 */     return merged;
/*     */   }
/*     */ 
/*     */   public JBossServiceReferenceMetaData merge(JBossServiceReferenceMetaData original)
/*     */   {
/* 185 */     JBossServiceReferenceMetaData merged = new JBossServiceReferenceMetaData();
/* 186 */     merged.merge(this, original);
/* 187 */     return merged;
/*     */   }
/*     */ 
/*     */   public void merge(JBossServiceReferenceMetaData override, ServiceReferenceMetaData original)
/*     */   {
/* 198 */     ServiceReferenceMetaData sr0 = override;
/* 199 */     ServiceReferenceMetaData sr1 = original;
/* 200 */     super.merge(sr0, sr1);
/*     */ 
/* 203 */     if ((original != null) && (original.getPortComponentRef() != null))
/*     */     {
/* 205 */       if (this.jbossPortComponentRef == null)
/* 206 */         this.jbossPortComponentRef = new ArrayList();
/* 207 */       for (PortComponentRef ref : original.getPortComponentRef())
/*     */       {
/* 209 */         JBossPortComponentRef jref = new JBossPortComponentRef();
/* 210 */         jref.merge(null, ref);
/* 211 */         this.jbossPortComponentRef.add(jref);
/*     */       }
/*     */     }
/* 214 */     if ((override != null) && (override.getJBossPortComponentRef() != null))
/*     */     {
/* 216 */       if (this.jbossPortComponentRef == null)
/* 217 */         this.jbossPortComponentRef = new ArrayList();
/* 218 */       for (JBossPortComponentRef ref : override.getJBossPortComponentRef())
/*     */       {
/* 220 */         JBossPortComponentRef jref = null;
/* 221 */         boolean shouldAdd = true;
/*     */ 
/* 223 */         for (JBossPortComponentRef ref2 : this.jbossPortComponentRef)
/*     */         {
/* 225 */           String sei = ref2.getServiceEndpointInterface();
/* 226 */           if ((sei != null) && (sei.equals(ref.getServiceEndpointInterface())))
/*     */           {
/* 228 */             jref = ref2;
/* 229 */             shouldAdd = false;
/* 230 */             break;
/*     */           }
/*     */         }
/* 233 */         if (jref == null)
/* 234 */           jref = new JBossPortComponentRef();
/* 235 */         jref.merge(null, ref);
/* 236 */         if (shouldAdd) {
/* 237 */           this.jbossPortComponentRef.add(jref);
/*     */         }
/*     */       }
/*     */     }
/* 241 */     if ((override != null) && (override.getServiceClass() != null))
/* 242 */       setServiceClass(override.getServiceClass());
/* 243 */     if ((override != null) && (override.getConfigName() != null))
/* 244 */       setConfigName(override.getConfigName());
/* 245 */     if ((override != null) && (override.getConfigFile() != null))
/* 246 */       setConfigFile(override.getConfigFile());
/* 247 */     if ((override != null) && (override.getHandlerChain() != null))
/* 248 */       setHandlerChain(override.getHandlerChain());
/* 249 */     if ((override != null) && (override.getWsdlOverride() != null))
/* 250 */       setWsdlOverride(override.getWsdlOverride());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.javaee.jboss.JBossServiceReferenceMetaData
 * JD-Core Version:    0.6.0
 */