/*     */ package org.jboss.metadata.javaee.jboss;
/*     */ 
/*     */ import org.jboss.metadata.javaee.spec.EJBReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PersistenceUnitReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.RemoteEnvironment;
/*     */ import org.jboss.metadata.javaee.spec.RemoteEnvironmentRefsGroupMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;
/*     */ import org.jboss.xb.annotations.JBossXmlModelGroup;
/*     */ 
/*     */ @JBossXmlModelGroup(name="jndiEnvironmentRefsGroup", propOrder={"environmentEntries", "ejbReferences", "serviceReferences", "resourceReferences", "resourceEnvironmentReferences", "messageDestinationReferences", "persistenceUnitRefs", "postConstructs", "preDestroys"})
/*     */ public class JBossRemoteEnvironmentRefsGroupMetaData extends RemoteEnvironmentRefsGroupMetaData
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */ 
/*     */   public static JBossRemoteEnvironmentRefsGroupMetaData merge(JBossRemoteEnvironmentRefsGroupMetaData jbossEnvironmentRefsGroup, RemoteEnvironment environmentRefsGroup, String overridenFile, String overrideFile, boolean mustOverride)
/*     */   {
/*  61 */     JBossRemoteEnvironmentRefsGroupMetaData merged = new JBossRemoteEnvironmentRefsGroupMetaData();
/*     */ 
/*  63 */     if ((jbossEnvironmentRefsGroup == null) && (environmentRefsGroup == null)) {
/*  64 */       return merged;
/*     */     }
/*  66 */     EnvironmentEntriesMetaData envEntries = null;
/*  67 */     EJBReferencesMetaData ejbRefs = null;
/*  68 */     EJBReferencesMetaData jbossEjbRefs = null;
/*  69 */     ServiceReferencesMetaData serviceRefs = null;
/*  70 */     ServiceReferencesMetaData jbossServiceRefs = null;
/*  71 */     ResourceReferencesMetaData resRefs = null;
/*  72 */     ResourceReferencesMetaData jbossResRefs = null;
/*  73 */     ResourceEnvironmentReferencesMetaData resEnvRefs = null;
/*  74 */     ResourceEnvironmentReferencesMetaData jbossResEnvRefs = null;
/*  75 */     MessageDestinationReferencesMetaData messageDestinationRefs = null;
/*  76 */     MessageDestinationReferencesMetaData jbossMessageDestinationRefs = null;
/*  77 */     PersistenceUnitReferencesMetaData persistenceUnitRefs = null;
/*  78 */     LifecycleCallbacksMetaData postConstructs = null;
/*  79 */     LifecycleCallbacksMetaData preDestroys = null;
/*     */ 
/*  81 */     if (environmentRefsGroup != null)
/*     */     {
/*  83 */       envEntries = environmentRefsGroup.getEnvironmentEntries();
/*  84 */       ejbRefs = environmentRefsGroup.getEjbReferences();
/*  85 */       serviceRefs = environmentRefsGroup.getServiceReferences();
/*  86 */       resRefs = environmentRefsGroup.getResourceReferences();
/*  87 */       resEnvRefs = environmentRefsGroup.getResourceEnvironmentReferences();
/*  88 */       messageDestinationRefs = environmentRefsGroup.getMessageDestinationReferences();
/*  89 */       persistenceUnitRefs = environmentRefsGroup.getPersistenceUnitRefs();
/*  90 */       postConstructs = environmentRefsGroup.getPostConstructs();
/*  91 */       preDestroys = environmentRefsGroup.getPreDestroys();
/*     */     }
/*     */ 
/*  94 */     if (jbossEnvironmentRefsGroup != null)
/*     */     {
/*  96 */       jbossEjbRefs = jbossEnvironmentRefsGroup.getEjbReferences();
/*  97 */       jbossServiceRefs = jbossEnvironmentRefsGroup.getServiceReferences();
/*  98 */       jbossResRefs = jbossEnvironmentRefsGroup.getResourceReferences();
/*  99 */       jbossResEnvRefs = jbossEnvironmentRefsGroup.getResourceEnvironmentReferences();
/* 100 */       jbossMessageDestinationRefs = jbossEnvironmentRefsGroup.getMessageDestinationReferences();
/*     */     }
/*     */ 
/* 103 */     EJBReferencesMetaData mergedEjbRefs = EJBReferencesMetaData.merge(jbossEjbRefs, ejbRefs, overridenFile, overrideFile, mustOverride);
/* 104 */     if (mergedEjbRefs != null) {
/* 105 */       merged.setEjbReferences(mergedEjbRefs);
/*     */     }
/* 107 */     ServiceReferencesMetaData mergedServiceRefs = ServiceReferencesMetaData.merge(jbossServiceRefs, serviceRefs, overridenFile, overrideFile);
/* 108 */     if (mergedServiceRefs != null) {
/* 109 */       merged.setServiceReferences(mergedServiceRefs);
/*     */     }
/* 111 */     ResourceReferencesMetaData mergedResRefs = ResourceReferencesMetaData.merge(jbossResRefs, resRefs, overridenFile, overrideFile, mustOverride);
/* 112 */     if (mergedResRefs != null) {
/* 113 */       merged.setResourceReferences(mergedResRefs);
/*     */     }
/* 115 */     ResourceEnvironmentReferencesMetaData mergedResEnvRefs = ResourceEnvironmentReferencesMetaData.merge(jbossResEnvRefs, resEnvRefs, overridenFile, overrideFile);
/* 116 */     if (mergedResEnvRefs != null) {
/* 117 */       merged.setResourceEnvironmentReferences(mergedResEnvRefs);
/*     */     }
/* 119 */     MessageDestinationReferencesMetaData mergedMessageDestinationRefs = MessageDestinationReferencesMetaData.merge(jbossMessageDestinationRefs, messageDestinationRefs, overridenFile, overrideFile, mustOverride);
/* 120 */     if (mergedMessageDestinationRefs != null) {
/* 121 */       merged.setMessageDestinationReferences(mergedMessageDestinationRefs);
/*     */     }
/* 123 */     if (envEntries != null) {
/* 124 */       merged.setEnvironmentEntries(envEntries);
/*     */     }
/* 126 */     if (persistenceUnitRefs != null) {
/* 127 */       merged.setPersistenceUnitRefs(persistenceUnitRefs);
/*     */     }
/* 129 */     if (postConstructs != null) {
/* 130 */       merged.setPostConstructs(postConstructs);
/*     */     }
/* 132 */     if (preDestroys != null) {
/* 133 */       merged.setPreDestroys(preDestroys);
/*     */     }
/* 135 */     return merged;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.javaee.jboss.JBossRemoteEnvironmentRefsGroupMetaData
 * JD-Core Version:    0.6.0
 */