/*     */ package org.jboss.metadata.javaee.jboss;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.metadata.javaee.spec.PortComponentRef;
/*     */ 
/*     */ @XmlType(name="port-component-refType")
/*     */ public class JBossPortComponentRef extends PortComponentRef
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private QName portQname;
/*     */   private String configName;
/*     */   private String configFile;
/*     */   private List<StubPropertyMetaData> stubProperties;
/*     */   private List<CallPropertyMetaData> callProperties;
/*     */ 
/*     */   public String getConfigFile()
/*     */   {
/*  69 */     return this.configFile;
/*     */   }
/*     */ 
/*     */   public void setConfigFile(String configFile)
/*     */   {
/*  74 */     this.configFile = configFile;
/*     */   }
/*     */ 
/*     */   public String getConfigName()
/*     */   {
/*  79 */     return this.configName;
/*     */   }
/*     */ 
/*     */   public void setConfigName(String configName)
/*     */   {
/*  84 */     this.configName = configName;
/*     */   }
/*     */ 
/*     */   public QName getPortQname()
/*     */   {
/*  89 */     return this.portQname;
/*     */   }
/*     */ 
/*     */   public void setPortQname(QName portQname)
/*     */   {
/*  94 */     this.portQname = portQname;
/*     */   }
/*     */ 
/*     */   public List<StubPropertyMetaData> getStubProperties()
/*     */   {
/*  99 */     return this.stubProperties;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="stub-property")
/*     */   public void setStubProperties(List<StubPropertyMetaData> stubProperties) {
/* 105 */     this.stubProperties = stubProperties;
/*     */   }
/*     */ 
/*     */   public List<CallPropertyMetaData> getCallProperties()
/*     */   {
/* 110 */     return this.callProperties;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="call-property")
/*     */   public void setCallProperties(List<CallPropertyMetaData> callProperties) {
/* 116 */     this.callProperties = callProperties;
/*     */   }
/*     */ 
/*     */   public JBossPortComponentRef merge(JBossPortComponentRef ref)
/*     */   {
/* 121 */     JBossPortComponentRef merged = new JBossPortComponentRef();
/* 122 */     merged.merge(this, ref);
/* 123 */     return merged;
/*     */   }
/*     */ 
/*     */   public void merge(JBossPortComponentRef override, JBossPortComponentRef original)
/*     */   {
/* 128 */     super.merge(override, original);
/*     */ 
/* 130 */     if ((override != null) && (override.portQname != null))
/* 131 */       this.portQname = override.portQname;
/* 132 */     else if ((original != null) && (original.portQname != null)) {
/* 133 */       this.portQname = original.portQname;
/*     */     }
/* 135 */     if ((override != null) && (override.configName != null))
/* 136 */       this.configName = override.configName;
/* 137 */     else if ((original != null) && (original.configName != null)) {
/* 138 */       this.configName = original.configName;
/*     */     }
/* 140 */     if ((override != null) && (override.configFile != null))
/* 141 */       this.configFile = override.configFile;
/* 142 */     else if ((original != null) && (original.configFile != null)) {
/* 143 */       this.configFile = original.configFile;
/*     */     }
/* 145 */     if (this.stubProperties == null)
/* 146 */       this.stubProperties = new ArrayList();
/* 147 */     if ((override != null) && (override.stubProperties != null))
/* 148 */       this.stubProperties.addAll(override.stubProperties);
/* 149 */     else if ((original != null) && (original.stubProperties != null)) {
/* 150 */       this.stubProperties.addAll(original.stubProperties);
/*     */     }
/* 152 */     if (this.callProperties == null)
/* 153 */       this.callProperties = new ArrayList();
/* 154 */     if ((override != null) && (override.callProperties != null))
/* 155 */       this.callProperties.addAll(override.callProperties);
/* 156 */     else if ((original != null) && (original.callProperties != null))
/* 157 */       this.callProperties.addAll(original.callProperties);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.javaee.jboss.JBossPortComponentRef
 * JD-Core Version:    0.6.0
 */