/*     */ package org.jboss.metadata.ejb.spec;
/*     */ 
/*     */ import javax.ejb.TransactionManagementType;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
/*     */ import org.jboss.metadata.common.ejb.ITimeoutTarget;
/*     */ import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;
/*     */ import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
/*     */ import org.jboss.metadata.javaee.spec.TransactionManagementTypeAdapter;
/*     */ 
/*     */ @XmlType(name="session-beanType")
/*     */ public class SessionBeanMetaData extends EnterpriseBeanMetaData
/*     */   implements ITimeoutTarget
/*     */ {
/*     */   private static final long serialVersionUID = 2093953120735574157L;
/*     */   private String home;
/*     */   private String remote;
/*     */   private String localHome;
/*     */   private String local;
/*     */   private BusinessLocalsMetaData businessLocals;
/*     */   private BusinessRemotesMetaData businessRemotes;
/*     */   private String serviceEndpoint;
/*     */   private SessionType sessionType;
/*     */   private NamedMethodMetaData timeoutMethod;
/*     */   private InitMethodsMetaData initMethods;
/*     */   private RemoveMethodsMetaData removeMethods;
/*     */   private TransactionManagementType transactionType;
/*     */   private AroundInvokesMetaData aroundInvokes;
/*     */   private LifecycleCallbacksMetaData postActivates;
/*     */   private LifecycleCallbacksMetaData prePassivates;
/*     */   private SecurityRoleRefsMetaData securityRoleRefs;
/*     */ 
/*     */   public boolean isSession()
/*     */   {
/* 106 */     return true;
/*     */   }
/*     */ 
/*     */   public String getHome()
/*     */   {
/* 116 */     return this.home;
/*     */   }
/*     */ 
/*     */   public void setHome(String home)
/*     */   {
/* 127 */     if (home == null)
/* 128 */       throw new IllegalArgumentException("Null home");
/* 129 */     this.home = home;
/*     */   }
/*     */ 
/*     */   public String getRemote()
/*     */   {
/* 139 */     return this.remote;
/*     */   }
/*     */ 
/*     */   public void setRemote(String remote)
/*     */   {
/* 150 */     if (remote == null)
/* 151 */       throw new IllegalArgumentException("Null remote");
/* 152 */     this.remote = remote;
/*     */   }
/*     */ 
/*     */   public String getLocalHome()
/*     */   {
/* 162 */     return this.localHome;
/*     */   }
/*     */ 
/*     */   public void setLocalHome(String localHome)
/*     */   {
/* 173 */     if (localHome == null)
/* 174 */       throw new IllegalArgumentException("Null localHome");
/* 175 */     this.localHome = localHome;
/*     */   }
/*     */ 
/*     */   public String getLocal()
/*     */   {
/* 185 */     return this.local;
/*     */   }
/*     */ 
/*     */   public void setLocal(String local)
/*     */   {
/* 196 */     if (local == null)
/* 197 */       throw new IllegalArgumentException("Null local");
/* 198 */     this.local = local;
/*     */   }
/*     */ 
/*     */   public BusinessLocalsMetaData getBusinessLocals()
/*     */   {
/* 208 */     return this.businessLocals;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="business-local", required=false)
/*     */   public void setBusinessLocals(BusinessLocalsMetaData businessLocals)
/*     */   {
/* 220 */     if (businessLocals == null)
/* 221 */       throw new IllegalArgumentException("Null businessLocals");
/* 222 */     this.businessLocals = businessLocals;
/*     */   }
/*     */ 
/*     */   public BusinessRemotesMetaData getBusinessRemotes()
/*     */   {
/* 232 */     return this.businessRemotes;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="business-remote", required=false)
/*     */   public void setBusinessRemotes(BusinessRemotesMetaData businessRemotes)
/*     */   {
/* 244 */     if (businessRemotes == null)
/* 245 */       throw new IllegalArgumentException("Null businessRemotes");
/* 246 */     this.businessRemotes = businessRemotes;
/*     */   }
/*     */ 
/*     */   public String getServiceEndpoint()
/*     */   {
/* 256 */     return this.serviceEndpoint;
/*     */   }
/*     */ 
/*     */   public void setServiceEndpoint(String serviceEndpoint)
/*     */   {
/* 267 */     if (serviceEndpoint == null)
/* 268 */       throw new IllegalArgumentException("Null serviceEndpoint");
/* 269 */     this.serviceEndpoint = serviceEndpoint;
/*     */   }
/*     */ 
/*     */   public SessionType getSessionType()
/*     */   {
/* 279 */     return this.sessionType;
/*     */   }
/*     */ 
/*     */   public void setSessionType(SessionType sessionType)
/*     */   {
/* 290 */     if (sessionType == null)
/* 291 */       throw new IllegalArgumentException("Null sessionType");
/* 292 */     this.sessionType = sessionType;
/*     */   }
/*     */ 
/*     */   public boolean isStateful()
/*     */   {
/* 302 */     if (this.sessionType == null)
/* 303 */       return false;
/* 304 */     return this.sessionType == SessionType.Stateful;
/*     */   }
/*     */ 
/*     */   public boolean isStateless()
/*     */   {
/* 314 */     return !isStateful();
/*     */   }
/*     */ 
/*     */   public NamedMethodMetaData getTimeoutMethod()
/*     */   {
/* 324 */     return this.timeoutMethod;
/*     */   }
/*     */ 
/*     */   @XmlElement(required=false)
/*     */   public void setTimeoutMethod(NamedMethodMetaData timeoutMethod)
/*     */   {
/* 336 */     if (timeoutMethod == null)
/* 337 */       throw new IllegalArgumentException("Null timeoutMethod");
/* 338 */     if ((getSessionType() != null) && (getSessionType() != SessionType.Stateless))
/* 339 */       throw new IllegalStateException("Only statless beans can have timeouts: " + this);
/* 340 */     this.timeoutMethod = timeoutMethod;
/*     */   }
/*     */ 
/*     */   public InitMethodsMetaData getInitMethods()
/*     */   {
/* 350 */     return this.initMethods;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="init-method", required=false)
/*     */   public void setInitMethods(InitMethodsMetaData initMethods)
/*     */   {
/* 362 */     if (initMethods == null)
/* 363 */       throw new IllegalArgumentException("Null initMethods");
/* 364 */     this.initMethods = initMethods;
/*     */   }
/*     */ 
/*     */   public RemoveMethodsMetaData getRemoveMethods()
/*     */   {
/* 374 */     return this.removeMethods;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="remove-method", required=false)
/*     */   public void setRemoveMethods(RemoveMethodsMetaData removeMethods)
/*     */   {
/* 386 */     if (removeMethods == null)
/* 387 */       throw new IllegalArgumentException("Null removeMethods");
/* 388 */     this.removeMethods = removeMethods;
/*     */   }
/*     */ 
/*     */   public TransactionManagementType getTransactionType()
/*     */   {
/* 394 */     return this.transactionType;
/*     */   }
/*     */ 
/*     */   @XmlJavaTypeAdapter(TransactionManagementTypeAdapter.class)
/*     */   public void setTransactionType(TransactionManagementType transactionType)
/*     */   {
/* 406 */     if (transactionType == null)
/* 407 */       throw new IllegalArgumentException("Null transactionType");
/* 408 */     this.transactionType = transactionType;
/*     */   }
/*     */ 
/*     */   public AroundInvokesMetaData getAroundInvokes()
/*     */   {
/* 418 */     return this.aroundInvokes;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="around-invoke", required=false)
/*     */   public void setAroundInvokes(AroundInvokesMetaData aroundInvokes)
/*     */   {
/* 430 */     if (aroundInvokes == null)
/* 431 */       throw new IllegalArgumentException("Null aroundInvokes");
/* 432 */     this.aroundInvokes = aroundInvokes;
/*     */   }
/*     */ 
/*     */   public LifecycleCallbacksMetaData getPostActivates()
/*     */   {
/* 442 */     return this.postActivates;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="post-activate", required=false)
/*     */   public void setPostActivates(LifecycleCallbacksMetaData postActivates)
/*     */   {
/* 454 */     if (postActivates == null)
/* 455 */       throw new IllegalArgumentException("Null postActivates");
/* 456 */     this.postActivates = postActivates;
/*     */   }
/*     */ 
/*     */   public LifecycleCallbacksMetaData getPrePassivates()
/*     */   {
/* 466 */     return this.prePassivates;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="pre-passivate", required=false)
/*     */   public void setPrePassivates(LifecycleCallbacksMetaData prePassivates)
/*     */   {
/* 478 */     if (prePassivates == null)
/* 479 */       throw new IllegalArgumentException("Null prePassivates");
/* 480 */     this.prePassivates = prePassivates;
/*     */   }
/*     */ 
/*     */   public SecurityRoleRefsMetaData getSecurityRoleRefs()
/*     */   {
/* 490 */     return this.securityRoleRefs;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="security-role-ref")
/*     */   public void setSecurityRoleRefs(SecurityRoleRefsMetaData securityRoleRefs)
/*     */   {
/* 502 */     if (securityRoleRefs == null)
/* 503 */       throw new IllegalArgumentException("Null securityRoleRefs");
/* 504 */     this.securityRoleRefs = securityRoleRefs;
/*     */   }
/*     */ 
/*     */   public void merge(EnterpriseBeanMetaData eoverride, EnterpriseBeanMetaData eoriginal)
/*     */   {
/* 510 */     super.merge(eoverride, eoriginal);
/* 511 */     SessionBeanMetaData override = (SessionBeanMetaData)eoverride;
/* 512 */     SessionBeanMetaData original = (SessionBeanMetaData)eoriginal;
/* 513 */     if ((override != null) && (override.home != null))
/* 514 */       setHome(override.home);
/* 515 */     else if ((original != null) && (original.home != null))
/* 516 */       setHome(original.home);
/* 517 */     if ((override != null) && (override.remote != null))
/* 518 */       setRemote(override.remote);
/* 519 */     else if ((original != null) && (original.remote != null))
/* 520 */       setRemote(original.remote);
/* 521 */     if ((override != null) && (override.localHome != null))
/* 522 */       setLocalHome(override.localHome);
/* 523 */     else if ((original != null) && (original.localHome != null))
/* 524 */       setLocalHome(original.localHome);
/* 525 */     if ((override != null) && (override.local != null))
/* 526 */       setLocal(override.local);
/* 527 */     else if ((original != null) && (original.local != null))
/* 528 */       setLocal(original.local);
/* 529 */     if (this.businessLocals == null)
/* 530 */       this.businessLocals = new BusinessLocalsMetaData();
/* 531 */     if ((override != null) && (override.businessLocals != null))
/* 532 */       this.businessLocals.addAll(override.businessLocals);
/* 533 */     if ((original != null) && (original.businessLocals != null))
/* 534 */       this.businessLocals.addAll(original.businessLocals);
/* 535 */     if (this.businessRemotes == null)
/* 536 */       this.businessRemotes = new BusinessRemotesMetaData();
/* 537 */     if ((override != null) && (override.businessRemotes != null))
/* 538 */       this.businessRemotes.addAll(override.businessRemotes);
/* 539 */     if ((original != null) && (original.businessRemotes != null))
/* 540 */       this.businessRemotes.addAll(original.businessRemotes);
/* 541 */     if ((override != null) && (override.serviceEndpoint != null))
/* 542 */       setServiceEndpoint(override.serviceEndpoint);
/* 543 */     else if ((original != null) && (original.serviceEndpoint != null))
/* 544 */       setServiceEndpoint(original.serviceEndpoint);
/* 545 */     if ((override != null) && (override.sessionType != null))
/* 546 */       setSessionType(override.sessionType);
/* 547 */     else if ((original != null) && (original.sessionType != null))
/* 548 */       setSessionType(original.sessionType);
/* 549 */     if ((override != null) && (override.timeoutMethod != null))
/* 550 */       setTimeoutMethod(override.timeoutMethod);
/* 551 */     else if ((original != null) && (original.timeoutMethod != null))
/* 552 */       setTimeoutMethod(original.timeoutMethod);
/* 553 */     if (this.initMethods == null)
/* 554 */       this.initMethods = new InitMethodsMetaData();
/* 555 */     if ((override != null) && (override.initMethods != null))
/* 556 */       this.initMethods.addAll(override.initMethods);
/* 557 */     if ((original != null) && (original.initMethods != null))
/* 558 */       this.initMethods.addAll(original.initMethods);
/* 559 */     if (this.removeMethods == null)
/* 560 */       this.removeMethods = new RemoveMethodsMetaData();
/* 561 */     if ((override != null) && (override.removeMethods != null))
/* 562 */       this.removeMethods.addAll(override.removeMethods);
/* 563 */     if ((original != null) && (original.removeMethods != null))
/* 564 */       this.removeMethods.addAll(original.removeMethods);
/* 565 */     if ((override != null) && (override.transactionType != null))
/* 566 */       setTransactionType(override.transactionType);
/* 567 */     else if ((original != null) && (original.transactionType != null))
/* 568 */       setTransactionType(original.transactionType);
/* 569 */     if (this.aroundInvokes == null)
/* 570 */       this.aroundInvokes = new AroundInvokesMetaData();
/* 571 */     if ((override != null) && (override.aroundInvokes != null))
/* 572 */       this.aroundInvokes.addAll(override.aroundInvokes);
/* 573 */     if ((original != null) && (original.aroundInvokes != null))
/* 574 */       this.aroundInvokes.addAll(original.aroundInvokes);
/* 575 */     if (this.postActivates == null)
/* 576 */       this.postActivates = new LifecycleCallbacksMetaData();
/* 577 */     if ((override != null) && (override.postActivates != null))
/* 578 */       this.postActivates.addAll(override.postActivates);
/* 579 */     if ((original != null) && (original.postActivates != null))
/* 580 */       this.postActivates.addAll(original.postActivates);
/* 581 */     if (this.prePassivates == null)
/* 582 */       this.prePassivates = new LifecycleCallbacksMetaData();
/* 583 */     if ((override != null) && (override.prePassivates != null))
/* 584 */       this.prePassivates.addAll(override.prePassivates);
/* 585 */     if ((original != null) && (original.prePassivates != null))
/* 586 */       this.prePassivates.addAll(original.prePassivates);
/* 587 */     if (this.securityRoleRefs == null)
/* 588 */       this.securityRoleRefs = new SecurityRoleRefsMetaData();
/* 589 */     if ((override != null) && (override.securityRoleRefs != null))
/* 590 */       this.securityRoleRefs.addAll(override.securityRoleRefs);
/* 591 */     if ((original != null) && (original.securityRoleRefs != null))
/* 592 */       this.securityRoleRefs.addAll(original.securityRoleRefs);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.spec.SessionBeanMetaData
 * JD-Core Version:    0.6.0
 */