/*     */ package org.jboss.metadata.ejb.spec;
/*     */ 
/*     */ import java.util.Set;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import org.jboss.metadata.javaee.spec.EmptyMetaData;
/*     */ import org.jboss.metadata.javaee.support.IdMetaDataImplWithDescriptions;
/*     */ 
/*     */ @XmlType(name="method-permissionType")
/*     */ public class MethodPermissionMetaData extends IdMetaDataImplWithDescriptions
/*     */ {
/*     */   private static final long serialVersionUID = -985973586611090108L;
/*     */   private EmptyMetaData unchecked;
/*     */   private Set<String> roles;
/*     */   private MethodsMetaData methods;
/*     */ 
/*     */   public boolean isNotChecked()
/*     */   {
/*  67 */     return this.unchecked != null;
/*     */   }
/*     */ 
/*     */   public EmptyMetaData getUnchecked()
/*     */   {
/*  77 */     return this.unchecked;
/*     */   }
/*     */ 
/*     */   public void setUnchecked(EmptyMetaData unchecked)
/*     */   {
/*  87 */     this.unchecked = unchecked;
/*     */   }
/*     */ 
/*     */   public Set<String> getRoles()
/*     */   {
/*  97 */     return this.roles;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="role-name")
/*     */   public void setRoles(Set<String> roles)
/*     */   {
/* 108 */     this.roles = roles;
/*     */   }
/*     */ 
/*     */   public MethodsMetaData getMethods()
/*     */   {
/* 118 */     return this.methods;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="method")
/*     */   public void setMethods(MethodsMetaData methods)
/*     */   {
/* 130 */     if (methods == null)
/* 131 */       throw new IllegalArgumentException("Null methods");
/* 132 */     this.methods = methods;
/*     */   }
/*     */ 
/*     */   public MethodPermissionMetaData getMethodPermissionByEjbName(String ejbName)
/*     */   {
/* 144 */     if (ejbName == null) {
/* 145 */       throw new IllegalArgumentException("Null ejbName");
/*     */     }
/* 147 */     if (this.methods == null) {
/* 148 */       return null;
/*     */     }
/* 150 */     MethodsMetaData ejbMethods = this.methods.getMethodsByEjbName(ejbName);
/* 151 */     if (ejbMethods == null) {
/* 152 */       return null;
/*     */     }
/* 154 */     MethodPermissionMetaData result = clone();
/* 155 */     result.setMethods(ejbMethods);
/* 156 */     return result;
/*     */   }
/*     */ 
/*     */   public MethodPermissionMetaData clone()
/*     */   {
/* 162 */     return (MethodPermissionMetaData)super.clone();
/*     */   }
/*     */ 
/*     */   public boolean matches(String methodName, Class[] params, MethodInterfaceType interfaceType)
/*     */   {
/* 175 */     if (this.methods == null)
/* 176 */       return false;
/* 177 */     return this.methods.matches(methodName, params, interfaceType);
/*     */   }
/*     */ 
/*     */   public boolean isNotChecked(String methodName, Class[] params, MethodInterfaceType interfaceType)
/*     */   {
/* 190 */     if (!isNotChecked())
/* 191 */       return false;
/* 192 */     return matches(methodName, params, interfaceType);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 198 */     StringBuilder tmp = new StringBuilder("MethodPermissionMetaData(id=");
/* 199 */     tmp.append(getId());
/* 200 */     if (isNotChecked())
/*     */     {
/* 202 */       tmp.append(",unchecked=true");
/*     */     }
/*     */     else
/*     */     {
/* 206 */       tmp.append(",roles=");
/* 207 */       tmp.append(this.roles);
/*     */     }
/* 209 */     tmp.append(",methods=");
/* 210 */     tmp.append(this.methods);
/* 211 */     tmp.append(')');
/* 212 */     return tmp.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.spec.MethodPermissionMetaData
 * JD-Core Version:    0.6.0
 */