/*     */ package org.jboss.metadata.ejb.spec;
/*     */ 
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import org.jboss.metadata.javaee.support.IdMetaDataImplWithDescriptions;
/*     */ 
/*     */ @XmlType(name="methodType")
/*     */ public class MethodMetaData extends IdMetaDataImplWithDescriptions
/*     */ {
/*     */   private static final long serialVersionUID = -985973586611090108L;
/*     */   private String ejbName;
/*     */   private MethodInterfaceType methodInterface;
/*     */   private String methodName;
/*     */   private MethodParametersMetaData methodParams;
/*     */ 
/*     */   public String getEjbName()
/*     */   {
/*  67 */     return this.ejbName;
/*     */   }
/*     */ 
/*     */   public void setEjbName(String ejbName)
/*     */   {
/*  78 */     if (ejbName == null)
/*  79 */       throw new IllegalArgumentException("Null ejbName");
/*  80 */     this.ejbName = ejbName;
/*     */   }
/*     */ 
/*     */   public MethodInterfaceType getMethodIntf()
/*     */   {
/*  90 */     return this.methodInterface;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="method-intf")
/*     */   public void setMethodIntf(MethodInterfaceType methodInterface)
/*     */   {
/* 102 */     if (methodInterface == null)
/* 103 */       throw new IllegalArgumentException("Null methodInterface");
/* 104 */     this.methodInterface = methodInterface;
/*     */   }
/*     */ 
/*     */   public String getMethodName()
/*     */   {
/* 114 */     return this.methodName;
/*     */   }
/*     */ 
/*     */   public void setMethodName(String methodName)
/*     */   {
/* 125 */     if (methodName == null)
/* 126 */       throw new IllegalArgumentException("Null methodName");
/* 127 */     this.methodName = methodName;
/*     */   }
/*     */ 
/*     */   public MethodParametersMetaData getMethodParams()
/*     */   {
/* 137 */     return this.methodParams;
/*     */   }
/*     */ 
/*     */   public void setMethodParams(MethodParametersMetaData methodParams)
/*     */   {
/* 151 */     if (methodParams == null)
/* 152 */       throw new IllegalArgumentException("Null methodParams");
/* 153 */     this.methodParams = methodParams;
/*     */   }
/*     */ 
/*     */   public boolean matches(String methodName, String[] params, MethodInterfaceType interfaceType)
/*     */   {
/* 166 */     if (methodName == null) {
/* 167 */       throw new IllegalArgumentException("Null methodName");
/*     */     }
/*     */ 
/* 170 */     if ((this.methodInterface != null) && (this.methodInterface != interfaceType)) {
/* 171 */       return false;
/*     */     }
/*     */ 
/* 174 */     if (getMethodName().equals("*")) {
/* 175 */       return true;
/*     */     }
/*     */ 
/* 178 */     if (!getMethodName().equals(methodName)) {
/* 179 */       return false;
/*     */     }
/*     */ 
/* 182 */     if (this.methodParams == null) {
/* 183 */       return true;
/*     */     }
/*     */ 
/* 186 */     if ((params == null) && (this.methodParams.size() > 0))
/* 187 */       return false;
/* 188 */     if ((params != null) && (params.length != this.methodParams.size())) {
/* 189 */       return false;
/*     */     }
/*     */ 
/* 192 */     int i = 0;
/* 193 */     for (String param : this.methodParams)
/*     */     {
/* 195 */       if (!param.equals(params[(i++)])) {
/* 196 */         return false;
/*     */       }
/*     */     }
/*     */ 
/* 200 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isHomeMethod()
/*     */   {
/* 210 */     return MethodInterfaceType.Home == this.methodInterface;
/*     */   }
/*     */ 
/*     */   public boolean isRemoteMethod()
/*     */   {
/* 220 */     return MethodInterfaceType.Remote == this.methodInterface;
/*     */   }
/*     */ 
/*     */   public boolean isLocalHomeMethod()
/*     */   {
/* 230 */     return MethodInterfaceType.LocalHome == this.methodInterface;
/*     */   }
/*     */ 
/*     */   public boolean isLocalMethod()
/*     */   {
/* 240 */     return MethodInterfaceType.Local == this.methodInterface;
/*     */   }
/*     */ 
/*     */   public boolean isServiceEndpointMethod()
/*     */   {
/* 250 */     return MethodInterfaceType.ServiceEndpoint == this.methodInterface;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 256 */     StringBuilder tmp = new StringBuilder("MethodMetaData(");
/* 257 */     tmp.append("ejbName=");
/* 258 */     tmp.append(this.ejbName);
/* 259 */     tmp.append(",interface=");
/* 260 */     tmp.append(this.methodInterface);
/* 261 */     tmp.append(",method=");
/* 262 */     tmp.append(this.methodName);
/* 263 */     tmp.append(",params=");
/* 264 */     tmp.append(this.methodParams);
/* 265 */     tmp.append(')');
/* 266 */     return tmp.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.spec.MethodMetaData
 * JD-Core Version:    0.6.0
 */