/*     */ package org.jboss.metadata.ejb.spec;
/*     */ 
/*     */ import javax.ejb.TransactionManagementType;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
/*     */ import org.jboss.metadata.common.ejb.ITimeoutTarget;
/*     */ import org.jboss.metadata.javaee.spec.TransactionManagementTypeAdapter;
/*     */ 
/*     */ @XmlType(name="message-driven-beanType")
/*     */ public class MessageDrivenBeanMetaData extends EnterpriseBeanMetaData
/*     */   implements ITimeoutTarget
/*     */ {
/*     */   private static final long serialVersionUID = -7353017099819838715L;
/*     */   private String messagingType;
/*     */   private NamedMethodMetaData timeoutMethod;
/*     */   private TransactionManagementType transactionType;
/*     */   private String messageDestinationType;
/*     */   private String messageDestinationLink;
/*     */   private ActivationConfigMetaData activationConfig;
/*     */   private AroundInvokesMetaData aroundInvokes;
/*     */   private String messageSelector;
/*     */   private String acknowledgeMode;
/*  74 */   private SubscriptionDurability subscriptionDurability = SubscriptionDurability.NonDurable;
/*     */ 
/*     */   public boolean isMessageDriven()
/*     */   {
/*  87 */     return true;
/*     */   }
/*     */ 
/*     */   public String getMessagingType()
/*     */   {
/*  98 */     return this.messagingType;
/*     */   }
/*     */ 
/*     */   public boolean isJMS()
/*     */   {
/* 108 */     String messagingType = getMessagingType();
/* 109 */     return (messagingType == null) || ("javax.jms.MessageListener".equals(messagingType));
/*     */   }
/*     */ 
/*     */   public void setMessagingType(String messagingType)
/*     */   {
/* 121 */     if (messagingType == null)
/* 122 */       throw new IllegalArgumentException("Null messagingType");
/* 123 */     this.messagingType = messagingType;
/*     */   }
/*     */ 
/*     */   public NamedMethodMetaData getTimeoutMethod()
/*     */   {
/* 134 */     return this.timeoutMethod;
/*     */   }
/*     */ 
/*     */   @XmlElement(required=false)
/*     */   public void setTimeoutMethod(NamedMethodMetaData timeoutMethod)
/*     */   {
/* 147 */     if (timeoutMethod == null)
/* 148 */       throw new IllegalArgumentException("Null timeoutMethod");
/* 149 */     this.timeoutMethod = timeoutMethod;
/*     */   }
/*     */ 
/*     */   public TransactionManagementType getTransactionType()
/*     */   {
/* 156 */     return this.transactionType;
/*     */   }
/*     */ 
/*     */   @XmlJavaTypeAdapter(TransactionManagementTypeAdapter.class)
/*     */   public void setTransactionType(TransactionManagementType transactionType)
/*     */   {
/* 169 */     if (transactionType == null)
/* 170 */       throw new IllegalArgumentException("Null transactionType");
/* 171 */     this.transactionType = transactionType;
/*     */   }
/*     */ 
/*     */   public String getMessageDestinationType()
/*     */   {
/* 182 */     return this.messageDestinationType;
/*     */   }
/*     */ 
/*     */   public void setMessageDestinationType(String messageDestinationType)
/*     */   {
/* 194 */     if (messageDestinationType == null)
/* 195 */       throw new IllegalArgumentException("Null messageDestinationType");
/* 196 */     this.messageDestinationType = messageDestinationType;
/*     */   }
/*     */ 
/*     */   public AroundInvokesMetaData getAroundInvokes()
/*     */   {
/* 207 */     return this.aroundInvokes;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="around-invoke", required=false)
/*     */   public void setAroundInvokes(AroundInvokesMetaData aroundInvokes)
/*     */   {
/* 220 */     if (aroundInvokes == null)
/* 221 */       throw new IllegalArgumentException("Null aroundInvokes");
/* 222 */     this.aroundInvokes = aroundInvokes;
/*     */   }
/*     */ 
/*     */   public String getMessageDestinationLink()
/*     */   {
/* 233 */     return this.messageDestinationLink;
/*     */   }
/*     */ 
/*     */   public void setMessageDestinationLink(String messageDestinationLink)
/*     */   {
/* 245 */     if (messageDestinationLink == null)
/* 246 */       throw new IllegalArgumentException("Null messageDestinationLink");
/* 247 */     this.messageDestinationLink = messageDestinationLink;
/*     */   }
/*     */ 
/*     */   public ActivationConfigMetaData getActivationConfig()
/*     */   {
/* 258 */     return this.activationConfig;
/*     */   }
/*     */ 
/*     */   public void setActivationConfig(ActivationConfigMetaData activationConfig)
/*     */   {
/* 270 */     if (activationConfig == null)
/* 271 */       throw new IllegalArgumentException("Null activationConfig");
/* 272 */     this.activationConfig = activationConfig;
/*     */   }
/*     */ 
/*     */   public String getMessageSelector()
/*     */   {
/* 282 */     return this.messageSelector;
/*     */   }
/*     */ 
/*     */   @XmlElement(required=false)
/*     */   public void setMessageSelector(String messageSelector)
/*     */   {
/* 294 */     if (messageSelector == null)
/* 295 */       throw new IllegalArgumentException("Null messageSelector");
/* 296 */     this.messageSelector = messageSelector;
/*     */   }
/*     */ 
/*     */   public String getAcknowledgeMode()
/*     */   {
/* 306 */     return this.acknowledgeMode;
/*     */   }
/*     */ 
/*     */   @XmlElement(required=false)
/*     */   public void setAcknowledgeMode(String acknowledgeMode)
/*     */   {
/* 318 */     if (acknowledgeMode == null)
/* 319 */       throw new IllegalArgumentException("Null acknowledgeMode");
/* 320 */     this.acknowledgeMode = acknowledgeMode;
/*     */   }
/*     */ 
/*     */   public SubscriptionDurability getSubscriptionDurability()
/*     */   {
/* 330 */     return this.subscriptionDurability;
/*     */   }
/*     */ 
/*     */   @XmlElement(required=false)
/*     */   public void setSubscriptionDurability(SubscriptionDurability subscriptionDurability)
/*     */   {
/* 342 */     if (subscriptionDurability == null)
/* 343 */       throw new IllegalArgumentException("Null subscriptionDurability");
/* 344 */     this.subscriptionDurability = subscriptionDurability;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="message-driven-destination", required=false)
/*     */   public void setMessageDrivenDestination(MessageDrivenDestinationMetaData mdd)
/*     */   {
/* 351 */     setMessageDestinationType(mdd.getDestinationType());
/* 352 */     String durability = mdd.getSubscriptionDurability();
/* 353 */     SubscriptionDurability sd = SubscriptionDurability.NonDurable;
/* 354 */     if ((durability != null) && (durability.equalsIgnoreCase("Durable")))
/* 355 */       sd = SubscriptionDurability.Durable;
/* 356 */     setSubscriptionDurability(sd);
/*     */   }
/*     */ 
/*     */   public void merge(EnterpriseBeanMetaData override, EnterpriseBeanMetaData original)
/*     */   {
/* 362 */     merge((MessageDrivenBeanMetaData)override, (MessageDrivenBeanMetaData)original);
/*     */   }
/*     */ 
/*     */   public void merge(MessageDrivenBeanMetaData override, MessageDrivenBeanMetaData original)
/*     */   {
/* 367 */     super.merge(override, original);
/*     */ 
/* 369 */     if ((override != null) && (override.acknowledgeMode != null))
/* 370 */       this.acknowledgeMode = override.acknowledgeMode;
/* 371 */     else if (original != null) {
/* 372 */       this.acknowledgeMode = original.acknowledgeMode;
/*     */     }
/* 374 */     if (((override != null) && (override.activationConfig != null)) || ((original != null) && (original.activationConfig != null)))
/*     */     {
/* 376 */       this.activationConfig = new ActivationConfigMetaData();
/* 377 */       this.activationConfig.merge(override != null ? override.activationConfig : null, original != null ? original.activationConfig : null);
/*     */     }
/*     */ 
/* 380 */     if (((override != null) && (override.aroundInvokes != null)) || ((original != null) && (original.aroundInvokes != null)))
/*     */     {
/* 382 */       this.aroundInvokes = new AroundInvokesMetaData();
/* 383 */       this.aroundInvokes.merge(override != null ? override.aroundInvokes : null, original != null ? original.aroundInvokes : null);
/*     */     }
/*     */ 
/* 386 */     if ((override != null) && (override.messageDestinationLink != null))
/* 387 */       this.messageDestinationLink = override.messageDestinationLink;
/* 388 */     else if (original != null) {
/* 389 */       this.messageDestinationLink = original.messageDestinationLink;
/*     */     }
/* 391 */     if ((override != null) && (override.messageDestinationType != null))
/* 392 */       this.messageDestinationType = override.messageDestinationType;
/* 393 */     else if (original != null) {
/* 394 */       this.messageDestinationType = original.messageDestinationType;
/*     */     }
/* 396 */     if ((override != null) && (override.messageSelector != null))
/* 397 */       this.messageSelector = override.messageSelector;
/* 398 */     else if (original != null) {
/* 399 */       this.messageSelector = original.messageSelector;
/*     */     }
/* 401 */     if ((override != null) && (override.messagingType != null))
/* 402 */       this.messagingType = override.messagingType;
/* 403 */     else if (original != null) {
/* 404 */       this.messagingType = original.messagingType;
/*     */     }
/* 406 */     if ((override != null) && (override.subscriptionDurability != null))
/* 407 */       this.subscriptionDurability = override.subscriptionDurability;
/* 408 */     else if (original != null) {
/* 409 */       this.subscriptionDurability = original.subscriptionDurability;
/*     */     }
/* 411 */     if ((override != null) && (override.timeoutMethod != null))
/* 412 */       this.timeoutMethod = override.timeoutMethod;
/* 413 */     else if (original != null) {
/* 414 */       this.timeoutMethod = original.timeoutMethod;
/*     */     }
/* 416 */     if ((override != null) && (override.transactionType != null))
/* 417 */       this.transactionType = override.transactionType;
/* 418 */     else if (original != null)
/* 419 */       this.transactionType = original.transactionType;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.spec.MessageDrivenBeanMetaData
 * JD-Core Version:    0.6.0
 */