/*     */ package org.jboss.metadata.ejb.spec;
/*     */ 
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlTransient;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import org.jboss.metadata.javaee.support.NamedMetaDataWithDescriptions;
/*     */ 
/*     */ @XmlType(name="interceptor-bindingType")
/*     */ public class InterceptorBindingMetaData extends NamedMetaDataWithDescriptions
/*     */ {
/*     */   private static final long serialVersionUID = 3265594088830429912L;
/*     */   private InterceptorClassesMetaData interceptorClasses;
/*     */   private InterceptorOrderMetaData interceptorOrder;
/*  48 */   private boolean excludeDefaultInterceptors = false;
/*     */ 
/*  51 */   private boolean excludeClassInterceptors = false;
/*     */   private NamedMethodMetaData method;
/*     */ 
/*     */   public String getEjbName()
/*     */   {
/*  71 */     return getName();
/*     */   }
/*     */ 
/*     */   public void setEjbName(String ejbName)
/*     */   {
/*  82 */     setName(ejbName);
/*     */   }
/*     */ 
/*     */   public boolean isExcludeClassInterceptors()
/*     */   {
/*  92 */     return this.excludeClassInterceptors;
/*     */   }
/*     */ 
/*     */   public void setExcludeClassInterceptors(boolean excludeClassInterceptors)
/*     */   {
/* 102 */     this.excludeClassInterceptors = excludeClassInterceptors;
/*     */   }
/*     */ 
/*     */   public boolean isExcludeDefaultInterceptors()
/*     */   {
/* 112 */     return this.excludeDefaultInterceptors;
/*     */   }
/*     */ 
/*     */   public void setExcludeDefaultInterceptors(boolean excludeDefaultInterceptors)
/*     */   {
/* 122 */     this.excludeDefaultInterceptors = excludeDefaultInterceptors;
/*     */   }
/*     */ 
/*     */   public InterceptorClassesMetaData getInterceptorClasses()
/*     */   {
/* 132 */     return this.interceptorClasses;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="interceptor-class")
/*     */   public void setInterceptorClasses(InterceptorClassesMetaData interceptorClasses)
/*     */   {
/* 144 */     if (interceptorClasses == null) {
/* 145 */       throw new IllegalArgumentException("Null interceptorClasses");
/*     */     }
/* 147 */     assert (this.interceptorOrder == null) : "Can't have both interceptorClasses and interceptorOrder";
/*     */ 
/* 149 */     this.interceptorClasses = interceptorClasses;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public boolean isTotalOrdering()
/*     */   {
/* 159 */     return this.interceptorOrder != null;
/*     */   }
/*     */ 
/*     */   public InterceptorOrderMetaData getInterceptorOrder()
/*     */   {
/* 169 */     return this.interceptorOrder;
/*     */   }
/*     */ 
/*     */   public void setInterceptorOrder(InterceptorOrderMetaData interceptorOrder)
/*     */   {
/* 180 */     if (interceptorOrder == null) {
/* 181 */       throw new IllegalArgumentException("Null interceptorOrder");
/*     */     }
/* 183 */     assert (this.interceptorClasses == null) : "Can't have both interceptorOrder and interceptorClasses";
/*     */ 
/* 185 */     this.interceptorOrder = interceptorOrder;
/*     */   }
/*     */ 
/*     */   public NamedMethodMetaData getMethod()
/*     */   {
/* 195 */     return this.method;
/*     */   }
/*     */ 
/*     */   public void setMethod(NamedMethodMetaData method)
/*     */   {
/* 206 */     if (method == null)
/* 207 */       throw new IllegalArgumentException("Null method");
/* 208 */     this.method = method;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.spec.InterceptorBindingMetaData
 * JD-Core Version:    0.6.0
 */