/*     */ package org.jboss.metadata.ejb.spec;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import javax.ejb.TransactionAttributeType;
/*     */ import javax.ejb.TransactionManagementType;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlTransient;
/*     */ import org.jboss.metadata.common.ejb.IAssemblyDescriptorMetaData;
/*     */ import org.jboss.metadata.common.ejb.IEnterpriseBeanMetaData;
/*     */ import org.jboss.metadata.javaee.spec.AnnotatedEJBReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBLocalReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBLocalReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.Environment;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
/*     */ import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PersistenceContextReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PersistenceContextReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PersistenceUnitReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PersistenceUnitReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.support.AbstractMappedMetaData;
/*     */ import org.jboss.metadata.javaee.support.NamedMetaDataWithDescriptionGroup;
/*     */ import org.jboss.xb.annotations.JBossXmlModelGroup;
/*     */ 
/*     */ @JBossXmlModelGroup(kind="choice", particles={@org.jboss.xb.annotations.JBossXmlModelGroup.Particle(element=@XmlElement(name="session"), type=SessionBeanMetaData.class), @org.jboss.xb.annotations.JBossXmlModelGroup.Particle(element=@XmlElement(name="entity"), type=EntityBeanMetaData.class), @org.jboss.xb.annotations.JBossXmlModelGroup.Particle(element=@XmlElement(name="message-driven"), type=MessageDrivenBeanMetaData.class)})
/*     */ public abstract class EnterpriseBeanMetaData extends NamedMetaDataWithDescriptionGroup
/*     */   implements Environment, IEnterpriseBeanMetaData<AssemblyDescriptorMetaData, EnterpriseBeansMetaData, EnterpriseBeanMetaData, EjbJarMetaData>
/*     */ {
/*     */   private static final long serialVersionUID = -10005320902508914L;
/*     */   private EnterpriseBeansMetaData enterpriseBeansMetaData;
/*     */   private String mappedName;
/*     */   private String ejbClass;
/*     */   private EnvironmentRefsGroupMetaData jndiEnvironmentRefsGroup;
/*     */   private SecurityIdentityMetaData securityIdentity;
/*     */   private transient ContainerTransactionsMetaData cachedContainerTransactions;
/*     */   private transient ConcurrentHashMap<Method, TransactionAttributeType> methodTx;
/*     */ 
/*     */   public static EnterpriseBeanMetaData newBean(EnterpriseBeanMetaData bean)
/*     */   {
/* 110 */     EnterpriseBeanMetaData nbean = null;
/* 111 */     if ((bean instanceof EntityBeanMetaData))
/* 112 */       nbean = new EntityBeanMetaData();
/* 113 */     if ((bean instanceof MessageDrivenBeanMetaData))
/* 114 */       nbean = new MessageDrivenBeanMetaData();
/* 115 */     if ((bean instanceof SessionBeanMetaData))
/* 116 */       nbean = new SessionBeanMetaData();
/* 117 */     return nbean;
/*     */   }
/*     */ 
/*     */   public EnterpriseBeansMetaData getEnterpriseBeansMetaData()
/*     */   {
/* 130 */     return this.enterpriseBeansMetaData;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public void setEnterpriseBeansMetaData(EnterpriseBeansMetaData enterpriseBeansMetaData)
/*     */   {
/* 141 */     this.enterpriseBeansMetaData = enterpriseBeansMetaData;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public EjbJarMetaData getEjbJarMetaData()
/*     */   {
/* 152 */     if (this.enterpriseBeansMetaData == null)
/* 153 */       return null;
/* 154 */     return this.enterpriseBeansMetaData.getEjbJarMetaData();
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public AssemblyDescriptorMetaData getAssemblyDescriptor()
/*     */   {
/* 165 */     EjbJarMetaData ejbJar = getEjbJarMetaData();
/* 166 */     if (ejbJar == null)
/* 167 */       return null;
/* 168 */     return ejbJar.getAssemblyDescriptor();
/*     */   }
/*     */ 
/*     */   public String getEjbName()
/*     */   {
/* 178 */     return getName();
/*     */   }
/*     */ 
/*     */   public void setEjbName(String ejbName)
/*     */   {
/* 189 */     setName(ejbName);
/*     */   }
/*     */ 
/*     */   public boolean isSession()
/*     */   {
/* 199 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isMessageDriven()
/*     */   {
/* 209 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isEntity()
/*     */   {
/* 219 */     return false;
/*     */   }
/*     */ 
/*     */   public TransactionManagementType getTransactionType()
/*     */   {
/* 229 */     return TransactionManagementType.CONTAINER;
/*     */   }
/*     */ 
/*     */   public boolean isCMT()
/*     */   {
/* 239 */     TransactionManagementType type = getTransactionType();
/* 240 */     if (type == null) {
/* 241 */       return true;
/*     */     }
/* 243 */     return type == TransactionManagementType.CONTAINER;
/*     */   }
/*     */ 
/*     */   public boolean isBMT()
/*     */   {
/* 253 */     return !isCMT();
/*     */   }
/*     */ 
/*     */   public String getMappedName()
/*     */   {
/* 263 */     return this.mappedName;
/*     */   }
/*     */ 
/*     */   @XmlElement(required=false)
/*     */   public void setMappedName(String mappedName)
/*     */   {
/* 275 */     if (mappedName == null)
/* 276 */       throw new IllegalArgumentException("Null mappedName");
/* 277 */     this.mappedName = mappedName;
/*     */   }
/*     */ 
/*     */   public String getEjbClass()
/*     */   {
/* 287 */     return this.ejbClass;
/*     */   }
/*     */ 
/*     */   public void setEjbClass(String ejbClass)
/*     */   {
/* 298 */     if (ejbClass == null)
/* 299 */       throw new IllegalArgumentException("Null ejbClass");
/* 300 */     this.ejbClass = ejbClass;
/*     */   }
/*     */ 
/*     */   public Environment getJndiEnvironmentRefsGroup()
/*     */   {
/* 310 */     return this.jndiEnvironmentRefsGroup;
/*     */   }
/*     */ 
/*     */   @XmlElement(type=EnvironmentRefsGroupMetaData.class)
/*     */   public void setJndiEnvironmentRefsGroup(Environment jndiEnvironmentRefsGroup)
/*     */   {
/* 322 */     if (jndiEnvironmentRefsGroup == null)
/* 323 */       throw new IllegalArgumentException("Null jndiEnvironmentRefsGroup");
/* 324 */     this.jndiEnvironmentRefsGroup = ((EnvironmentRefsGroupMetaData)jndiEnvironmentRefsGroup);
/*     */   }
/*     */ 
/*     */   public SecurityIdentityMetaData getSecurityIdentity()
/*     */   {
/* 334 */     return this.securityIdentity;
/*     */   }
/*     */ 
/*     */   public void setSecurityIdentity(SecurityIdentityMetaData securityIdentity)
/*     */   {
/* 345 */     if (securityIdentity == null)
/* 346 */       throw new IllegalArgumentException("Null securityIdentity");
/* 347 */     this.securityIdentity = securityIdentity;
/*     */   }
/*     */ 
/*     */   public EJBLocalReferenceMetaData getEjbLocalReferenceByName(String name)
/*     */   {
/* 352 */     return (EJBLocalReferenceMetaData)AbstractMappedMetaData.getByName(name, getEjbLocalReferences());
/*     */   }
/*     */ 
/*     */   public EJBLocalReferencesMetaData getEjbLocalReferences()
/*     */   {
/* 357 */     if (this.jndiEnvironmentRefsGroup != null)
/* 358 */       return this.jndiEnvironmentRefsGroup.getEjbLocalReferences();
/* 359 */     return null;
/*     */   }
/*     */ 
/*     */   public EJBReferenceMetaData getEjbReferenceByName(String name)
/*     */   {
/* 364 */     return (EJBReferenceMetaData)AbstractMappedMetaData.getByName(name, getEjbReferences());
/*     */   }
/*     */ 
/*     */   public EJBReferencesMetaData getEjbReferences()
/*     */   {
/* 369 */     if (this.jndiEnvironmentRefsGroup != null)
/* 370 */       return this.jndiEnvironmentRefsGroup.getEjbReferences();
/* 371 */     return null;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public AnnotatedEJBReferencesMetaData getAnnotatedEjbReferences() {
/* 377 */     if (this.jndiEnvironmentRefsGroup != null)
/* 378 */       return this.jndiEnvironmentRefsGroup.getAnnotatedEjbReferences();
/* 379 */     return null;
/*     */   }
/*     */ 
/*     */   public EnvironmentEntriesMetaData getEnvironmentEntries()
/*     */   {
/* 384 */     if (this.jndiEnvironmentRefsGroup != null)
/* 385 */       return this.jndiEnvironmentRefsGroup.getEnvironmentEntries();
/* 386 */     return null;
/*     */   }
/*     */ 
/*     */   public EnvironmentEntryMetaData getEnvironmentEntryByName(String name)
/*     */   {
/* 391 */     return (EnvironmentEntryMetaData)AbstractMappedMetaData.getByName(name, getEnvironmentEntries());
/*     */   }
/*     */ 
/*     */   public MessageDestinationReferenceMetaData getMessageDestinationReferenceByName(String name)
/*     */   {
/* 396 */     return (MessageDestinationReferenceMetaData)AbstractMappedMetaData.getByName(name, getMessageDestinationReferences());
/*     */   }
/*     */ 
/*     */   public MessageDestinationReferencesMetaData getMessageDestinationReferences()
/*     */   {
/* 401 */     if (this.jndiEnvironmentRefsGroup != null)
/* 402 */       return this.jndiEnvironmentRefsGroup.getMessageDestinationReferences();
/* 403 */     return null;
/*     */   }
/*     */ 
/*     */   public PersistenceContextReferenceMetaData getPersistenceContextReferenceByName(String name)
/*     */   {
/* 408 */     return (PersistenceContextReferenceMetaData)AbstractMappedMetaData.getByName(name, getPersistenceContextRefs());
/*     */   }
/*     */ 
/*     */   public PersistenceContextReferencesMetaData getPersistenceContextRefs()
/*     */   {
/* 413 */     if (this.jndiEnvironmentRefsGroup != null)
/* 414 */       return this.jndiEnvironmentRefsGroup.getPersistenceContextRefs();
/* 415 */     return null;
/*     */   }
/*     */ 
/*     */   public PersistenceUnitReferenceMetaData getPersistenceUnitReferenceByName(String name)
/*     */   {
/* 420 */     return (PersistenceUnitReferenceMetaData)AbstractMappedMetaData.getByName(name, getPersistenceUnitRefs());
/*     */   }
/*     */ 
/*     */   public PersistenceUnitReferencesMetaData getPersistenceUnitRefs()
/*     */   {
/* 425 */     if (this.jndiEnvironmentRefsGroup != null)
/* 426 */       return this.jndiEnvironmentRefsGroup.getPersistenceUnitRefs();
/* 427 */     return null;
/*     */   }
/*     */ 
/*     */   public LifecycleCallbacksMetaData getPostConstructs()
/*     */   {
/* 432 */     if (this.jndiEnvironmentRefsGroup != null)
/* 433 */       return this.jndiEnvironmentRefsGroup.getPostConstructs();
/* 434 */     return null;
/*     */   }
/*     */ 
/*     */   public LifecycleCallbacksMetaData getPreDestroys()
/*     */   {
/* 439 */     if (this.jndiEnvironmentRefsGroup != null)
/* 440 */       return this.jndiEnvironmentRefsGroup.getPreDestroys();
/* 441 */     return null;
/*     */   }
/*     */ 
/*     */   public ResourceEnvironmentReferenceMetaData getResourceEnvironmentReferenceByName(String name)
/*     */   {
/* 446 */     return (ResourceEnvironmentReferenceMetaData)AbstractMappedMetaData.getByName(name, getResourceEnvironmentReferences());
/*     */   }
/*     */ 
/*     */   public ResourceEnvironmentReferencesMetaData getResourceEnvironmentReferences()
/*     */   {
/* 451 */     if (this.jndiEnvironmentRefsGroup != null)
/* 452 */       return this.jndiEnvironmentRefsGroup.getResourceEnvironmentReferences();
/* 453 */     return null;
/*     */   }
/*     */ 
/*     */   public ResourceReferenceMetaData getResourceReferenceByName(String name)
/*     */   {
/* 458 */     return (ResourceReferenceMetaData)AbstractMappedMetaData.getByName(name, getResourceReferences());
/*     */   }
/*     */ 
/*     */   public ResourceReferencesMetaData getResourceReferences()
/*     */   {
/* 463 */     if (this.jndiEnvironmentRefsGroup != null)
/* 464 */       return this.jndiEnvironmentRefsGroup.getResourceReferences();
/* 465 */     return null;
/*     */   }
/*     */ 
/*     */   public ServiceReferenceMetaData getServiceReferenceByName(String name)
/*     */   {
/* 470 */     return (ServiceReferenceMetaData)AbstractMappedMetaData.getByName(name, getServiceReferences());
/*     */   }
/*     */ 
/*     */   public ServiceReferencesMetaData getServiceReferences()
/*     */   {
/* 475 */     if (this.jndiEnvironmentRefsGroup != null)
/* 476 */       return this.jndiEnvironmentRefsGroup.getServiceReferences();
/* 477 */     return null;
/*     */   }
/*     */ 
/*     */   public MethodPermissionsMetaData getMethodPermissions()
/*     */   {
/* 487 */     IAssemblyDescriptorMetaData assemblyDescriptor = getAssemblyDescriptor();
/* 488 */     if (assemblyDescriptor == null)
/* 489 */       return null;
/* 490 */     return assemblyDescriptor.getMethodPermissionsByEjbName(getEjbName());
/*     */   }
/*     */ 
/*     */   public ContainerTransactionsMetaData getContainerTransactions()
/*     */   {
/* 500 */     if (this.cachedContainerTransactions != null)
/* 501 */       return this.cachedContainerTransactions;
/* 502 */     IAssemblyDescriptorMetaData assemblyDescriptor = getAssemblyDescriptor();
/* 503 */     if (assemblyDescriptor == null)
/* 504 */       return null;
/* 505 */     return assemblyDescriptor.getContainerTransactionsByEjbName(getEjbName());
/*     */   }
/*     */ 
/*     */   public TransactionAttributeType getMethodTransactionType(String methodName, Class<?>[] params, MethodInterfaceType iface)
/*     */   {
/* 519 */     TransactionAttributeType result = null;
/*     */ 
/* 521 */     ContainerTransactionsMetaData containerTransactions = getContainerTransactions();
/* 522 */     if ((containerTransactions == null) || (containerTransactions.isEmpty())) {
/* 523 */       return result;
/*     */     }
/* 525 */     ContainerTransactionMetaData bestMatchTransaction = null;
/* 526 */     MethodMetaData bestMatch = null;
/* 527 */     for (ContainerTransactionMetaData transaction : containerTransactions)
/*     */     {
/* 529 */       MethodMetaData match = transaction.bestMatch(methodName, params, iface, bestMatch);
/* 530 */       if (match != bestMatch)
/*     */       {
/* 532 */         bestMatchTransaction = transaction;
/* 533 */         bestMatch = match;
/*     */       }
/*     */     }
/*     */ 
/* 537 */     if (bestMatchTransaction != null) {
/* 538 */       result = bestMatchTransaction.getTransAttribute();
/*     */     }
/* 540 */     return result;
/*     */   }
/*     */ 
/*     */   public TransactionAttributeType getMethodTransactionType(Method m, MethodInterfaceType iface)
/*     */   {
/* 552 */     if (m == null) {
/* 553 */       return TransactionAttributeType.SUPPORTS;
/*     */     }
/* 555 */     TransactionAttributeType result = null;
/* 556 */     if (this.methodTx != null)
/*     */     {
/* 558 */       result = (TransactionAttributeType)this.methodTx.get(m);
/* 559 */       if (result != null) {
/* 560 */         return result;
/*     */       }
/*     */     }
/* 563 */     result = getMethodTransactionType(m.getName(), m.getParameterTypes(), iface);
/*     */ 
/* 566 */     if (result == null) {
/* 567 */       result = TransactionAttributeType.REQUIRED;
/*     */     }
/* 569 */     if (this.methodTx == null)
/* 570 */       this.methodTx = new ConcurrentHashMap();
/* 571 */     this.methodTx.put(m, result);
/* 572 */     return result;
/*     */   }
/*     */ 
/*     */   public ExcludeListMetaData getExcludeList()
/*     */   {
/* 582 */     IAssemblyDescriptorMetaData assemblyDescriptor = getAssemblyDescriptor();
/* 583 */     if (assemblyDescriptor == null)
/* 584 */       return null;
/* 585 */     return assemblyDescriptor.getExcludeListByEjbName(getEjbName());
/*     */   }
/*     */ 
/*     */   public void merge(EnterpriseBeanMetaData override, EnterpriseBeanMetaData original)
/*     */   {
/* 595 */     super.merge(override, original);
/* 596 */     if ((override != null) && (override.mappedName != null))
/* 597 */       setMappedName(override.mappedName);
/* 598 */     else if ((original != null) && (original.mappedName != null))
/* 599 */       setMappedName(original.mappedName);
/* 600 */     if ((override != null) && (override.ejbClass != null))
/* 601 */       setEjbClass(override.ejbClass);
/* 602 */     else if ((original != null) && (original.ejbClass != null))
/* 603 */       setEjbClass(original.ejbClass);
/* 604 */     if (this.jndiEnvironmentRefsGroup == null)
/* 605 */       this.jndiEnvironmentRefsGroup = new EnvironmentRefsGroupMetaData();
/* 606 */     Environment env1 = override != null ? override.getJndiEnvironmentRefsGroup() : null;
/* 607 */     Environment env2 = original != null ? original.getJndiEnvironmentRefsGroup() : null;
/* 608 */     this.jndiEnvironmentRefsGroup.merge(env1, env2, "", "", false);
/* 609 */     if ((override != null) && (override.securityIdentity != null))
/* 610 */       setSecurityIdentity(override.securityIdentity);
/* 611 */     else if ((original != null) && (original.securityIdentity != null))
/* 612 */       setSecurityIdentity(original.securityIdentity);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData
 * JD-Core Version:    0.6.0
 */