/*     */ package org.jboss.metadata.ejb.jboss;
/*     */ 
/*     */ import java.util.List;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import org.jboss.metadata.ejb.spec.AroundInvokesMetaData;
/*     */ import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
/*     */ import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
/*     */ import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
/*     */ import org.jboss.metadata.ejb.spec.InitMethodsMetaData;
/*     */ import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
/*     */ import org.jboss.metadata.ejb.spec.RemoveMethodsMetaData;
/*     */ import org.jboss.metadata.ejb.spec.SecurityIdentityMetaData;
/*     */ import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
/*     */ import org.jboss.metadata.ejb.spec.SessionType;
/*     */ import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PortComponent;
/*     */ import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
/*     */ 
/*     */ @XmlType(name="jboss-session-beanType")
/*     */ public class JBossSessionBeanMetaData extends JBossEnterpriseBeanMetaData
/*     */ {
/*     */   private static final long serialVersionUID = 720735017632869718L;
/*     */   private String home;
/*     */   private String remote;
/*     */   private String localHome;
/*     */   private String local;
/*     */   private BusinessLocalsMetaData businessLocals;
/*     */   private BusinessRemotesMetaData businessRemotes;
/*     */   private String serviceEndpoint;
/*     */   private SessionType sessionType;
/*     */   private NamedMethodMetaData timeoutMethod;
/*     */   private InitMethodsMetaData initMethods;
/*     */   private RemoveMethodsMetaData removeMethods;
/*     */   private AroundInvokesMetaData aroundInvokes;
/*     */   private LifecycleCallbacksMetaData postActivates;
/*     */   private LifecycleCallbacksMetaData prePassivates;
/*     */   private SecurityRoleRefsMetaData securityRoleRefs;
/*     */   private String jndiName;
/*     */   private String homeJndiName;
/*     */   private String localHomeJndiName;
/*     */   private boolean callByValue;
/*     */   private List<RemoteBindingMetaData> remoteBindings;
/*     */   private boolean clustered;
/*     */   private ClusterConfigMetaData clusterConfig;
/*     */   private transient ClusterConfigMetaData determinedClusterConfig;
/*     */   private PortComponent portComponent;
/*     */   private SecurityIdentityMetaData ejbTimeoutIdentity;
/*     */   private CacheConfigMetaData cacheConfig;
/*     */   private Boolean concurrent;
/*     */ 
/*     */   public boolean isSession()
/*     */   {
/* 148 */     return true;
/*     */   }
/*     */ 
/*     */   public CacheConfigMetaData getCacheConfig()
/*     */   {
/* 153 */     return this.cacheConfig;
/*     */   }
/*     */ 
/*     */   public void setCacheConfig(CacheConfigMetaData cacheConfig)
/*     */   {
/* 158 */     this.cacheConfig = cacheConfig;
/*     */   }
/*     */ 
/*     */   public String getHome()
/*     */   {
/* 168 */     return this.home;
/*     */   }
/*     */ 
/*     */   public void setHome(String home)
/*     */   {
/* 179 */     if (home == null)
/* 180 */       throw new IllegalArgumentException("Null home");
/* 181 */     this.home = home;
/*     */   }
/*     */ 
/*     */   public String getHomeJndiName()
/*     */   {
/* 186 */     return this.homeJndiName;
/*     */   }
/*     */ 
/*     */   public void setHomeJndiName(String homeJndiName)
/*     */   {
/* 191 */     assert (homeJndiName != null) : "homeJndiName is null";
/*     */ 
/* 193 */     this.homeJndiName = homeJndiName;
/*     */   }
/*     */ 
/*     */   public String getRemote()
/*     */   {
/* 203 */     return this.remote;
/*     */   }
/*     */ 
/*     */   public void setRemote(String remote)
/*     */   {
/* 214 */     if (remote == null)
/* 215 */       throw new IllegalArgumentException("Null remote");
/* 216 */     this.remote = remote;
/*     */   }
/*     */ 
/*     */   public String getLocalHome()
/*     */   {
/* 226 */     return this.localHome;
/*     */   }
/*     */ 
/*     */   public void setLocalHome(String localHome)
/*     */   {
/* 237 */     if (localHome == null)
/* 238 */       throw new IllegalArgumentException("Null localHome");
/* 239 */     this.localHome = localHome;
/*     */   }
/*     */ 
/*     */   public String getLocal()
/*     */   {
/* 249 */     return this.local;
/*     */   }
/*     */ 
/*     */   public void setLocal(String local)
/*     */   {
/* 260 */     if (local == null)
/* 261 */       throw new IllegalArgumentException("Null local");
/* 262 */     this.local = local;
/*     */   }
/*     */ 
/*     */   public String getLocalHomeJndiName()
/*     */   {
/* 267 */     return this.localHomeJndiName;
/*     */   }
/*     */ 
/*     */   public void setLocalHomeJndiName(String localHomeJndiName)
/*     */   {
/* 272 */     assert (localHomeJndiName != null) : "localHomeJndiName is null";
/*     */ 
/* 274 */     this.localHomeJndiName = localHomeJndiName;
/*     */   }
/*     */ 
/*     */   public BusinessLocalsMetaData getBusinessLocals()
/*     */   {
/* 284 */     return this.businessLocals;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="business-local", required=false)
/*     */   public void setBusinessLocals(BusinessLocalsMetaData businessLocals)
/*     */   {
/* 296 */     if (businessLocals == null)
/* 297 */       throw new IllegalArgumentException("Null businessLocals");
/* 298 */     this.businessLocals = businessLocals;
/*     */   }
/*     */ 
/*     */   public BusinessRemotesMetaData getBusinessRemotes()
/*     */   {
/* 308 */     return this.businessRemotes;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="business-remote", required=false)
/*     */   public void setBusinessRemotes(BusinessRemotesMetaData businessRemotes)
/*     */   {
/* 320 */     if (businessRemotes == null)
/* 321 */       throw new IllegalArgumentException("Null businessRemotes");
/* 322 */     this.businessRemotes = businessRemotes;
/*     */   }
/*     */ 
/*     */   public String getServiceEndpoint()
/*     */   {
/* 332 */     return this.serviceEndpoint;
/*     */   }
/*     */ 
/*     */   public void setServiceEndpoint(String serviceEndpoint)
/*     */   {
/* 343 */     if (serviceEndpoint == null)
/* 344 */       throw new IllegalArgumentException("Null serviceEndpoint");
/* 345 */     this.serviceEndpoint = serviceEndpoint;
/*     */   }
/*     */ 
/*     */   public SessionType getSessionType()
/*     */   {
/* 355 */     return this.sessionType;
/*     */   }
/*     */ 
/*     */   public void setSessionType(SessionType sessionType)
/*     */   {
/* 366 */     if (sessionType == null)
/* 367 */       throw new IllegalArgumentException("Null sessionType");
/* 368 */     this.sessionType = sessionType;
/*     */   }
/*     */ 
/*     */   public boolean isStateful()
/*     */   {
/* 378 */     if (this.sessionType == null)
/* 379 */       return false;
/* 380 */     return this.sessionType == SessionType.Stateful;
/*     */   }
/*     */ 
/*     */   public boolean isStateless()
/*     */   {
/* 390 */     return !isStateful();
/*     */   }
/*     */ 
/*     */   public NamedMethodMetaData getTimeoutMethod()
/*     */   {
/* 400 */     return this.timeoutMethod;
/*     */   }
/*     */ 
/*     */   @XmlElement(required=false)
/*     */   public void setTimeoutMethod(NamedMethodMetaData timeoutMethod)
/*     */   {
/* 412 */     if (timeoutMethod == null)
/* 413 */       throw new IllegalArgumentException("Null timeoutMethod");
/* 414 */     this.timeoutMethod = timeoutMethod;
/*     */   }
/*     */ 
/*     */   public InitMethodsMetaData getInitMethods()
/*     */   {
/* 424 */     return this.initMethods;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="init-method", required=false)
/*     */   public void setInitMethods(InitMethodsMetaData initMethods)
/*     */   {
/* 436 */     if (initMethods == null)
/* 437 */       throw new IllegalArgumentException("Null initMethods");
/* 438 */     this.initMethods = initMethods;
/*     */   }
/*     */ 
/*     */   public RemoveMethodsMetaData getRemoveMethods()
/*     */   {
/* 448 */     return this.removeMethods;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="remove-method", required=false)
/*     */   public void setRemoveMethods(RemoveMethodsMetaData removeMethods)
/*     */   {
/* 460 */     if (removeMethods == null)
/* 461 */       throw new IllegalArgumentException("Null removeMethods");
/* 462 */     this.removeMethods = removeMethods;
/*     */   }
/*     */ 
/*     */   public AroundInvokesMetaData getAroundInvokes()
/*     */   {
/* 472 */     return this.aroundInvokes;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="around-invoke", required=false)
/*     */   public void setAroundInvokes(AroundInvokesMetaData aroundInvokes)
/*     */   {
/* 484 */     if (aroundInvokes == null)
/* 485 */       throw new IllegalArgumentException("Null aroundInvokes");
/* 486 */     this.aroundInvokes = aroundInvokes;
/*     */   }
/*     */ 
/*     */   public LifecycleCallbacksMetaData getPostActivates()
/*     */   {
/* 496 */     return this.postActivates;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="post-activate", required=false)
/*     */   public void setPostActivates(LifecycleCallbacksMetaData postActivates)
/*     */   {
/* 508 */     if (postActivates == null)
/* 509 */       throw new IllegalArgumentException("Null postActivates");
/* 510 */     this.postActivates = postActivates;
/*     */   }
/*     */ 
/*     */   public LifecycleCallbacksMetaData getPrePassivates()
/*     */   {
/* 520 */     return this.prePassivates;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="pre-passivate", required=false)
/*     */   public void setPrePassivates(LifecycleCallbacksMetaData prePassivates)
/*     */   {
/* 532 */     if (prePassivates == null)
/* 533 */       throw new IllegalArgumentException("Null prePassivates");
/* 534 */     this.prePassivates = prePassivates;
/*     */   }
/*     */ 
/*     */   public SecurityRoleRefsMetaData getSecurityRoleRefs()
/*     */   {
/* 544 */     return this.securityRoleRefs;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="security-role-ref")
/*     */   public void setSecurityRoleRefs(SecurityRoleRefsMetaData securityRoleRefs)
/*     */   {
/* 556 */     if (securityRoleRefs == null)
/* 557 */       throw new IllegalArgumentException("Null securityRoleRefs");
/* 558 */     this.securityRoleRefs = securityRoleRefs;
/*     */   }
/*     */ 
/*     */   public String getDefaultConfigurationName()
/*     */   {
/* 564 */     boolean stateful = isStateful();
/* 565 */     if (stateful)
/*     */     {
/* 567 */       if (isClustered()) {
/* 568 */         return "Clustered Stateful SessionBean";
/*     */       }
/* 570 */       return "Standard Stateful SessionBean";
/*     */     }
/*     */ 
/* 574 */     if (isClustered()) {
/* 575 */       return "Clustered Stateless SessionBean";
/*     */     }
/* 577 */     return "Standard Stateless SessionBean";
/*     */   }
/*     */ 
/*     */   public String getDefaultInvokerName()
/*     */   {
/* 584 */     boolean stateful = isStateful();
/* 585 */     if (stateful)
/*     */     {
/* 587 */       if (isClustered()) {
/* 588 */         return "clustered-stateful-rmi-invoker";
/*     */       }
/* 590 */       return "stateful-unified-invoker";
/*     */     }
/*     */ 
/* 594 */     if (isClustered()) {
/* 595 */       return "clustered-stateless-rmi-invoker";
/*     */     }
/* 597 */     return "stateless-unified-invoker";
/*     */   }
/*     */ 
/*     */   public String getJndiName()
/*     */   {
/* 608 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public void setJndiName(String jndiName)
/*     */   {
/* 619 */     if (jndiName == null)
/* 620 */       throw new IllegalArgumentException("Null jndiName");
/* 621 */     this.jndiName = jndiName;
/*     */   }
/*     */ 
/*     */   public String determineJndiName()
/*     */   {
/* 631 */     if (this.jndiName != null) {
/* 632 */       return this.jndiName;
/*     */     }
/* 634 */     String mapped = getMappedName();
/* 635 */     if (mapped != null)
/* 636 */       return mapped;
/* 637 */     return getEjbName();
/*     */   }
/*     */ 
/*     */   public String getContainerObjectNameJndiName()
/*     */   {
/* 643 */     boolean remote = false;
/* 644 */     if (getHome() != null)
/* 645 */       remote = true;
/* 646 */     return remote ? determineJndiName() : getLocalJndiName();
/*     */   }
/*     */ 
/*     */   protected String getDefaultInvokerJndiName()
/*     */   {
/* 652 */     return determineJndiName();
/*     */   }
/*     */ 
/*     */   public boolean isCallByValue()
/*     */   {
/* 662 */     return this.callByValue;
/*     */   }
/*     */ 
/*     */   public void setCallByValue(boolean callByValue)
/*     */   {
/* 672 */     this.callByValue = callByValue;
/*     */   }
/*     */ 
/*     */   public boolean isClustered()
/*     */   {
/* 682 */     return this.clustered;
/*     */   }
/*     */ 
/*     */   public void setClustered(boolean clustered)
/*     */   {
/* 692 */     this.clustered = clustered;
/*     */   }
/*     */ 
/*     */   public Boolean isConcurrent()
/*     */   {
/* 702 */     return this.concurrent;
/*     */   }
/*     */ 
/*     */   public void setConcurrent(Boolean concurrent)
/*     */   {
/* 712 */     this.concurrent = concurrent;
/*     */   }
/*     */ 
/*     */   public SecurityIdentityMetaData getEjbTimeoutIdentity()
/*     */   {
/* 722 */     return this.ejbTimeoutIdentity;
/*     */   }
/*     */ 
/*     */   public void setEjbTimeoutIdentity(SecurityIdentityMetaData ejbTimeoutIdentity)
/*     */   {
/* 733 */     if (ejbTimeoutIdentity == null)
/* 734 */       throw new IllegalArgumentException("Null ejbTimeoutIdentity");
/* 735 */     this.ejbTimeoutIdentity = ejbTimeoutIdentity;
/*     */   }
/*     */ 
/*     */   public ClusterConfigMetaData getClusterConfig()
/*     */   {
/* 745 */     return this.clusterConfig;
/*     */   }
/*     */ 
/*     */   public ClusterConfigMetaData determineClusterConfig()
/*     */   {
/* 755 */     if (this.determinedClusterConfig == null)
/*     */     {
/* 757 */       ClusterConfigMetaData containerDefaults = null;
/* 758 */       ContainerConfigurationMetaData container = determineContainerConfiguration();
/* 759 */       if (container != null)
/* 760 */         containerDefaults = container.getClusterConfig();
/* 761 */       this.determinedClusterConfig = new ClusterConfigMetaData();
/* 762 */       this.determinedClusterConfig.merge(this.clusterConfig, containerDefaults);
/*     */     }
/* 764 */     return this.determinedClusterConfig;
/*     */   }
/*     */ 
/*     */   public void setClusterConfig(ClusterConfigMetaData clusterConfig)
/*     */   {
/* 775 */     if (clusterConfig == null)
/* 776 */       throw new IllegalArgumentException("Null clusterConfig");
/* 777 */     this.clusterConfig = clusterConfig;
/*     */   }
/*     */ 
/*     */   public PortComponent getPortComponent()
/*     */   {
/* 783 */     return this.portComponent;
/*     */   }
/*     */ 
/*     */   public void setPortComponent(PortComponent portComponent)
/*     */   {
/* 788 */     this.portComponent = portComponent;
/*     */   }
/*     */ 
/*     */   public List<RemoteBindingMetaData> getRemoteBindings()
/*     */   {
/* 798 */     return this.remoteBindings;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="remote-binding", required=false)
/*     */   public void setRemoteBindings(List<RemoteBindingMetaData> remoteBindings)
/*     */   {
/* 810 */     if (remoteBindings == null)
/* 811 */       throw new IllegalArgumentException("Null remoteBinding");
/* 812 */     this.remoteBindings = remoteBindings;
/*     */   }
/*     */ 
/*     */   public void merge(JBossEnterpriseBeanMetaData override, EnterpriseBeanMetaData original, String overridenFile, String overrideFile, boolean mustOverride)
/*     */   {
/* 818 */     super.merge(override, original, overridenFile, overrideFile, mustOverride);
/* 819 */     JBossSessionBeanMetaData joverride = (JBossSessionBeanMetaData)override;
/* 820 */     SessionBeanMetaData soriginal = (SessionBeanMetaData)original;
/*     */ 
/* 823 */     if ((joverride != null) && (joverride.home != null))
/* 824 */       this.home = joverride.home;
/* 825 */     else if ((soriginal != null) && (soriginal.getHome() != null)) {
/* 826 */       this.home = soriginal.getHome();
/*     */     }
/* 828 */     if ((joverride != null) && (joverride.remote != null))
/* 829 */       this.remote = joverride.remote;
/* 830 */     else if ((soriginal != null) && (soriginal.getRemote() != null)) {
/* 831 */       this.remote = soriginal.getRemote();
/*     */     }
/* 833 */     if ((joverride != null) && (joverride.localHome != null))
/* 834 */       this.localHome = joverride.localHome;
/* 835 */     else if ((soriginal != null) && (soriginal.getLocalHome() != null)) {
/* 836 */       this.localHome = soriginal.getLocalHome();
/*     */     }
/* 838 */     if ((joverride != null) && (joverride.local != null))
/* 839 */       this.local = joverride.local;
/* 840 */     else if ((soriginal != null) && (soriginal.getLocal() != null)) {
/* 841 */       this.local = soriginal.getLocal();
/*     */     }
/* 843 */     if ((joverride != null) && (joverride.businessLocals != null))
/* 844 */       this.businessLocals = joverride.businessLocals;
/* 845 */     else if ((soriginal != null) && (soriginal.getBusinessLocals() != null)) {
/* 846 */       this.businessLocals = soriginal.getBusinessLocals();
/*     */     }
/* 848 */     if ((joverride != null) && (joverride.businessRemotes != null))
/* 849 */       this.businessRemotes = joverride.businessRemotes;
/* 850 */     else if ((soriginal != null) && (soriginal.getBusinessRemotes() != null)) {
/* 851 */       this.businessRemotes = soriginal.getBusinessRemotes();
/*     */     }
/* 853 */     if ((joverride != null) && (joverride.serviceEndpoint != null))
/* 854 */       this.serviceEndpoint = joverride.serviceEndpoint;
/* 855 */     else if ((soriginal != null) && (soriginal.getServiceEndpoint() != null)) {
/* 856 */       this.serviceEndpoint = soriginal.getServiceEndpoint();
/*     */     }
/* 858 */     if ((joverride != null) && (joverride.sessionType != null))
/* 859 */       this.sessionType = joverride.sessionType;
/* 860 */     else if ((soriginal != null) && (soriginal.getSessionType() != null)) {
/* 861 */       this.sessionType = soriginal.getSessionType();
/*     */     }
/* 863 */     if ((joverride != null) && (joverride.timeoutMethod != null))
/* 864 */       this.timeoutMethod = joverride.timeoutMethod;
/* 865 */     else if ((soriginal != null) && (soriginal.getTimeoutMethod() != null)) {
/* 866 */       this.timeoutMethod = soriginal.getTimeoutMethod();
/*     */     }
/* 868 */     if ((joverride != null) && (joverride.initMethods != null))
/* 869 */       this.initMethods = joverride.initMethods;
/* 870 */     else if ((soriginal != null) && (soriginal.getInitMethods() != null)) {
/* 871 */       this.initMethods = soriginal.getInitMethods();
/*     */     }
/* 873 */     if ((joverride != null) && (joverride.removeMethods != null))
/* 874 */       this.removeMethods = joverride.removeMethods;
/* 875 */     else if ((soriginal != null) && (soriginal.getRemoveMethods() != null)) {
/* 876 */       this.removeMethods = soriginal.getRemoveMethods();
/*     */     }
/* 878 */     if ((joverride != null) && (joverride.aroundInvokes != null))
/* 879 */       this.aroundInvokes = joverride.aroundInvokes;
/* 880 */     else if ((soriginal != null) && (soriginal.getAroundInvokes() != null)) {
/* 881 */       this.aroundInvokes = soriginal.getAroundInvokes();
/*     */     }
/* 883 */     if ((joverride != null) && (joverride.postActivates != null))
/* 884 */       this.postActivates = joverride.postActivates;
/* 885 */     else if ((soriginal != null) && (soriginal.getPostActivates() != null)) {
/* 886 */       this.postActivates = soriginal.getPostActivates();
/*     */     }
/* 888 */     if ((joverride != null) && (joverride.prePassivates != null))
/* 889 */       this.prePassivates = joverride.prePassivates;
/* 890 */     else if ((soriginal != null) && (soriginal.getPrePassivates() != null)) {
/* 891 */       this.prePassivates = soriginal.getPrePassivates();
/*     */     }
/* 893 */     if ((joverride != null) && (joverride.securityRoleRefs != null))
/* 894 */       this.securityRoleRefs = joverride.securityRoleRefs;
/* 895 */     else if ((soriginal != null) && (soriginal.getSecurityRoleRefs() != null)) {
/* 896 */       this.securityRoleRefs = soriginal.getSecurityRoleRefs();
/*     */     }
/*     */ 
/* 899 */     if ((joverride != null) && (joverride.jndiName != null)) {
/* 900 */       this.jndiName = joverride.jndiName;
/*     */     }
/* 902 */     if (joverride != null) {
/* 903 */       this.callByValue = joverride.callByValue;
/*     */     }
/* 905 */     if (joverride != null) {
/* 906 */       this.clustered = joverride.clustered;
/*     */     }
/* 908 */     if ((joverride != null) && (joverride.remoteBindings != null)) {
/* 909 */       this.remoteBindings = joverride.remoteBindings;
/*     */     }
/* 911 */     if ((joverride != null) && (joverride.clusterConfig != null)) {
/* 912 */       this.clusterConfig = joverride.clusterConfig;
/*     */     }
/* 914 */     if ((joverride != null) && (joverride.portComponent != null)) {
/* 915 */       this.portComponent = joverride.portComponent;
/*     */     }
/* 917 */     if ((joverride != null) && (joverride.ejbTimeoutIdentity != null))
/* 918 */       this.ejbTimeoutIdentity = joverride.ejbTimeoutIdentity;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData
 * JD-Core Version:    0.6.0
 */