/*     */ package org.jboss.metadata.ejb.jboss;
/*     */ 
/*     */ import org.jboss.metadata.common.jboss.LoaderRepositoryMetaData;
/*     */ import org.jboss.metadata.ejb.spec.InterceptorsMetaData;
/*     */ import org.jboss.metadata.ejb.spec.RelationsMetaData;
/*     */ import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
/*     */ 
/*     */ public class JBossMetaDataWrapper extends JBossMetaData
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private JBossMetaData primary;
/*     */   private JBossMetaData defaults;
/*     */   private ContainerConfigurationsMetaData configurationsWrapper;
/*     */   private transient InvokerProxyBindingsMetaData mergedInvokerBindings;
/*     */ 
/*     */   public JBossMetaDataWrapper(JBossMetaData primary, JBossMetaData defaults)
/*     */   {
/*  47 */     this.primary = primary;
/*  48 */     this.defaults = defaults;
/*  49 */     this.configurationsWrapper = new ContainerConfigurationsMetaDataWrapper(primary.getContainerConfigurations(), defaults.getContainerConfigurations());
/*     */ 
/*  51 */     wireOverrides();
/*     */   }
/*     */ 
/*     */   public String getDtdPublicId()
/*     */   {
/*  57 */     return this.primary.getDtdPublicId();
/*     */   }
/*     */ 
/*     */   public String getDtdSystemId()
/*     */   {
/*  63 */     return this.primary.getDtdSystemId();
/*     */   }
/*     */ 
/*     */   public String getEjbClientJar()
/*     */   {
/*  69 */     String clientJar = this.primary.getEjbClientJar();
/*  70 */     if (clientJar == null)
/*  71 */       clientJar = this.defaults.getEjbClientJar();
/*  72 */     return clientJar;
/*     */   }
/*     */ 
/*     */   public InterceptorsMetaData getInterceptors()
/*     */   {
/*  78 */     InterceptorsMetaData interceptors = this.primary.getInterceptors();
/*  79 */     if (interceptors == null)
/*  80 */       interceptors = this.defaults.getInterceptors();
/*  81 */     return interceptors;
/*     */   }
/*     */ 
/*     */   public String getJaccContextID()
/*     */   {
/*  87 */     String jaccID = this.primary.getJaccContextID();
/*  88 */     if (jaccID == null)
/*  89 */       jaccID = this.defaults.getJaccContextID();
/*  90 */     return jaccID;
/*     */   }
/*     */ 
/*     */   public RelationsMetaData getRelationships()
/*     */   {
/*  96 */     RelationsMetaData relations = this.primary.getRelationships();
/*  97 */     if (relations == null)
/*  98 */       relations = this.defaults.getRelationships();
/*  99 */     return relations;
/*     */   }
/*     */ 
/*     */   public boolean isEJB1x()
/*     */   {
/* 105 */     return this.primary.isEJB1x();
/*     */   }
/*     */ 
/*     */   public boolean isEJB21()
/*     */   {
/* 111 */     return this.primary.isEJB21();
/*     */   }
/*     */ 
/*     */   public boolean isEJB2x()
/*     */   {
/* 117 */     return this.primary.isEJB2x();
/*     */   }
/*     */ 
/*     */   public boolean isEJB3x()
/*     */   {
/* 123 */     return this.primary.isEJB3x();
/*     */   }
/*     */ 
/*     */   public JBossAssemblyDescriptorMetaData getAssemblyDescriptor()
/*     */   {
/* 129 */     return this.primary.getAssemblyDescriptor();
/*     */   }
/*     */ 
/*     */   public ContainerConfigurationMetaData getContainerConfiguration(String name)
/*     */   {
/* 135 */     ContainerConfigurationMetaData ccmd = (ContainerConfigurationMetaData)this.configurationsWrapper.get(name);
/* 136 */     return ccmd;
/*     */   }
/*     */ 
/*     */   public ContainerConfigurationsMetaData getContainerConfigurations()
/*     */   {
/* 142 */     return this.configurationsWrapper;
/*     */   }
/*     */ 
/*     */   public JBossEnterpriseBeanMetaData getEnterpriseBean(String name)
/*     */   {
/* 148 */     return this.primary.getEnterpriseBean(name);
/*     */   }
/*     */ 
/*     */   public JBossEnterpriseBeansMetaData getEnterpriseBeans()
/*     */   {
/* 154 */     return this.primary.getEnterpriseBeans();
/*     */   }
/*     */ 
/*     */   public InvokerProxyBindingMetaData getInvokerProxyBinding(String name)
/*     */   {
/* 160 */     InvokerProxyBindingMetaData ipbmd = this.primary.getInvokerProxyBinding(name);
/* 161 */     if (ipbmd == null)
/* 162 */       ipbmd = this.defaults.getInvokerProxyBinding(name);
/* 163 */     return ipbmd;
/*     */   }
/*     */ 
/*     */   public InvokerProxyBindingsMetaData getInvokerProxyBindings()
/*     */   {
/* 169 */     if (this.mergedInvokerBindings == null)
/*     */     {
/* 171 */       this.mergedInvokerBindings = new InvokerProxyBindingsMetaDataWrapper(this.primary.getInvokerProxyBindings(), this.defaults.getInvokerProxyBindings());
/*     */     }
/*     */ 
/* 175 */     return this.mergedInvokerBindings;
/*     */   }
/*     */ 
/*     */   public String getJmxName()
/*     */   {
/* 181 */     String jmxName = this.primary.getJmxName();
/* 182 */     if (jmxName == null)
/* 183 */       jmxName = this.defaults.getJmxName();
/* 184 */     return jmxName;
/*     */   }
/*     */ 
/*     */   public LoaderRepositoryMetaData getLoaderRepository()
/*     */   {
/* 190 */     LoaderRepositoryMetaData x = this.primary.getLoaderRepository();
/* 191 */     if (x == null)
/* 192 */       x = this.defaults.getLoaderRepository();
/* 193 */     return x;
/*     */   }
/*     */ 
/*     */   public ResourceManagerMetaData getResourceManager(String name)
/*     */   {
/* 199 */     return this.primary.getResourceManager(name);
/*     */   }
/*     */ 
/*     */   public ResourceManagersMetaData getResourceManagers()
/*     */   {
/* 205 */     return this.primary.getResourceManagers();
/*     */   }
/*     */ 
/*     */   public String getSecurityDomain()
/*     */   {
/* 211 */     return this.primary.getSecurityDomain();
/*     */   }
/*     */ 
/*     */   public String getUnauthenticatedPrincipal()
/*     */   {
/* 217 */     String unauthenticatedPrincipal = this.primary.getUnauthenticatedPrincipal();
/* 218 */     if (unauthenticatedPrincipal == null)
/* 219 */       unauthenticatedPrincipal = this.defaults.getUnauthenticatedPrincipal();
/* 220 */     return unauthenticatedPrincipal;
/*     */   }
/*     */ 
/*     */   public String getVersion()
/*     */   {
/* 226 */     return this.primary.getVersion();
/*     */   }
/*     */ 
/*     */   public WebservicesMetaData getWebservices()
/*     */   {
/* 232 */     return this.primary.getWebservices();
/*     */   }
/*     */ 
/*     */   public boolean isExceptionOnRollback()
/*     */   {
/* 238 */     return this.primary.isExceptionOnRollback();
/*     */   }
/*     */ 
/*     */   public boolean isExcludeMissingMethods()
/*     */   {
/* 244 */     return this.primary.isExcludeMissingMethods();
/*     */   }
/*     */ 
/*     */   public DescriptionGroupMetaData getDescriptionGroup()
/*     */   {
/* 250 */     return this.primary.getDescriptionGroup();
/*     */   }
/*     */ 
/*     */   public String getId()
/*     */   {
/* 256 */     return this.primary.getId();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 262 */     return this.primary.toString();
/*     */   }
/*     */ 
/*     */   protected void wireOverrides()
/*     */   {
/* 267 */     if (this.primary != null)
/*     */     {
/* 269 */       JBossEnterpriseBeansMetaData beans = this.primary.getEnterpriseBeans();
/* 270 */       beans.setJBossMetaData(this);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.jboss.JBossMetaDataWrapper
 * JD-Core Version:    0.6.0
 */