/*     */ package org.jboss.metadata.ejb.jboss;
/*     */ 
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import org.jboss.metadata.ejb.spec.ActivationConfigMetaData;
/*     */ import org.jboss.metadata.ejb.spec.AroundInvokesMetaData;
/*     */ import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
/*     */ import org.jboss.metadata.ejb.spec.MessageDrivenBeanMetaData;
/*     */ import org.jboss.metadata.ejb.spec.MessageDrivenDestinationMetaData;
/*     */ import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
/*     */ import org.jboss.metadata.ejb.spec.SecurityIdentityMetaData;
/*     */ import org.jboss.metadata.ejb.spec.SubscriptionDurability;
/*     */ 
/*     */ @XmlType(name="jboss-message-driven-beanType")
/*     */ public class JBossMessageDrivenBeanMetaData extends JBossEnterpriseBeanMetaData
/*     */ {
/*     */   private static final long serialVersionUID = -4006016148034278681L;
/*     */   private String messagingType;
/*     */   private NamedMethodMetaData timeoutMethod;
/*     */   private String messageDestinationType;
/*     */   private String messageDestinationLink;
/*     */   private ActivationConfigMetaData activationConfig;
/*     */   private AroundInvokesMetaData aroundInvokes;
/*     */   private String messageSelector;
/*     */   private String acknowledgeMode;
/*  73 */   private SubscriptionDurability subscriptionDurability = SubscriptionDurability.NonDurable;
/*     */   private String destinationJndiName;
/*     */   private String mdbUser;
/*     */   private String mdbPassword;
/*     */   private String mdbClientId;
/*     */   private String mdbSubscriptionId;
/*     */   private String resourceAdapterName;
/*     */   private SecurityIdentityMetaData ejbTimeoutIdentity;
/*     */   private ActivationConfigMetaData defaultActivationConfig;
/*     */ 
/*     */   public boolean isMessageDriven()
/*     */   {
/* 110 */     return true;
/*     */   }
/*     */ 
/*     */   public String getMessagingType()
/*     */   {
/* 121 */     return this.messagingType;
/*     */   }
/*     */ 
/*     */   public boolean isJMS()
/*     */   {
/* 131 */     String messagingType = getMessagingType();
/* 132 */     return (messagingType == null) || ("javax.jms.MessageListener".equals(messagingType));
/*     */   }
/*     */ 
/*     */   public void setMessagingType(String messagingType)
/*     */   {
/* 144 */     if (messagingType == null)
/* 145 */       throw new IllegalArgumentException("Null messagingType");
/* 146 */     this.messagingType = messagingType;
/*     */   }
/*     */ 
/*     */   public NamedMethodMetaData getTimeoutMethod()
/*     */   {
/* 157 */     return this.timeoutMethod;
/*     */   }
/*     */ 
/*     */   @XmlElement(required=false)
/*     */   public void setTimeoutMethod(NamedMethodMetaData timeoutMethod)
/*     */   {
/* 170 */     if (timeoutMethod == null)
/* 171 */       throw new IllegalArgumentException("Null timeoutMethod");
/* 172 */     this.timeoutMethod = timeoutMethod;
/*     */   }
/*     */ 
/*     */   public String getMessageDestinationType()
/*     */   {
/* 182 */     return this.messageDestinationType;
/*     */   }
/*     */ 
/*     */   public void setMessageDestinationType(String messageDestinationType)
/*     */   {
/* 194 */     if (messageDestinationType == null)
/* 195 */       throw new IllegalArgumentException("Null messageDestinationType");
/* 196 */     this.messageDestinationType = messageDestinationType;
/*     */   }
/*     */ 
/*     */   public AroundInvokesMetaData getAroundInvokes()
/*     */   {
/* 207 */     return this.aroundInvokes;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="around-invoke", required=false)
/*     */   public void setAroundInvokes(AroundInvokesMetaData aroundInvokes)
/*     */   {
/* 220 */     if (aroundInvokes == null)
/* 221 */       throw new IllegalArgumentException("Null aroundInvokes");
/* 222 */     this.aroundInvokes = aroundInvokes;
/*     */   }
/*     */ 
/*     */   public String getMessageDestinationLink()
/*     */   {
/* 233 */     return this.messageDestinationLink;
/*     */   }
/*     */ 
/*     */   public void setMessageDestinationLink(String messageDestinationLink)
/*     */   {
/* 245 */     if (messageDestinationLink == null)
/* 246 */       throw new IllegalArgumentException("Null messageDestinationLink");
/* 247 */     this.messageDestinationLink = messageDestinationLink;
/*     */   }
/*     */ 
/*     */   public ActivationConfigMetaData getActivationConfig()
/*     */   {
/* 258 */     return this.activationConfig;
/*     */   }
/*     */ 
/*     */   public void setActivationConfig(ActivationConfigMetaData activationConfig)
/*     */   {
/* 270 */     if (activationConfig == null)
/* 271 */       throw new IllegalArgumentException("Null activationConfig");
/* 272 */     this.activationConfig = activationConfig;
/*     */   }
/*     */ 
/*     */   public String getMessageSelector()
/*     */   {
/* 282 */     return this.messageSelector;
/*     */   }
/*     */ 
/*     */   @XmlElement(required=false)
/*     */   public void setMessageSelector(String messageSelector)
/*     */   {
/* 294 */     if (messageSelector == null)
/* 295 */       throw new IllegalArgumentException("Null messageSelector");
/* 296 */     this.messageSelector = messageSelector;
/*     */   }
/*     */ 
/*     */   public String getAcknowledgeMode()
/*     */   {
/* 306 */     return this.acknowledgeMode;
/*     */   }
/*     */ 
/*     */   @XmlElement(required=false)
/*     */   public void setAcknowledgeMode(String acknowledgeMode)
/*     */   {
/* 318 */     if (acknowledgeMode == null)
/* 319 */       throw new IllegalArgumentException("Null acknowledgeMode");
/* 320 */     this.acknowledgeMode = acknowledgeMode;
/*     */   }
/*     */ 
/*     */   public SubscriptionDurability getSubscriptionDurability()
/*     */   {
/* 330 */     return this.subscriptionDurability;
/*     */   }
/*     */ 
/*     */   @XmlElement(required=false)
/*     */   public void setSubscriptionDurability(SubscriptionDurability subscriptionDurability)
/*     */   {
/* 342 */     if (subscriptionDurability == null)
/* 343 */       throw new IllegalArgumentException("Null subscriptionDurability");
/* 344 */     this.subscriptionDurability = subscriptionDurability;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="message-driven-destination", required=false)
/*     */   public void setMessageDrivenDestination(MessageDrivenDestinationMetaData mdd)
/*     */   {
/* 351 */     setMessageDestinationType(mdd.getDestinationType());
/* 352 */     String durability = mdd.getSubscriptionDurability();
/* 353 */     SubscriptionDurability sd = SubscriptionDurability.NonDurable;
/* 354 */     if ((durability != null) && (durability.equalsIgnoreCase("Durable")))
/* 355 */       sd = SubscriptionDurability.Durable;
/* 356 */     setSubscriptionDurability(sd);
/*     */   }
/*     */ 
/*     */   public String getDefaultConfigurationName()
/*     */   {
/* 362 */     boolean isJMS = isJMS();
/* 363 */     if (!isJMS) {
/* 364 */       return "Standard Message Inflow Driven Bean";
/*     */     }
/* 366 */     return "Standard Message Driven Bean";
/*     */   }
/*     */ 
/*     */   protected String getDefaultInvokerName()
/*     */   {
/* 372 */     return "message-driven-bean";
/*     */   }
/*     */ 
/*     */   protected String getDefaultInvokerJndiName()
/*     */   {
/* 378 */     return getEjbName();
/*     */   }
/*     */ 
/*     */   public String getDestinationJndiName()
/*     */   {
/* 388 */     return this.destinationJndiName;
/*     */   }
/*     */ 
/*     */   public void setDestinationJndiName(String destinationJndiName)
/*     */   {
/* 399 */     if (destinationJndiName == null)
/* 400 */       throw new IllegalArgumentException("Null destinationJndiName");
/* 401 */     this.destinationJndiName = destinationJndiName;
/*     */   }
/*     */ 
/*     */   public String getMdbUser()
/*     */   {
/* 411 */     return this.mdbUser;
/*     */   }
/*     */ 
/*     */   public void setMdbUser(String mdbUser)
/*     */   {
/* 422 */     if (mdbUser == null)
/* 423 */       throw new IllegalArgumentException("Null mdbUser");
/* 424 */     this.mdbUser = mdbUser;
/*     */   }
/*     */ 
/*     */   public String getMdbPassword()
/*     */   {
/* 434 */     return this.mdbPassword;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="mdb-passwd")
/*     */   public void setMdbPassword(String mdbPassword)
/*     */   {
/* 446 */     if (mdbPassword == null)
/* 447 */       throw new IllegalArgumentException("Null mdbPassword");
/* 448 */     this.mdbPassword = mdbPassword;
/*     */   }
/*     */ 
/*     */   public String getMdbClientId()
/*     */   {
/* 458 */     return this.mdbClientId;
/*     */   }
/*     */ 
/*     */   public void setMdbClientId(String mdbClientId)
/*     */   {
/* 469 */     if (mdbClientId == null)
/* 470 */       throw new IllegalArgumentException("Null mdbClientId");
/* 471 */     this.mdbClientId = mdbClientId;
/*     */   }
/*     */ 
/*     */   public String getResourceAdapterName()
/*     */   {
/* 481 */     return this.resourceAdapterName;
/*     */   }
/*     */ 
/*     */   public void setResourceAdapterName(String resourceAdapterName)
/*     */   {
/* 492 */     if (resourceAdapterName == null)
/* 493 */       throw new IllegalArgumentException("Null resourceAdapterName");
/* 494 */     this.resourceAdapterName = resourceAdapterName;
/*     */   }
/*     */ 
/*     */   public String getMdbSubscriptionId()
/*     */   {
/* 504 */     return this.mdbSubscriptionId;
/*     */   }
/*     */ 
/*     */   public void setMdbSubscriptionId(String mdbSubscriptionId)
/*     */   {
/* 515 */     if (mdbSubscriptionId == null)
/* 516 */       throw new IllegalArgumentException("Null mdbSubscriptionId");
/* 517 */     this.mdbSubscriptionId = mdbSubscriptionId;
/*     */   }
/*     */ 
/*     */   public ActivationConfigMetaData getDefaultActivationConfig()
/*     */   {
/* 527 */     return this.defaultActivationConfig;
/*     */   }
/*     */ 
/*     */   public void setDefaultActivationConfig(ActivationConfigMetaData defaultActivationConfig)
/*     */   {
/* 538 */     if (defaultActivationConfig == null)
/* 539 */       throw new IllegalArgumentException("Null defaultActivationConfig");
/* 540 */     this.defaultActivationConfig = defaultActivationConfig;
/*     */   }
/*     */ 
/*     */   public SecurityIdentityMetaData getEjbTimeoutIdentity()
/*     */   {
/* 550 */     return this.ejbTimeoutIdentity;
/*     */   }
/*     */ 
/*     */   public void setEjbTimeoutIdentity(SecurityIdentityMetaData ejbTimeoutIdentity)
/*     */   {
/* 561 */     if (ejbTimeoutIdentity == null)
/* 562 */       throw new IllegalArgumentException("Null ejbTimeoutIdentity");
/* 563 */     this.ejbTimeoutIdentity = ejbTimeoutIdentity;
/*     */   }
/*     */ 
/*     */   public void merge(JBossEnterpriseBeanMetaData override, EnterpriseBeanMetaData original, String overridenFile, String overrideFile, boolean mustOverride)
/*     */   {
/* 569 */     super.merge(override, original, overridenFile, overrideFile, mustOverride);
/* 570 */     JBossMessageDrivenBeanMetaData joverride = (JBossMessageDrivenBeanMetaData)override;
/* 571 */     MessageDrivenBeanMetaData soriginal = (MessageDrivenBeanMetaData)original;
/*     */ 
/* 573 */     if ((joverride != null) && (joverride.messagingType != null))
/* 574 */       this.messagingType = joverride.messagingType;
/* 575 */     else if ((soriginal != null) && (soriginal.getMessagingType() != null)) {
/* 576 */       this.messagingType = soriginal.getMessagingType();
/*     */     }
/* 578 */     if ((joverride != null) && (joverride.timeoutMethod != null))
/* 579 */       this.timeoutMethod = joverride.timeoutMethod;
/* 580 */     else if ((soriginal != null) && (soriginal.getTimeoutMethod() != null)) {
/* 581 */       this.timeoutMethod = soriginal.getTimeoutMethod();
/*     */     }
/* 583 */     if ((joverride != null) && (joverride.messageDestinationType != null))
/* 584 */       this.messageDestinationType = joverride.messageDestinationType;
/* 585 */     else if ((soriginal != null) && (soriginal.getMessageDestinationType() != null)) {
/* 586 */       this.messageDestinationType = soriginal.getMessageDestinationType();
/*     */     }
/* 588 */     if ((joverride != null) && (joverride.messageDestinationLink != null))
/* 589 */       this.messageDestinationLink = joverride.messageDestinationLink;
/* 590 */     else if ((soriginal != null) && (soriginal.getMessageDestinationLink() != null)) {
/* 591 */       this.messageDestinationLink = soriginal.getMessageDestinationLink();
/*     */     }
/* 593 */     ActivationConfigMetaData jbossActivationConfig = null;
/* 594 */     if ((joverride != null) && (joverride.getActivationConfig() != null))
/* 595 */       jbossActivationConfig = joverride.getActivationConfig();
/* 596 */     ActivationConfigMetaData originalActivationConfig = null;
/* 597 */     if (soriginal != null)
/* 598 */       originalActivationConfig = soriginal.getActivationConfig();
/* 599 */     if ((jbossActivationConfig != null) || (originalActivationConfig != null))
/*     */     {
/* 601 */       if (this.activationConfig == null)
/* 602 */         this.activationConfig = new ActivationConfigMetaData();
/* 603 */       this.activationConfig.merge(jbossActivationConfig, originalActivationConfig);
/*     */     }
/*     */ 
/* 606 */     if ((joverride != null) && (joverride.aroundInvokes != null))
/* 607 */       this.aroundInvokes = joverride.aroundInvokes;
/* 608 */     else if ((soriginal != null) && (soriginal.getAroundInvokes() != null)) {
/* 609 */       this.aroundInvokes = soriginal.getAroundInvokes();
/*     */     }
/* 611 */     if ((joverride != null) && (joverride.messageSelector != null))
/* 612 */       this.messageSelector = joverride.messageSelector;
/* 613 */     else if ((soriginal != null) && (soriginal.getMessageSelector() != null)) {
/* 614 */       this.messageSelector = soriginal.getMessageSelector();
/*     */     }
/* 616 */     if ((joverride != null) && (joverride.acknowledgeMode != null))
/* 617 */       this.acknowledgeMode = joverride.acknowledgeMode;
/* 618 */     else if ((soriginal != null) && (soriginal.getAcknowledgeMode() != null)) {
/* 619 */       this.acknowledgeMode = soriginal.getAcknowledgeMode();
/*     */     }
/* 621 */     if ((joverride != null) && (joverride.subscriptionDurability != null))
/* 622 */       this.subscriptionDurability = joverride.subscriptionDurability;
/* 623 */     else if ((soriginal != null) && (soriginal.getSubscriptionDurability() != null)) {
/* 624 */       this.subscriptionDurability = soriginal.getSubscriptionDurability();
/*     */     }
/* 626 */     if ((joverride != null) && (joverride.destinationJndiName != null))
/* 627 */       this.destinationJndiName = joverride.destinationJndiName;
/* 628 */     else if ((soriginal != null) && (soriginal.getMappedName() != null)) {
/* 629 */       this.destinationJndiName = soriginal.getMappedName();
/*     */     }
/* 631 */     if ((joverride != null) && (joverride.mdbUser != null)) {
/* 632 */       this.mdbUser = joverride.mdbUser;
/*     */     }
/* 634 */     if ((joverride != null) && (joverride.mdbPassword != null)) {
/* 635 */       this.mdbPassword = joverride.mdbPassword;
/*     */     }
/* 637 */     if ((joverride != null) && (joverride.mdbClientId != null)) {
/* 638 */       this.mdbClientId = joverride.mdbClientId;
/*     */     }
/* 640 */     if ((joverride != null) && (joverride.mdbSubscriptionId != null)) {
/* 641 */       this.mdbSubscriptionId = joverride.mdbSubscriptionId;
/*     */     }
/* 643 */     if ((joverride != null) && (joverride.resourceAdapterName != null)) {
/* 644 */       this.resourceAdapterName = joverride.resourceAdapterName;
/*     */     }
/* 646 */     if ((joverride != null) && (joverride.ejbTimeoutIdentity != null)) {
/* 647 */       this.ejbTimeoutIdentity = joverride.ejbTimeoutIdentity;
/*     */     }
/* 649 */     if ((joverride != null) && (joverride.defaultActivationConfig != null))
/* 650 */       this.defaultActivationConfig = joverride.defaultActivationConfig;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.jboss.JBossMessageDrivenBeanMetaData
 * JD-Core Version:    0.6.0
 */