/*     */ package org.jboss.metadata.ejb.jboss;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import org.jboss.metadata.javaee.jboss.JBossServiceReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.jboss.JBossServiceReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBLocalReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBLocalReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.Environment;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PersistenceContextReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PersistenceContextReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.RemoteEnvironmentRefsGroupMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;
/*     */ import org.jboss.xb.annotations.JBossXmlCollection;
/*     */ import org.jboss.xb.annotations.JBossXmlModelGroup;
/*     */ 
/*     */ @JBossXmlModelGroup(name="jbossJndiEnvironmentRefsGroup", propOrder={"environmentEntries", "ejbReferences", "ejbLocalReferences", "serviceReferences", "resourceReferences", "resourceEnvironmentReferences", "messageDestinationReferences", "persistenceContextRefs", "persistenceUnitRefs", "postConstructs", "preDestroys"})
/*     */ public class JBossEnvironmentRefsGroupMetaData extends RemoteEnvironmentRefsGroupMetaData
/*     */   implements Serializable, Environment
/*     */ {
/*     */   private static final long serialVersionUID = 4642263968653845579L;
/*     */   private EJBLocalReferencesMetaData ejbLocalReferences;
/*     */   private JBossServiceReferencesMetaData serviceReferences;
/*     */   private PersistenceContextReferencesMetaData persistenceContextRefs;
/*     */ 
/*     */   public static JBossEnvironmentRefsGroupMetaData mergeNew(JBossEnvironmentRefsGroupMetaData jbossEnvironmentRefsGroup, EnvironmentRefsGroupMetaData environmentRefsGroup, ResourceManagersMetaData resourceMgrs, String overrideFile, String overridenFile, boolean mustOverride)
/*     */   {
/*  84 */     JBossEnvironmentRefsGroupMetaData merged = new JBossEnvironmentRefsGroupMetaData();
/*     */ 
/*  86 */     merged.merge(jbossEnvironmentRefsGroup, environmentRefsGroup, resourceMgrs, overridenFile, overrideFile, mustOverride);
/*     */ 
/*  88 */     return merged;
/*     */   }
/*     */ 
/*     */   public EJBLocalReferenceMetaData getEjbLocalReferenceByName(String name)
/*     */   {
/*  93 */     EJBLocalReferenceMetaData ref = null;
/*  94 */     if (this.ejbLocalReferences != null)
/*  95 */       ref = (EJBLocalReferenceMetaData)this.ejbLocalReferences.get(name);
/*  96 */     return ref;
/*     */   }
/*     */ 
/*     */   public PersistenceContextReferenceMetaData getPersistenceContextReferenceByName(String name)
/*     */   {
/* 101 */     PersistenceContextReferenceMetaData ref = null;
/* 102 */     if (this.persistenceContextRefs != null)
/* 103 */       ref = (PersistenceContextReferenceMetaData)this.persistenceContextRefs.get(name);
/* 104 */     return ref;
/*     */   }
/*     */ 
/*     */   public ServiceReferencesMetaData getServiceReferences()
/*     */   {
/* 109 */     return this.serviceReferences;
/*     */   }
/*     */   @JBossXmlCollection(type=JBossServiceReferencesMetaData.class)
/*     */   @XmlElement(name="service-ref", type=JBossServiceReferenceMetaData.class)
/*     */   public void setServiceReferences(ServiceReferencesMetaData serviceReferences) {
/* 116 */     this.serviceReferences = ((JBossServiceReferencesMetaData)serviceReferences);
/*     */   }
/*     */ 
/*     */   public EJBLocalReferencesMetaData getEjbLocalReferences()
/*     */   {
/* 122 */     return this.ejbLocalReferences;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="ejb-local-ref")
/*     */   public void setEjbLocalReferences(EJBLocalReferencesMetaData ejbLocalReferences) {
/* 128 */     this.ejbLocalReferences = ejbLocalReferences;
/*     */   }
/*     */ 
/*     */   public PersistenceContextReferencesMetaData getPersistenceContextRefs()
/*     */   {
/* 134 */     return this.persistenceContextRefs;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="persistence-context-ref")
/*     */   public void setPersistenceContextRefs(PersistenceContextReferencesMetaData persistenceContextRefs) {
/* 140 */     this.persistenceContextRefs = persistenceContextRefs;
/*     */   }
/*     */ 
/*     */   public void merge(JBossEnvironmentRefsGroupMetaData jbossEnv, Environment specEnv, ResourceManagersMetaData resourceMgrs, String overrideFile, String overridenFile, boolean mustOverride)
/*     */   {
/* 158 */     if ((jbossEnv == null) && (specEnv == null)) {
/* 159 */       return;
/*     */     }
/* 161 */     super.merge(jbossEnv, specEnv, overridenFile, overrideFile, mustOverride);
/*     */ 
/* 163 */     EJBLocalReferencesMetaData ejbLocalRefs = null;
/* 164 */     EJBLocalReferencesMetaData jbossEjbLocalRefs = null;
/* 165 */     PersistenceContextReferencesMetaData specPersistenceContextRefs = null;
/* 166 */     PersistenceContextReferencesMetaData jbossPersistenceContextRefs = null;
/*     */ 
/* 168 */     if (specEnv != null)
/*     */     {
/* 170 */       ejbLocalRefs = specEnv.getEjbLocalReferences();
/* 171 */       specPersistenceContextRefs = specEnv.getPersistenceContextRefs();
/*     */     }
/*     */ 
/* 174 */     if (jbossEnv != null)
/*     */     {
/* 176 */       jbossEjbLocalRefs = jbossEnv.getEjbLocalReferences();
/* 177 */       jbossPersistenceContextRefs = jbossEnv.getPersistenceContextRefs();
/*     */     }
/*     */     else
/*     */     {
/* 182 */       jbossEjbLocalRefs = getEjbLocalReferences();
/* 183 */       jbossPersistenceContextRefs = getPersistenceContextRefs();
/*     */     }
/*     */ 
/* 186 */     EJBLocalReferencesMetaData mergedEjbLocalRefs = EJBLocalReferencesMetaData.merge(jbossEjbLocalRefs, ejbLocalRefs, overridenFile, overrideFile);
/* 187 */     if (mergedEjbLocalRefs != null) {
/* 188 */       setEjbLocalReferences(mergedEjbLocalRefs);
/*     */     }
/*     */ 
/* 191 */     ResourceReferencesMetaData jbossResRefs = getResourceReferences();
/* 192 */     if ((resourceMgrs != null) && (jbossResRefs != null))
/*     */     {
/* 194 */       for (ResourceReferenceMetaData ref : jbossResRefs)
/*     */       {
/* 196 */         ResourceManagerMetaData mgr = (ResourceManagerMetaData)resourceMgrs.get(ref.getResourceName());
/* 197 */         if (mgr != null)
/*     */         {
/* 199 */           if (mgr.getResJndiName() != null)
/* 200 */             ref.setJndiName(mgr.getResJndiName());
/* 201 */           else if (mgr.getResUrl() != null) {
/* 202 */             ref.setResUrl(mgr.getResUrl());
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 207 */     PersistenceContextReferencesMetaData mergedPcRefs = PersistenceContextReferencesMetaData.merge(jbossPersistenceContextRefs, specPersistenceContextRefs, overridenFile, overrideFile);
/*     */ 
/* 209 */     if (mergedPcRefs != null)
/* 210 */       setPersistenceContextRefs(mergedPcRefs);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.jboss.JBossEnvironmentRefsGroupMetaData
 * JD-Core Version:    0.6.0
 */