/*     */ package org.jboss.metadata.ejb.jboss;
/*     */ 
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import org.jboss.metadata.ejb.spec.CMPFieldsMetaData;
/*     */ import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
/*     */ import org.jboss.metadata.ejb.spec.EntityBeanMetaData;
/*     */ import org.jboss.metadata.ejb.spec.PersistenceType;
/*     */ import org.jboss.metadata.ejb.spec.QueriesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
/*     */ 
/*     */ @XmlType(name="jboss-entity-beanType")
/*     */ public class JBossEntityBeanMetaData extends JBossEnterpriseBeanMetaData
/*     */ {
/*     */   private static final long serialVersionUID = -6869794514744015588L;
/*     */   private String home;
/*     */   private String remote;
/*     */   private String localHome;
/*     */   private String local;
/*     */   private PersistenceType persistenceType;
/*     */   private String primKeyClass;
/*     */   private boolean reentrant;
/*     */   private String cmpVersion;
/*     */   private String abstractSchemaName;
/*     */   private CMPFieldsMetaData cmpFields;
/*     */   private String primKeyField;
/*     */   private SecurityRoleRefsMetaData securityRoleRefs;
/*     */   private QueriesMetaData queries;
/*     */   private String jndiName;
/*     */   private boolean callByValue;
/*     */   private boolean clustered;
/*     */   private boolean readOnly;
/*     */   private ClusterConfigMetaData clusterConfig;
/*     */   private transient ClusterConfigMetaData determinedClusterConfig;
/*     */   private boolean cacheInvalidation;
/*     */   private CacheInvalidationConfigMetaData cacheInvalidationConfig;
/*     */ 
/*     */   public boolean isEntity()
/*     */   {
/* 123 */     return true;
/*     */   }
/*     */ 
/*     */   public String getHome()
/*     */   {
/* 133 */     return this.home;
/*     */   }
/*     */ 
/*     */   public void setHome(String home)
/*     */   {
/* 144 */     if (home == null)
/* 145 */       throw new IllegalArgumentException("Null home");
/* 146 */     this.home = home;
/*     */   }
/*     */ 
/*     */   public String getRemote()
/*     */   {
/* 156 */     return this.remote;
/*     */   }
/*     */ 
/*     */   public void setRemote(String remote)
/*     */   {
/* 167 */     if (remote == null)
/* 168 */       throw new IllegalArgumentException("Null remote");
/* 169 */     this.remote = remote;
/*     */   }
/*     */ 
/*     */   public String getLocalHome()
/*     */   {
/* 179 */     return this.localHome;
/*     */   }
/*     */ 
/*     */   public void setLocalHome(String localHome)
/*     */   {
/* 190 */     if (localHome == null)
/* 191 */       throw new IllegalArgumentException("Null localHome");
/* 192 */     this.localHome = localHome;
/*     */   }
/*     */ 
/*     */   public String getLocal()
/*     */   {
/* 202 */     return this.local;
/*     */   }
/*     */ 
/*     */   public void setLocal(String local)
/*     */   {
/* 213 */     if (local == null)
/* 214 */       throw new IllegalArgumentException("Null local");
/* 215 */     this.local = local;
/*     */   }
/*     */ 
/*     */   public boolean isCMP()
/*     */   {
/* 225 */     if (this.persistenceType == null)
/* 226 */       return true;
/* 227 */     return this.persistenceType == PersistenceType.Container;
/*     */   }
/*     */ 
/*     */   public boolean isBMP()
/*     */   {
/* 237 */     return !isCMP();
/*     */   }
/*     */ 
/*     */   public PersistenceType getPersistenceType()
/*     */   {
/* 247 */     return this.persistenceType;
/*     */   }
/*     */ 
/*     */   public void setPersistenceType(PersistenceType persistenceType)
/*     */   {
/* 258 */     if (persistenceType == null)
/* 259 */       throw new IllegalArgumentException("Null persistenceType");
/* 260 */     this.persistenceType = persistenceType;
/*     */   }
/*     */ 
/*     */   public String getPrimKeyClass()
/*     */   {
/* 270 */     return this.primKeyClass;
/*     */   }
/*     */ 
/*     */   public void setPrimKeyClass(String primKeyClass)
/*     */   {
/* 281 */     if (primKeyClass == null)
/* 282 */       throw new IllegalArgumentException("Null primKeyClass");
/* 283 */     this.primKeyClass = primKeyClass;
/*     */   }
/*     */ 
/*     */   public boolean isReentrant()
/*     */   {
/* 293 */     return this.reentrant;
/*     */   }
/*     */ 
/*     */   public void setReentrant(boolean reentrant)
/*     */   {
/* 303 */     this.reentrant = reentrant;
/*     */   }
/*     */ 
/*     */   public boolean isCMP1x()
/*     */   {
/* 313 */     if (this.cmpVersion == null)
/*     */     {
/* 316 */       return (!getEjbJarMetaData().isEJB2x()) && (!getEjbJarMetaData().isEJB3x());
/*     */     }
/*     */ 
/* 320 */     return "1.x".equals(this.cmpVersion);
/*     */   }
/*     */ 
/*     */   public String getCmpVersion()
/*     */   {
/* 330 */     return this.cmpVersion;
/*     */   }
/*     */ 
/*     */   public void setCmpVersion(String cmpVersion)
/*     */   {
/* 341 */     if (cmpVersion == null)
/* 342 */       throw new IllegalArgumentException("Null cmpVersion");
/* 343 */     this.cmpVersion = cmpVersion;
/*     */   }
/*     */ 
/*     */   public String getAbstractSchemaName()
/*     */   {
/* 353 */     return this.abstractSchemaName;
/*     */   }
/*     */ 
/*     */   public void setAbstractSchemaName(String abstractSchemaName)
/*     */   {
/* 364 */     if (abstractSchemaName == null)
/* 365 */       throw new IllegalArgumentException("Null abstractSchemaName");
/* 366 */     this.abstractSchemaName = abstractSchemaName;
/*     */   }
/*     */ 
/*     */   public String getPrimKeyField()
/*     */   {
/* 376 */     return this.primKeyField;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="primkey-field")
/*     */   public void setPrimKeyField(String primKeyField)
/*     */   {
/* 388 */     if (primKeyField == null)
/* 389 */       throw new IllegalArgumentException("Null primKeyField");
/* 390 */     this.primKeyField = primKeyField;
/*     */   }
/*     */ 
/*     */   public CMPFieldsMetaData getCmpFields()
/*     */   {
/* 400 */     return this.cmpFields;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="cmp-field")
/*     */   public void setCmpFields(CMPFieldsMetaData cmpFields)
/*     */   {
/* 412 */     if (cmpFields == null)
/* 413 */       throw new IllegalArgumentException("Null cmpFields");
/* 414 */     this.cmpFields = cmpFields;
/*     */   }
/*     */ 
/*     */   public SecurityRoleRefsMetaData getSecurityRoleRefs()
/*     */   {
/* 424 */     return this.securityRoleRefs;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="security-role-ref")
/*     */   public void setSecurityRoleRefs(SecurityRoleRefsMetaData securityRoleRefs)
/*     */   {
/* 436 */     if (securityRoleRefs == null)
/* 437 */       throw new IllegalArgumentException("Null securityRoleRefs");
/* 438 */     this.securityRoleRefs = securityRoleRefs;
/*     */   }
/*     */ 
/*     */   public QueriesMetaData getQueries()
/*     */   {
/* 448 */     return this.queries;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="query")
/*     */   public void setQueries(QueriesMetaData queries)
/*     */   {
/* 460 */     if (queries == null)
/* 461 */       throw new IllegalArgumentException("Null queries");
/* 462 */     this.queries = queries;
/*     */   }
/*     */ 
/*     */   public String getDefaultConfigurationName()
/*     */   {
/* 468 */     boolean isCMP = isCMP();
/* 469 */     boolean isCMP1x = isCMP1x();
/*     */ 
/* 471 */     if (isCMP)
/*     */     {
/* 473 */       if (isCMP1x)
/*     */       {
/* 475 */         if (isClustered()) {
/* 476 */           return "Clustered CMP EntityBean";
/*     */         }
/* 478 */         return "Standard CMP EntityBean";
/*     */       }
/*     */ 
/* 482 */       if (isClustered()) {
/* 483 */         return "Clustered CMP 2.x EntityBean";
/*     */       }
/* 485 */       return "Standard CMP 2.x EntityBean";
/*     */     }
/*     */ 
/* 490 */     if (isClustered()) {
/* 491 */       return "Clustered BMP EntityBean";
/*     */     }
/* 493 */     return "Standard BMP EntityBean";
/*     */   }
/*     */ 
/*     */   public String getDefaultInvokerName()
/*     */   {
/* 500 */     boolean isCMP = isCMP();
/* 501 */     boolean isCMP1x = isCMP1x();
/* 502 */     if (isCMP)
/*     */     {
/* 504 */       if (isCMP1x)
/*     */       {
/* 506 */         if (isClustered()) {
/* 507 */           return "clustered-entity-rmi-invoker";
/*     */         }
/* 509 */         return "entity-unified-invoker";
/*     */       }
/*     */ 
/* 513 */       if (isClustered()) {
/* 514 */         return "clustered-entity-rmi-invoker";
/*     */       }
/* 516 */       return "entity-unified-invoker";
/*     */     }
/*     */ 
/* 521 */     if (isClustered()) {
/* 522 */       return "clustered-entity-rmi-invoker";
/*     */     }
/* 524 */     return "entity-unified-invoker";
/*     */   }
/*     */ 
/*     */   public String getJndiName()
/*     */   {
/* 535 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public void setJndiName(String jndiName)
/*     */   {
/* 546 */     if (jndiName == null)
/* 547 */       throw new IllegalArgumentException("Null jndiName");
/* 548 */     this.jndiName = jndiName;
/*     */   }
/*     */ 
/*     */   public String determineJndiName()
/*     */   {
/* 558 */     if (this.jndiName != null) {
/* 559 */       return this.jndiName;
/*     */     }
/* 561 */     String mapped = getMappedName();
/* 562 */     if (mapped != null)
/* 563 */       return mapped;
/* 564 */     return getEjbName();
/*     */   }
/*     */ 
/*     */   public String getContainerObjectNameJndiName()
/*     */   {
/* 570 */     boolean remote = false;
/* 571 */     if (getHome() != null)
/* 572 */       remote = true;
/* 573 */     return remote ? determineJndiName() : getLocalJndiName();
/*     */   }
/*     */ 
/*     */   protected String getDefaultInvokerJndiName()
/*     */   {
/* 579 */     return determineJndiName();
/*     */   }
/*     */ 
/*     */   public boolean isCallByValue()
/*     */   {
/* 589 */     return this.callByValue;
/*     */   }
/*     */ 
/*     */   public void setCallByValue(boolean callByValue)
/*     */   {
/* 599 */     this.callByValue = callByValue;
/*     */   }
/*     */ 
/*     */   public boolean isClustered()
/*     */   {
/* 609 */     return this.clustered;
/*     */   }
/*     */ 
/*     */   public void setClustered(boolean clustered)
/*     */   {
/* 619 */     this.clustered = clustered;
/*     */   }
/*     */ 
/*     */   public boolean isReadOnly()
/*     */   {
/* 629 */     return this.readOnly;
/*     */   }
/*     */ 
/*     */   public void setReadOnly(boolean readOnly)
/*     */   {
/* 639 */     this.readOnly = readOnly;
/*     */   }
/*     */ 
/*     */   public ClusterConfigMetaData getClusterConfig()
/*     */   {
/* 649 */     return this.clusterConfig;
/*     */   }
/*     */ 
/*     */   public ClusterConfigMetaData determineClusterConfig()
/*     */   {
/* 659 */     if (this.determinedClusterConfig == null)
/*     */     {
/* 661 */       ClusterConfigMetaData containerDefaults = null;
/* 662 */       ContainerConfigurationMetaData container = determineContainerConfiguration();
/* 663 */       if (container != null)
/* 664 */         containerDefaults = container.getClusterConfig();
/* 665 */       this.determinedClusterConfig = new ClusterConfigMetaData();
/* 666 */       this.determinedClusterConfig.merge(this.clusterConfig, containerDefaults);
/*     */     }
/* 668 */     return this.determinedClusterConfig;
/*     */   }
/*     */ 
/*     */   public void setClusterConfig(ClusterConfigMetaData clusterConfig)
/*     */   {
/* 679 */     if (clusterConfig == null)
/* 680 */       throw new IllegalArgumentException("Null clusterConfig");
/* 681 */     this.clusterConfig = clusterConfig;
/*     */   }
/*     */ 
/*     */   public boolean isCacheInvalidation()
/*     */   {
/* 691 */     return this.cacheInvalidation;
/*     */   }
/*     */ 
/*     */   public void setCacheInvalidation(boolean cacheInvalidation)
/*     */   {
/* 701 */     this.cacheInvalidation = cacheInvalidation;
/*     */   }
/*     */ 
/*     */   public CacheInvalidationConfigMetaData getCacheInvalidationConfig()
/*     */   {
/* 711 */     return this.cacheInvalidationConfig;
/*     */   }
/*     */ 
/*     */   public void setCacheInvalidationConfig(CacheInvalidationConfigMetaData cacheInvalidationConfig)
/*     */   {
/* 722 */     if (cacheInvalidationConfig == null)
/* 723 */       throw new IllegalArgumentException("Null cacheInvalidationConfig");
/* 724 */     cacheInvalidationConfig.setEntityBean(this);
/* 725 */     this.cacheInvalidationConfig = cacheInvalidationConfig;
/*     */   }
/*     */ 
/*     */   public void merge(JBossEnterpriseBeanMetaData override, EnterpriseBeanMetaData original, String overridenFile, String overrideFile, boolean mustOverride)
/*     */   {
/* 731 */     super.merge(override, original, overridenFile, overrideFile, mustOverride);
/* 732 */     JBossEntityBeanMetaData joverride = (JBossEntityBeanMetaData)override;
/* 733 */     EntityBeanMetaData soriginal = (EntityBeanMetaData)original;
/*     */ 
/* 736 */     if ((joverride != null) && (joverride.home != null))
/* 737 */       this.home = joverride.home;
/* 738 */     else if ((soriginal != null) && (soriginal.getHome() != null)) {
/* 739 */       this.home = soriginal.getHome();
/*     */     }
/* 741 */     if ((joverride != null) && (joverride.remote != null))
/* 742 */       this.remote = joverride.remote;
/* 743 */     else if ((soriginal != null) && (soriginal.getRemote() != null)) {
/* 744 */       this.remote = soriginal.getRemote();
/*     */     }
/* 746 */     if ((joverride != null) && (joverride.localHome != null))
/* 747 */       this.localHome = joverride.localHome;
/* 748 */     else if ((soriginal != null) && (soriginal.getLocalHome() != null)) {
/* 749 */       this.localHome = soriginal.getLocalHome();
/*     */     }
/* 751 */     if ((joverride != null) && (joverride.local != null))
/* 752 */       this.local = joverride.local;
/* 753 */     else if ((soriginal != null) && (soriginal.getLocal() != null)) {
/* 754 */       this.local = soriginal.getLocal();
/*     */     }
/* 756 */     if ((joverride != null) && (joverride.persistenceType != null))
/* 757 */       this.persistenceType = joverride.persistenceType;
/* 758 */     else if ((soriginal != null) && (soriginal.getPersistenceType() != null)) {
/* 759 */       this.persistenceType = soriginal.getPersistenceType();
/*     */     }
/* 761 */     if ((joverride != null) && (joverride.primKeyClass != null))
/* 762 */       this.primKeyClass = joverride.primKeyClass;
/* 763 */     else if ((soriginal != null) && (soriginal.getPrimKeyClass() != null)) {
/* 764 */       this.primKeyClass = soriginal.getPrimKeyClass();
/*     */     }
/* 766 */     if (soriginal != null) {
/* 767 */       this.reentrant = soriginal.isReentrant();
/*     */     }
/* 769 */     if ((joverride != null) && (joverride.cmpVersion != null))
/* 770 */       this.cmpVersion = joverride.cmpVersion;
/* 771 */     else if ((soriginal != null) && (soriginal.getCmpVersion() != null)) {
/* 772 */       this.cmpVersion = soriginal.getCmpVersion();
/*     */     }
/* 774 */     if ((joverride != null) && (joverride.abstractSchemaName != null))
/* 775 */       this.abstractSchemaName = joverride.abstractSchemaName;
/* 776 */     else if ((soriginal != null) && (soriginal.getAbstractSchemaName() != null)) {
/* 777 */       this.abstractSchemaName = soriginal.getAbstractSchemaName();
/*     */     }
/* 779 */     if ((joverride != null) && (joverride.cmpFields != null))
/* 780 */       this.cmpFields = joverride.cmpFields;
/* 781 */     else if ((soriginal != null) && (soriginal.getCmpFields() != null)) {
/* 782 */       this.cmpFields = soriginal.getCmpFields();
/*     */     }
/* 784 */     if ((joverride != null) && (joverride.primKeyField != null))
/* 785 */       this.primKeyField = joverride.primKeyField;
/* 786 */     else if ((soriginal != null) && (soriginal.getPrimKeyField() != null)) {
/* 787 */       this.primKeyField = soriginal.getPrimKeyField();
/*     */     }
/* 789 */     if ((joverride != null) && (joverride.securityRoleRefs != null))
/* 790 */       this.securityRoleRefs = joverride.securityRoleRefs;
/* 791 */     else if ((soriginal != null) && (soriginal.getSecurityRoleRefs() != null)) {
/* 792 */       this.securityRoleRefs = soriginal.getSecurityRoleRefs();
/*     */     }
/* 794 */     if ((joverride != null) && (joverride.queries != null))
/* 795 */       this.queries = joverride.queries;
/* 796 */     else if ((soriginal != null) && (soriginal.getQueries() != null)) {
/* 797 */       this.queries = soriginal.getQueries();
/*     */     }
/*     */ 
/* 800 */     if ((joverride != null) && (joverride.jndiName != null))
/* 801 */       this.jndiName = joverride.jndiName;
/* 802 */     else if ((soriginal != null) && (soriginal.getMappedName() != null)) {
/* 803 */       this.jndiName = soriginal.getMappedName();
/*     */     }
/* 805 */     if (joverride != null) {
/* 806 */       this.callByValue = joverride.callByValue;
/*     */     }
/* 808 */     if (joverride != null) {
/* 809 */       this.clustered = joverride.clustered;
/*     */     }
/* 811 */     if (joverride != null) {
/* 812 */       this.readOnly = joverride.readOnly;
/*     */     }
/* 814 */     if ((joverride != null) && (joverride.clusterConfig != null))
/* 815 */       this.clusterConfig = joverride.clusterConfig;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.jboss.JBossEntityBeanMetaData
 * JD-Core Version:    0.6.0
 */